<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Familia;
use Illuminate\Http\Request;

class FamiliaController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $familias = Familia::paginate();
        return view('admin.familias.index',compact('familias'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.familias.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'nombre'=>'required'
        ]);
        Familia::create($request->all());
        session()->flash('swal',[
            'icon'=> 'success',
            'title'=> 'Realizado',
            'text'=> 'Familia creada correctamente.'
        ]);
        return redirect()->route('admin.familias.index');
    }

    /**
     * Display the specified resource.
     */
    public function show(Familia $familia)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Familia $familia)
    {
        return view('admin.familias.edit', compact('familia'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Familia $familia)
    {
        $request->validate([
            'nombre'=>'required'
        ]);
        $familia->update($request->all());
        session()->flash('swal',[
            'icon'=> 'success',
            'title'=> 'Realizado',
            'text'=> 'Familia actualizada correctamente.'
        ]);
        return redirect()->route('admin.familias.index');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Familia $familia)
    {
        if($familia->categorias->count()>0 ){
            session()->flash('swal',[
                'icon'=> 'error',
                'title'=> 'Error!',
                'text'=> 'El registro no se puede eliminar.'
            ]);
            return redirect()->route('admin.familias.edit',$familia);
        }else{
            $familia->delete();
            session()->flash('swal',[
                'icon'=> 'success',
                'title'=> 'Eliminado!',
                'text'=> 'El registro fue eliminado.'
            ]);
            return redirect()->route('admin.familias.index');
        }
    }
}
