<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Producto;
use App\Models\Variante;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class ProductoController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $productos = Producto::paginate();
        return view('admin.productos.index', compact('productos'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.productos.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(Producto $producto)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Producto $producto)
    {
        return view('admin.productos.edit', compact('producto'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Producto $producto)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Producto $producto)
    {
        Storage::delete($producto->dir_imagen);

        $producto->delete();
        session()->flash('swal', [
            'icon' => 'success',
            'title' => 'Eliminado!',
            'text' => 'El registro fue eliminado.'
        ]);
    }


    public function variantes(Producto $producto, Variante $variante)
    {
        return view('admin.productos.variantes', compact('producto', 'variante'));
    }

    public function variantesUpdate(Request $request, Producto $producto, Variante $variante)
    {
        

        $data = $request->validate([
            'imagen' => 'nullable|image|max:1024',
            'codigo' => 'required',
            'stock' => 'required|numeric|min:0'
        ]);

        if ($request->imagen) {
            if ($variante->dir_imagen) {
                Storage::delete($variante->dir_imagen);
            }
            $data['dir_imagen'] = $request->imagen->store('productos');
        }

        $variante->update($data);

        session()->flash('swal', [
            'icon' => 'success',
            'title' => 'Actualizado!',
            'text' => 'La variante se actualizo correctamente'
        ]);

        return redirect()->route('admin.productos.variantes',[$producto,$variante]);
    }
}
