<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Subcategoria;
use Illuminate\Http\Request;

class SubcategoriaController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $subcategorias = Subcategoria::paginate();
        return view('admin.subcategorias.index',compact('subcategorias'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.subcategorias.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(Subcategoria $subcategoria)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Subcategoria $subcategoria)
    {
        return view('admin.subcategorias.edit', compact('subcategoria'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Subcategoria $subcategoria)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Subcategoria $subcategoria)
    {
        if($subcategoria->productos->count()>0 ){
            session()->flash('swal',[
                'icon'=> 'error',
                'title'=> 'Error!',
                'text'=> 'El registro no se puede eliminar.'
            ]);
            return redirect()->route('admin.subcategorias.edit',$subcategoria);
        }else{
            $subcategoria->delete();
            session()->flash('swal',[
                'icon'=> 'success',
                'title'=> 'Eliminado!',
                'text'=> 'El registro fue eliminado.'
            ]);
            return redirect()->route('admin.subcategorias.index');
        }
    }
}
