<?php

namespace App\Http\Controllers;

use App\Models\Portada;
use App\Models\Producto;
use Illuminate\Http\Request;

class WelcomeController extends Controller
{
    public function index(){
        $portadas = Portada::where('estado', true)->whereDate('inicio', '<=', now())->where(function($query){
            $query->whereDate('fin', '>=', now())->orWhereNull('fin');
        })->get();

        $ultimosProductos = Producto::orderBy('created_at', 'desc')->take(12)->get();
        return view('welcome', compact('portadas','ultimosProductos'));
    }
}
