<?php

namespace App\Livewire\Admin\Opciones;

use App\Livewire\Forms\Admin\Opciones\NuevaOpcionForm;
use App\Models\Caracteristica;
use App\Models\Opcion;
use Livewire\Attributes\On;
use Livewire\Component;

class AdministradorOpciones extends Component
{
    public $opciones;
    
    public NuevaOpcionForm $nuevaOpcion ;

    public function mount()
    {
        $this->opciones = Opcion::with('caracteristicas')->get();
    }
    
    #[On('caracteristicaAdded')]
    public function updateOpcionList(){
        $this->opciones = Opcion::with('caracteristicas')->get();
    }

    
    public function addCaracteristica()
    {
        $this->nuevaOpcion->addCaracteristica();
    }


    public function deleteCaracteristica(Caracteristica $caracteristica){
        $caracteristica->delete();
        $this->opciones = Opcion::with('caracteristicas')->get();
    }

    public function deleteOpcion(Opcion $opcion){
        $opcion->delete();
        $this->opciones = Opcion::with('caracteristicas')->get();
    }
    

    public function removeCaracteristica($index)
    {
        $this->nuevaOpcion->removeCaracteristica($index);
    }

    public function addOpcion(){
        

        $this->nuevaOpcion->save();
        $this->opciones = Opcion::with('caracteristicas')->get();
        $this->dispatch('swal',[
            'icon' => 'success',
            'title'=> 'Bien hecho!',
            'text' => 'La opción se agregó correctamente'
        ]);

        

    }
    public function render()
    {
        return view('livewire.admin.opciones.administrador-opciones');
    }
}
