<?php

namespace App\Livewire\Admin\Productos;

use App\Models\Caracteristica;
use App\Models\Opcion;
use App\Models\Variante;
use Livewire\Attributes\Computed;
use Livewire\Component;

class ProductoVariantes extends Component
{
    public $openModal = false;
    public $producto;
    public $opciones;
    public $variante = [
        'opcion_id' => '',
        'caracteristicas' => [
            [
                'id' => '',
                'valor' => '',
                'descripcion' => ''
            ]
        ]
    ];

    public function mount()
    {
        $this->opciones = Opcion::all();
    }

    public function updatedVarianteOpcionId()
    {
        $this->variante['caracteristicas'] = [
            [
                'id' => '',
                'valor' => '',
                'descripcion' => ''
            ]
        ];
    }

    #[Computed()]
    public function caracteristicas()
    {
        return Caracteristica::where('opcion_id', $this->variante['opcion_id'])->get();
    }

    public function addCaracteristica()
    {
        $this->variante['caracteristicas'][] = [
            'id' => '',
            'valor' => '',
            'descripcion' => ''
        ];
    }

    public function removeCaracteristica($index)
    {
        unset($this->variante['caracteristicas'][$index]);
        $this->variante['caracteristicas'] = array_values($this->variante['caracteristicas']);
    }

    public function caracteristica_change($index)
    {
        $caracteristica = Caracteristica::find($this->variante['caracteristicas'][$index]['id']);
        if ($caracteristica) {
            $this->variante['caracteristicas'][$index]['valor'] = $caracteristica->valor;
            $this->variante['caracteristicas'][$index]['descripcion'] = $caracteristica->descripcion;
        }
    }

    public function save()
    {
        $this->validate([
            'variante.opcion_id' => 'required',
            'variante.caracteristicas.*.id' => 'required',
            'variante.caracteristicas.*.valor' => 'required',
            'variante.caracteristicas.*.descripcion' => 'required',
        ]);

        $this->producto->opciones()->attach($this->variante['opcion_id'], [
            'caracteristicas' => $this->variante['caracteristicas']
        ]);
        $this->reset(['variante', 'openModal']);
        $this->producto = $this->producto->fresh();

        $this->generarVariantes();
    }



    public function deleteCaracteristica($opcion_id, $caracteristica_id)
    {
        $this->producto->opciones()->updateExistingPivot($opcion_id, [
            'caracteristicas' => array_filter(
                $this->producto->opciones->find($opcion_id)->pivot->caracteristicas,
                function ($caracteristica) use ($caracteristica_id) {
                    return $caracteristica['id'] != $caracteristica_id;
                }
            )
        ]);

        $this->generarVariantes();

        $this->producto = $this->producto->fresh();
    }

    public function deleteOpcion($opcion_id)
    {
        
        $this->producto->opciones()->detach($opcion_id);
        $this->generarVariantes();

        $this->producto = $this->producto->fresh();
    }


    public function generarVariantes() {
        $caracteristicas = $this->producto->opciones->pluck('pivot.caracteristicas');
        $combinaciones = $this->generarCombinaciones($caracteristicas);
        $this->producto->variantes()->delete();
        foreach($combinaciones as $combinacion){
            $variante = Variante::create([
                'producto_id' => $this->producto->id
            ]);

            $variante->caracteristicas()->attach($combinacion);
        }
        $this->dispatch('variante-generate');
    }

    public function  generarCombinaciones($arrays, $indice = 0, $combinacion = [])
    {

        if ($indice == count($arrays)) {

            return [$combinacion];
        }

        $resultado = [];

        foreach ($arrays[$indice] as $item) {

            $combinacionesTemporal = $combinacion;

            $combinacionesTemporal[] = $item['id'];

            $resultado = array_merge($resultado, $this->generarCombinaciones($arrays, $indice + 1, $combinacionesTemporal));
        }

        return  $resultado;
    }


    public function render()
    {
        return view('livewire.admin.productos.producto-variantes');
    }
}
