<?php

namespace App\Livewire\Admin\Productos;

use App\Models\Categoria;
use App\Models\Familia;
use App\Models\Producto;
use App\Models\Subcategoria;
use Livewire\Attributes\Computed;
use Livewire\Component;
use Livewire\WithFileUploads;

class ProductosCreate extends Component
{
    use WithFileUploads;

    public $familias;
    public $imagen;

    public $producto = [
        'codigo' => '',
        'nombre' => '',
        'descripcion' => '',
        'dir_imagen' => '',
        'precio' => '',
        'stock' => '0',
        'subcategoria_id' => '',
        'categoria_id' => '',
        'familia_id' => ''
    ];

    public function mount(){
        $this->familias= Familia::all();
    }

    public function boot(){
        $this->withValidator(function($validator){
            if($validator->fails()){
                $this->dispatch('swal',[
                    'icon'=> 'error',
                    'title'=> '¡Error!',
                    'text'=>'El formulario contiene errores',
                    'confirmButtonColor'=> '#3085d6',
                ]);
            }
        });
    }

    public function updatedProductoFamiliaId(){
        $this->producto['categoria_id']='';
        $this->producto['subcategoria_id']='';
        
    }

    public function updatedProductoCategoriaId(){
        $this->producto['subcategoria_id']='';
        
    }

    
    #[Computed()]
    public function categorias(){
        return Categoria::where('familia_id',$this->producto['familia_id'])->get();
    }

    #[Computed()]
    public function subcategorias(){
        return Subcategoria::where('categoria_id',$this->producto['categoria_id'])->get();
    }
    
    public function save()
    {
        //dd($this->rendcuentas);
        $this->validate([
            'producto.familia_id' => 'required|integer|exists:familias,id',
            'producto.categoria_id' => 'required|integer|exists:categorias,id',
            'producto.subcategoria_id' => 'required|integer|exists:subcategorias,id',
            'producto.codigo' => 'required|unique:productos,codigo',
            'producto.nombre' => 'required|string|max:255',
            'producto.descripcion' => 'required',
            'producto.precio' => 'required|numeric|min:1',
            'imagen' => 'required|image|max:1024',
        ],[],[
            'producto.familia_id' => 'Familia',
            'producto.categoria_id' => 'Categoria',
            'producto.subcategoria_id' => 'Subategoria',
            'producto.codigo' => 'Codigo',
            'producto.nombre' => 'Nombre',
            'producto.descripcion' => 'Descripcion',
            'producto.precio' => 'Precio',
            'producto.stock' => 'Stock',
            'imagen' => 'Imagen',
            
        ]);
        
        $this->producto['dir_imagen'] = $this->imagen->store('productos');
        Producto::create($this->producto);
        

        session()->flash('swal',[
            'icon'=> 'success',
            'title'=> 'Realizado',
            'text'=> 'Producto creada correctamente.'
        ]);
        
        return redirect()->route('admin.productos.edit',compact('producto'));
    }

    public function render()
    {
        return view('livewire.admin.productos.productos-create');
    }
}
