<?php

namespace App\Livewire\Admin\Productos;

use App\Models\Categoria;
use App\Models\Familia;
use App\Models\Producto;
use App\Models\Subcategoria;
use Illuminate\Support\Facades\Storage;
use Livewire\Attributes\Computed;
use Livewire\Attributes\On;
use Livewire\Component;
use Livewire\WithFileUploads;

class ProductosEdit extends Component
{
    use WithFileUploads;
    public $familias;
    public $imagen;

    public $producto;
    
    
    public $productoEdit= [
        'codigo' => '',
        'nombre' => '',
        'descripcion' => '',
        'dir_imagen' => '',
        'precio' => '',
        'stock' => '',
        'subcategoria_id' => '',
        'categoria_id' => '',
        'familia_id' => ''
    ];

    public function mount(Producto $producto){
        $this->familias= Familia::all();
        $this->productoEdit= [
            'codigo' => $producto->codigo,
            'nombre' => $producto->nombre,
            'descripcion' => $producto->descripcion,
            'dir_imagen' => $producto->dir_imagen,
            'precio' => $producto->precio,
            'stock' => $producto->stock,
            'subcategoria_id' => $producto->subcategoria_id,
            'categoria_id' => $producto->subcategoria->categoria_id,
            'familia_id' => $producto->subcategoria->categoria->familia_id
        ];
    }


    public function updatedProductoFamiliaId(){
        $this->producto['categoria_id']='';
        $this->producto['subcategoria_id']='';
        
    }

    public function updatedProductoCategoriaId(){
        $this->producto['subcategoria_id']='';
        
    }

    #[On('variante-generate')]
    public function updateProducto(){
        $this->producto = $this->producto->fresh();
    }

    
    #[Computed()]
    public function categorias(){
        return Categoria::where('familia_id',$this->productoEdit['familia_id'])->get();
    }

    #[Computed()]
    public function subcategorias(){
        return Subcategoria::where('categoria_id',$this->productoEdit['categoria_id'])->get();
    }

    public function save()
    {
        //dd($this->rendcuentas);
        $this->validate([
            'productoEdit.familia_id' => 'required|integer|exists:familias,id',
            'productoEdit.categoria_id' => 'required|integer|exists:categorias,id',
            'productoEdit.subcategoria_id' => 'required|integer|exists:subcategorias,id',
            'productoEdit.codigo' => 'required|unique:productos,codigo,'. $this->producto->id,
            'productoEdit.nombre' => 'required|string|max:255',
            'productoEdit.descripcion' => 'nullable',
            'productoEdit.precio' => 'required|numeric|min:1',
            'productoEdit.stock' => 'required|numeric|min:0',
            'imagen' => 'nullable|image|max:1024',
        ],[],[
            'productoEdit.familia_id' => 'Familia',
            'productoEdit.categoria_id' => 'Categoria',
            'productoEdit.subcategoria_id' => 'Subategoria',
            'productoEdit.codigo' => 'Codigo',
            'productoEdit.nombre' => 'Nombre',
            'productoEdit.descripcion' => 'Descripcion',
            'productoEdit.precio' => 'Precio',
            'productoEdit.stock' => 'Stock',
            'imagen' => 'Imagen',
            
        ]);

        if($this->imagen){
            Storage::delete($this->productoEdit['dir_imagen']);
            $this->productoEdit['dir_imagen'] = $this->imagen->store('productos');
        }
        
        $this->producto->update($this->productoEdit);
        

        $this->dispatch('swal',[
            'icon'=> 'success',
            'title'=> '¡Producto actualizado!',
            'text'=> 'El producto se actualizó correctamente'
        ]);
        
    }

    public function render()
    {
        return view('livewire.admin.productos.productos-edit');
    }
}
