<?php

namespace App\Livewire\Admin\Subcategorias;

use App\Models\Categoria;
use App\Models\Familia;
use App\Models\Subcategoria;
use Livewire\Attributes\Computed;
use Livewire\Component;

class SubcategoriasCreate extends Component
{
    public $familias;
    public $subcategoria=[
        'familia_id'=>'',
        'categoria_id'=>'',
        'nombre'=>''
    ];

    public function mount(){
        $this->familias= Familia::all();
    }

    public function updatedSubcategoriaFamiliaId(){
        $this->subcategoria['categoria_id']='';
        
    }

    #[Computed()]
    public function categorias(){
        return Categoria::where('familia_id',$this->subcategoria['familia_id'])->get();
    }

    public function save()
    {
        //dd($this->rendcuentas);
        $this->validate([
            'subcategoria.familia_id' => 'required|integer|exists:familias,id',
            'subcategoria.categoria_id' => 'required|integer|exists:categorias,id',
            'subcategoria.nombre' => 'required|string|max:255',
        ],[],[
            'subcategoria.familia_id' => 'Familia',
            'subcategoria.categoria_id' => 'Categoria',
            'subcategoria.nombre' => 'Nombre',
            
        ]);
        Subcategoria::create($this->subcategoria);
        

        session()->flash('swal',[
            'icon'=> 'success',
            'title'=> 'Realizado',
            'text'=> 'Subcategoria creada correctamente.'
        ]);
        
        return redirect()->route('admin.subcategorias.index');
    }

    public function render()
    {
        return view('livewire.admin.subcategorias.subcategorias-create');
    }
}
