<?php

namespace App\Livewire\Admin\Subcategorias;

use App\Models\Categoria;
use App\Models\Familia;
use App\Models\Subcategoria;
use Livewire\Attributes\Computed;
use Livewire\Component;

class SubcategoriasEdit extends Component
{
    public $subcategoria;
    public $familias;
    public $subcategoriaEdit=[
        'familia_id'=>'',
        'categoria_id'=>'',
        'nombre'=>''
    ];

    public function mount(Subcategoria $subcategoria){
        $this->familias= Familia::all();
        $this->subcategoriaEdit=[
            'familia_id'=>$subcategoria->categoria->familia_id,
            'categoria_id'=>$subcategoria->categoria_id,
            'nombre'=>$subcategoria->nombre
        ];
    }

    public function updatedSubcategoriaEditFamiliaId(){
        $this->subcategoriaEdit['categoria_id']='';
        
    }

    public function save()
    {
        //dd($this->rendcuentas);
        $this->validate([
            'subcategoriaEdit.familia_id' => 'required|integer|exists:familias,id',
            'subcategoriaEdit.categoria_id' => 'required|integer|exists:categorias,id',
            'subcategoriaEdit.nombre' => 'required|string|max:255',
        ],[],[
            'subcategoriaEdit.familia_id' => 'Familia',
            'subcategoriaEdit.categoria_id' => 'Categoria',
            'subcategoriaEdit.nombre' => 'Nombre',
            
        ]);
        $this->subcategoria->update($this->subcategoriaEdit);

        session()->flash('swal',[
            'icon'=> 'success',
            'title'=> 'Realizado',
            'text'=> 'Subcategoria actualizada correctamente.'
        ]);
        
        return redirect()->route('admin.subcategorias.index');
    }

    #[Computed()]
    public function categorias(){
        return Categoria::where('familia_id',$this->subcategoriaEdit['familia_id'])->get();
    }
    
    public function render()
    {
        return view('livewire.admin.subcategorias.subcategorias-edit');
    }
}
