<?php

namespace App\Livewire\Admin;

use App\Models\User;
use Livewire\Component;

class UserComponent extends Component
{

    public function assignRole(User $user, $value){

        if($value == '1'){
            $user->assignRole('admin');
        }else{
            $user->removeRole('admin');
        }
    }

    public function render()
    {

        $users = User::where('email','<>', auth()->user()->email)->paginate();
        return view('livewire.admin.user-component', compact('users'))->layout('layouts.admin');
    }
}
