<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class Portada extends Model
{
    use HasFactory;

    protected $fillable = [
        'dir_imagen',
        'titulo',
        'inicio',
        'fin',
        'estado'
    ];


    protected $casts = [
        'inicio' => 'datetime',
        'fin' => 'datetime',
        'estado' => 'boolean'
    ];

    protected function imagen(): Attribute{
        return Attribute::make(
            get: fn() => Storage::url($this->dir_imagen),
        );
    }


}
