<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class Producto extends Model
{
    use HasFactory;

    protected $fillable = [
        'codigo',
        'nombre',
        'descripcion',
        'dir_imagen',
        'precio',
        'stock',
        'subcategoria_id'
    ];

   
    public function subcategoria(){
        return $this->belongsTo(Subcategoria::class);
    }

    public function variantes(){
        return $this->hasMany(Variante::class);
    }

    public function opciones(){
        return $this->belongsToMany(Opcion::class)
                    ->using(OpcionProducto::class)
                    ->withPivot('caracteristicas')
                    ->withTimestamps();
    }

    protected function imagen(): Attribute{
        return Attribute::make(
            get: fn() => Storage::url($this->dir_imagen),
        );
    }
}
