<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class Variante extends Model
{
    use HasFactory;

    protected $fillable = [
        'codigo',
        'dir_imagen',
        'stock',
        'producto_id'
    ];

    protected function imagen(): Attribute{
        return Attribute::make(
            get: fn() => $this->dir_imagen ? Storage::url($this->dir_imagen) : asset('img/upload.png'),
        );

    }

    public function producto(){
        return $this->belongsTo(Producto::class);
    }

    

    public function caracteristicas(){
        return $this->belongsToMany(Caracteristica::class)
                    ->withTimestamps();
    }
}
