<?php

namespace Database\Seeders;

use App\Models\Categoria;
use App\Models\Familia;
use App\Models\Subcategoria;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class FamiliaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */


    public function run(): void
    {
        $familias = [
            'Moda Hombre' => [
                'Tendencias y colecciones' => [
                    'Colección de verano',
                    'Lo mas nuevo',
                ],
                'Ropa de hombre por tipo' => [
                    'Abrigos',
                    'Camisas',
                    'Camisetas',
                    'Jeans',
                    'Pantalones',
                    'Polos',
                    'Ropa interior',
                    'Shorts',
                    'Trajes',
                    'Zapatos',
                ],
                'Ropa interior y pijamas' => [
                    'Boxers',
                    'Pijamas',
                    'Ropa interior',
                ],
                'Calzado hombre' => [
                    'Botas',
                    'Casuales',
                    'Formales',
                    'Otros',
                    'Sandalias',
                    'Zapatillas',
                ],
            ],
            'Moda Mujer' => [
                'Tendencias y colecciones' => [
                    'Colección de verano',
                    'Lo mas nuevo',
                    'Comodidad',
                    'Colección otoño invierno',
                ],
                'Ropa de mujer por tipo' => [
                    'Abrigos',
                    'Blusas',
                    'Camisas',
                    'Camisetas',
                    'Jeans',
                    'Pantalones',
                    'Polos',
                    'Ropa interior',
                    'Shorts',
                    'Vestidos',
                    'Zapatos',
                ],
                'Ropa interior y pijamas' => [
                    'Pijamas',
                    'Ropa interior',
                ],
                'Calzado mujer' => [
                    'Botas',
                    'Casuales',
                    'Formales',
                    'Otros',
                    'Sandalias',
                    'Zapatillas',
                ],
            ]

        ];

        foreach ($familias as $familia => $categorias) {
            $familiaNueva = Familia::create([
                'nombre' => $familia
            ]);

            foreach ($categorias as $categoria => $subcategorias) {
                $categoriaNueva = Categoria::create([
                    'nombre' => $categoria,
                    'familia_id' => $familiaNueva->id
                ]);

                foreach ($subcategorias as $subcategoria) {
                    Subcategoria::create([
                        'nombre' => $subcategoria,
                        'categoria_id' => $categoriaNueva->id
                    ]);
                }
            }
        }
    }
}
