<?php

namespace Database\Seeders;

use App\Models\Opcion;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class OpcionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $opciones = [
            [
                'nombre' => 'Talla',
                'tipo' => 1,
                'caracteristicas' => [
                    [
                        'valor' => 's',
                        'descripcion' => 'pequeño'
                    ],
                    [
                        'valor' => 'm',
                        'descripcion' => 'mediano'
                    ],
                    [
                        'valor' => 'l',
                        'descripcion' => 'grande'
                    ],
                    [
                        'valor' => 'xl',
                        'descripcion' => 'extra grande'
                    ],
                ]
            ],
            [
                'nombre' => 'Color',
                'tipo' => 2,
                'caracteristicas' => [
                    [
                        'valor' => '#000000',
                        'descripcion' => 'negro'
                    ],
                    [
                        'valor' => '#ffffff',
                        'descripcion' => 'blanco'
                    ]
                ]
            ],
            [
                'nombre' => 'Sexo',
                'tipo' => 1,
                'caracteristicas' => [
                    [
                        'valor' => 'm',
                        'descripcion' => 'masculino'
                    ],
                    [
                        'valor' => 'f',
                        'descripcion' => 'femenino'
                    ]
                ]
            ],
        ];

        foreach ($opciones as $opcion) {
            $opcionModel = Opcion::create([
                'nombre' => $opcion['nombre'],
                'tipo' => $opcion['tipo'],
            ]);
            foreach ($opcion['caracteristicas'] as $caracteristica) {
                $opcionModel->caracteristicas()->create([
                    
                    'valor' => $caracteristica['valor'],
                    'descripcion' => $caracteristica['descripcion']
                ]);
            }
        }
    }
}
