<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;

class RolSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $admin = Role::create([
            'name' => 'admin',
        ]);

        $admin->syncPermissions([
            'accesos dashboard',
            'admin usuarios',
            'admin opciones',
            'admin familias',
            'admin categorias',
            'admin subcategorias',
            'admin productos',
            'admin portadas',
        ]);

        $user = User::find(1);
        $user->assignRole('admin');

    }
}
