<x-admin-layout :breadcrumbs="[
    [
        'name' => 'Dashboard',
        'route' => route('admin.dashboard'),
    ],
    [
        'name' => 'Categorias',
        'route' => route('admin.categorias.index'),
    ],
    [
        'name' => 'Nuevo',
    ],
]">



    <div class="card">
        <form action="{{ route('admin.categorias.store') }}" method="POST">
            @csrf
            <div class="mb-4">
                <x-label class="mb-2">Familia</x-label>
                <x-select name="familia_id" class="w-full detail-field" readonly>
                    <option value="" selected disabled>Seleccione una familia</option>
                    @foreach ($familias as $familia)
                        <option value="{{ $familia->id }}">{{ $familia->nombre }}</option>
                    @endforeach
                </x-select>

            </div>
            <div class="mb-4">
                <x-label class="mb-2">Nombre</x-label>
                <x-input class="w-full" placeholder="Ingrese el nombre de la Categoria" name="nombre"
                    value="{{ old('nombre') }}" />

            </div>
            <div class="flex justify-end">
                <x-button>
                    Guardar
                </x-button>
            </div>
        </form>
    </div>

</x-admin-layout>
