<x-admin-layout :breadcrumbs="[
    [
        'name' => 'Dashboard',
        'route' => route('admin.dashboard'),
    ],
    [
        'name' => 'Categorias',
        'route' => route('admin.categorias.index'),
    ],
    [
        'name' => $categoria->nombre,
    ],
]">

    <div class="card">
        <form action="{{ route('admin.categorias.update', $categoria) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="mb-4">
                <x-label class="mb-2">Familia</x-label>
                <x-select name="familia_id" class="w-full detail-field">
                    @foreach ($familias as $familia)
                        <option @if ($familia->id == $categoria->familia_id) selected @endif value={{ $familia->id }}>
                            {{ $familia->nombre }}</option>
                    @endforeach
                </x-select>

            </div>
            <div class="mb-4">
                <x-label class="mb-2">Nombre</x-label>
                <x-input class="w-full" placeholder="Ingrese el nombre de la Categoria" name="nombre"
                    value="{{ old('nombre', $categoria->nombre) }}" />

            </div>
            <div class="flex justify-end space-x-2">
                <x-button>
                    Actualizar
                </x-button>
                <x-danger-button onclick="confirmDelete()">
                    Eliminar
                </x-danger-button>
            </div>
        </form>
    </div>

    <form action="{{ route('admin.categorias.destroy', $categoria) }}" method="POST" id="delete-form">
        @csrf
        @method('DELETE')
    </form>

    @push('js')
        <script>
            function confirmDelete() {
                Swal.fire({
                    title: "¿Estas Seguro?",
                    text: "No se podra revertir",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Si, eliminar",
                    cancelButtonText: "Cancelar"
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById('delete-form').submit();
                        
                    }
                });
            }
        </script>
    @endpush
</x-admin-layout>
