<x-admin-layout :breadcrumbs="[
    [
        'name' => 'Dashboard',
        'route' => route('admin.dashboard'),
    ],
    [
        'name' => 'Familias',
        'route' => route('admin.familias.index'),
    ],
    [
        'name' => $familia->nombre,
    ],
]">

    <div class="card">
        <form action="{{ route('admin.familias.update', $familia) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="mb-4">
                <x-label class="mb-2">Nombre</x-label>
                <x-input class="w-full" placeholder="Ingrese el nombre de la Familia" name="nombre"
                    value="{{ old('nombre', $familia->nombre) }}" />

            </div>
            <div class="flex justify-end space-x-2">
                <x-button>
                    Actualizar
                </x-button>
                <x-danger-button onclick="confirmDelete()">
                    Eliminar
                </x-danger-button>
            </div>
        </form>
    </div>

    <form action="{{ route('admin.familias.destroy', $familia) }}" method="POST" id="delete-form">
        @csrf
        @method('DELETE')
    </form>

    @push('js')
        <script>
            function confirmDelete() {
                Swal.fire({
                    title: "¿Estas Seguro?",
                    text: "No se podra revertir",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Si, eliminar",
                    cancelButtonText: "Cancelar"
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById('delete-form').submit();
                        
                    }
                });
            }
        </script>
    @endpush
</x-admin-layout>
