<x-admin-layout :breadcrumbs="[
    [
        'name' => 'Dashboard',
        'route' => route('admin.dashboard'),
    ],
    [
        'name' => 'Portadas',
    ],
]">

    <x-slot name="action">
        <a class="btn btn-blue" href="{{ route('admin.portadas.create') }}">
            Nuevo
        </a>

    </x-slot>

    @if ($portadas->count())

        <ul class="space-y-4" id="portadas">
            @foreach ($portadas as $portada)
                <li class="bg-white rounded-lg shadow-lg overflow-hidden lg:flex cursor-move" data-id="{{$portada->id}}">
                    <img src="{{ $portada->imagen }}" alt=""
                        class="w-full lg:w-64 aspect-[3/1] object-cover object-center">
                    <div class="p-4 lg:flex-1 lg:flex lg:justify-between lg:items-center space-y-3 lg:space-y-0">
                        <div>
                            <h1 class="font-semibold">{{ $portada->titulo }}</h1>
                            <p>
                                @if ($portada->estado)
                                    <span
                                        class="bg-green-100 text-green-800 text-xs font-medium me-2 px-2.5 py-0.5 rounded dark:bg-green-900 dark:text-green-300">Activo</span>
                                @else
                                    <span
                                        class="bg-red-100 text-red-800 text-xs font-medium me-2 px-2.5 py-0.5 rounded dark:bg-red-900 dark:text-red-300">Inactivo</span>
                                @endif
                            </p>
                        </div>
                        <div>
                            <p class="text-sm font-bold">
                                Fecha de inicio
                            </p>
                            <p>{{ $portada->inicio->format('d/m/Y') }}</p>
                        </div>
                        <div>
                            <p class="text-sm font-bold">
                                Fecha de finalización
                            </p>
                            <p>{{ $portada->fin ? $portada->fin->format('d/m/Y') : '-' }}</p>
                        </div>
                        <div>
                            <a class="btn btn-blue" href="{{ route('admin.portadas.edit', $portada) }}">
                                Editar
                            </a>
                        </div>
                    </div>

                </li>
            @endforeach
        </ul>
    @else
        <div class="p-4 mb-4 text-sm text-blue-800 rounded-lg bg-blue-50 dark:bg-gray-800 dark:text-blue-400"
            role="alert">
            <span class="font-medium">Info alert!</span> Todavia no hay portadas registradas
        </div>
    @endif

    @push('js')
        <script src="https://cdnjs.cloudflare.com/ajax/libs/Sortable/1.15.3/Sortable.min.js"></script>
        <script>
            new Sortable(portadas, {
                animation: 150,
                ghostClass: 'bg-blue-100'
                store: {
                    set: (sortable) => {
                        const sorts = sortable.toArray();
                        axios.post("{{route('api.sort.portadas')}}", {
                            sorts: sorts
                        }).catch((error) => {
                            console.log(error)
                        })
                    }
                }
            });
        </script>
    @endpush

</x-admin-layout>
