<x-admin-layout :breadcrumbs="[
    [
        'name' => 'Dashboard',
        'route' => route('admin.dashboard'),
    ],
    [
        'name' => 'Productos',
        'route' => route('admin.productos.index'),
    ],
    [
        'name' => $producto->nombre,
        'route' => route('admin.productos.edit', $producto),
    ],
    [
        'name' => $variante->caracteristicas->pluck('descripcion')->implode(', '),
    ],
]">

    <form action="{{ route('admin.productos.variantesUpdate', [$producto, $variante]) }}" method="POST" enctype="multipart/form-data">
        @csrf

        @method('PUT')

        <x-validation-errors class="mb-6"/>
        <div class="relative mb-6">
            <figure>
                <img class="aspect-[16/9] w-full object-cover object-center" src="{{ $variante->imagen }}" alt=""
                    id="imgPreview">
            </figure>
            <div class="absolute top-8 right-8">
                <label class="flex items-center bg-gray-500 px-4 py-2 rounded-lg cursor-pointer">
                    <i class="fas fa-camera mr-2"></i>
                    Actualizar imagen
                    <input name="imagen" class="hidden" type="file" accept="image/*" onchange="previewImage(event, '#imgPreview')">
                </label>
            </div>

        </div>
        <div class="card">
            <div class="mb-4">
                <x-label class="mb-1">Codigo</x-label>
                <x-input class="w-full" name="codigo" placeholder="Ingrese el código del producto"
                    value="{{ old('codigo', $variante->codigo) }}" />
            </div>
            <div class="mb-4">
                <x-label class="mb-2">Stock</x-label>
                <x-input class="w-full" name="stock" placeholder="Ingrese la cantidad existente del producto"
                    value="{{ old('stock', $variante->stock) }}" type="number" step='1' />
            </div>


        </div>

        <div class="flex justify-end">
            <x-button>
                Actualizar
            </x-button>
        </div>
    </form>

    @push('js')
        <script>
            function previewImage(event, querySelector) {

                //Recuperamos el input que desencadeno la acción
                const input = event.target;

                //Recuperamos la etiqueta img donde cargaremos la imagen
                $imgPreview = document.querySelector(querySelector);

                // Verificamos si existe una imagen seleccionada
                if (!input.files.length) return

                //Recuperamos el archivo subido
                file = input.files[0];

                //Creamos la url
                objectURL = URL.createObjectURL(file);

                //Modificamos el atributo src de la etiqueta img
                $imgPreview.src = objectURL;

            }
        </script>
    @endpush

</x-admin-layout>
