<div>
    <section class="rounded-lg bg-white shadow-lg">
        <header class="border-b border-gray-200 px-6 py-2">
            <div class="flex justify-between">
                <h1 class="text-lg font-semibold text-gray-700">
                    Opciones
                </h1>
                <x-button wire:click="$set('nuevaOpcion.openModal', true)">Nuevo</x-button>
            </div>
        </header>
        <div class="p-6">

            <div class="space-y-6">
                @foreach ($opciones as $opcion)
                    <div class="p-6 rounded-lg border border-gray-200 relative" wire:key="opcion-{{ $opcion->id }}">
                        <div class="absolute -top-3 px-4 bg-white ">
                            <button class="mr-1" onclick="confirmDelete({{ $opcion->id }},'opcion')">
                                <i class="fa-solid fa-trash-can text-red-500 hover:text-red-600"></i>
                            </button>
                            <span>{{ $opcion->nombre }}</span>

                        </div>
                        {{--Valores--}}
                        <div class="flex flex-wrap mb-4">
                            @foreach ($opcion->caracteristicas as $caracteristica)
                                @switch($opcion->tipo)
                                    @case(1)
                                        <span
                                            class="bg-gray-100 text-gray-800 text-xs font-medium me-2 pl-2.5  pr-1.5 py-0.5 rounded dark:bg-gray-700 dark:text-gray-400 border border-gray-500">
                                            {{ $caracteristica->descripcion }}
                                            <button class="ml-1"
                                                onclick="confirmDelete({{ $caracteristica->id }}, 'caracteristica')">
                                                <i class="fa-solid fa-xmark hover:text-red-500"></i>
                                            </button>

                                        </span>
                                    @break

                                    @case(2)
                                        <div class="relative">
                                            <span
                                                class="inline-block h-6 w-6 shadow-lg rounded-full border-2 border-gray-300 mr-4"
                                                style="background-color: {{ $caracteristica->valor }}">
                                            </span>

                                            <button
                                                class="absolute z-10 left-3 -top-2 rounded-full bg-red-500 hover:bg-red-600 h-4 w-4 flex justify-center items-center"
                                                onclick="confirmDelete({{ $caracteristica->id }},'caracteristica')">
                                                <i class="fa-solid fa-xmark text-white text-xs"></i>
                                            </button>
                                        </div>
                                    @break

                                    @default
                                @endswitch
                            @endforeach
                        </div>
                        <div>
                            @livewire('admin.opciones.add-nueva-caracteristica', ['opcion' => $opcion], key('add-nueva-caracteristica-' . $opcion->id))
                        </div>

                    </div>
                @endforeach
            </div>

        </div>
    </section>

    {{--  MODAL --}}
    <x-dialog-modal wire:model="nuevaOpcion.openModal">
        <x-slot name="title">
            Crear nueva opción
        </x-slot>

        <x-slot name="content">
            <x-validation-errors class="mb-4" />
            <div class="grid grid-cols-2 gap-6 mb-4">
                <div>
                    <x-label class="mb-1">Nombre</x-label>
                    <x-input class="w-full" placeholder="Ejemplo: Tamaño - Color" wire:model="nuevaOpcion.nombre" />

                </div>
                <div>
                    <x-label class="mb-1">Tipo</x-label>
                    <x-select class="w-full " wire:model.live="nuevaOpcion.tipo">
                        <option value="1">Texto</option>
                        <option value="2">Color</option>

                    </x-select>
                </div>

            </div>
            <div class="flex items-center mb-4">
                <hr class="flex-1">
                <span class="mx-4">
                    Valores
                </span>
                <hr class="flex-1">
            </div>
            <div class="mb-4 space-y-4">
                @foreach ($nuevaOpcion->caracteristicas as $index => $caracteristica)
                    <div class="p-6 rounded-lg border border-gray-200 relative"
                        wire:key='caracteristicas-{{ $index }}'>
                        <div class="absolute -top-3 px-4 bg-white">
                            <button wire:click="removeCaracteristica({{ $index }})">
                                <i class="fa-solid fa-trash-can text-red-500 hover:text-red-600"></i></button>
                        </div>
                        <div class="grid grid-cols-2 gap-6">
                            <div>
                                <x-label class="mb-1">Valor</x-label>
                                @switch($nuevaOpcion->tipo)
                                    @case(1)
                                        <x-input class="w-full" wire:model="nuevaOpcion.caracteristicas.{{ $index }}.valor"
                                            placeholder="Ingrese el valor de la Opción" />
                                    @break

                                    @case(2)
                                        <div
                                            class="border border-gray-300 rounded-md h-[42px] flex items-center justify-between px-3">
                                            {{ $nuevaOpcion->caracteristicas[$index]['valor'] ?: 'Seleccione un color' }}
                                            <input type="color" wire:model.live="nuevaOpcion.caracteristicas.{{ $index }}.valor">
                                        </div>
                                    @break

                                    @default
                                @endswitch

                            </div>
                            <div>
                                <x-label class="mb-1">Descripcion</x-label>
                                <x-input class="w-full"
                                    wire:model="nuevaOpcion.caracteristicas.{{ $index }}.descripcion"
                                    placeholder="Ingrese la descripción" />

                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="flex justify-end">
                <x-button wire:click="addCaracteristica">
                    Agregar Valor
                </x-button>

            </div>


        </x-slot>

        <x-slot name="footer">
            <button class="btn btn-blue" wire:click="addOpcion">
                Agregar
            </button>
        </x-slot>

    </x-dialog-modal>



    @push('js')
        <script>
            function confirmDelete(id, tipo) {
                Swal.fire({
                    title: "¿Estas Seguro?",
                    text: "No se podra revertir",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Si, eliminar",
                    cancelButtonText: "Cancelar"
                }).then((result) => {
                    if (result.isConfirmed) {
                        switch (tipo) {
                            case 'caracteristica':
                                @this.call('deleteCaracteristica', id);
                                break;

                            case 'opcion':
                                @this.call('deleteOpcion', id);
                                break;

                        }


                    }
                });
            }
        </script>
    @endpush
</div>
