<div>
    <section class="rounded-lg border border-gray-100 bg-white shadow-lg mb-12">
        <header class="border-b border-gray-200 px-6 py-2">
            <div class="flex justify-between">
                <h1 class="text-lg font-semibold text-gray-700">
                    Opciones
                </h1>
                <x-button wire:click="$set('openModal', true)">Nuevo</x-button>
            </div>
        </header>

        <div class="p-6">
            <div class="space-y-6">
                @if ($producto->opciones->count())
                    @foreach ($producto->opciones as $opcion)
                        <div wire:key="producto-opcion-{{ $opcion->id }}"
                            class="p-6 rounded-lg border border-gray-200 relative">
                            <div class="absolute -top-3 px-4 bg-white">
                                <button onclick="confirmDeleteOpcion({{ $opcion->id }})">
                                    <i class="fa-solid fa-trash-can text-red-500 hover:text-red-600"></i>
                                </button>
                                <span class="ml-2">{{ $opcion->nombre }}</span>
                            </div>
                            <div class="flex flex-wrap ml-4">
                                @foreach ($opcion->pivot->caracteristicas as $caracteristica)
                                    <div
                                        wire:key="opcion-{{ $opcion['id'] }}-caraceristica-{{ $caracteristica['id'] }}">
                                        @switch($opcion->tipo)
                                            @case(1)
                                                <span
                                                    class="bg-gray-100 text-gray-800 text-xs font-medium me-2 pl-2.5  pr-1.5 py-0.5 rounded dark:bg-gray-700 dark:text-gray-400 border border-gray-500">
                                                    {{ $caracteristica['descripcion'] }}
                                                    <button class="ml-1"
                                                        onclick="confirmDeleteCaracteristica({{ $opcion->id }},{{ $caracteristica['id'] }})">
                                                        <i class="fa-solid fa-xmark hover:text-red-500"></i>
                                                    </button>

                                                </span>
                                            @break

                                            @case(2)
                                                <div class="relative">
                                                    <span
                                                        class="inline-block h-6 w-6 shadow-lg rounded-full border-2 border-gray-300 mr-4"
                                                        style="background-color: {{ $caracteristica['valor'] }}">
                                                    </span>

                                                    <button
                                                        class="absolute z-10 left-3 -top-2 rounded-full bg-red-500 hover:bg-red-600 h-4 w-4 flex justify-center items-center"
                                                        onclick="confirmDeleteCaracteristica({{ $opcion->id }},{{ $caracteristica['id'] }})">
                                                        <i class="fa-solid fa-xmark text-white text-xs"></i>
                                                    </button>
                                                </div>
                                            @break

                                            @default
                                        @endswitch
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endforeach
                @else
                    <div class="flex items-center p-4 text-sm text-blue-800 rounded-lg bg-blue-50 dark:bg-gray-800 dark:text-blue-400"
                        role="alert">
                        <svg class="flex-shrink-0 inline w-4 h-4 me-3" aria-hidden="true"
                            xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                            <path
                                d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z" />
                        </svg>
                        <span class="sr-only">Info</span>
                        <div>
                            <span class="font-medium">Info alert!</span> No hay opciones para este producto
                        </div>
                    </div>
                @endif

            </div>
        </div>
    </section>


    @if ($producto->variantes->count())
        <section class="rounded-lg border border-gray-100 bg-white shadow-lg">
            <header class="border-b border-gray-200 px-6 py-2">
                <div class="flex justify-between">
                    <h1 class="text-lg font-semibold text-gray-700">
                        Variantes
                    </h1>

                </div>
            </header>
            <div class="p-6">
                <ul class="divide-y -my-4">
                    @foreach ($producto->variantes as $item)
                        <li class="py-4 flex items-center">
                            <img src="{{ $item->imagen }}" class="w-12 h-12 object-cover object-center">
                            <p class=" divide-x">
                                @foreach ($item->caracteristicas as $caracteristica)
                                    <span class="px-3">{{ $caracteristica->descripcion }}</span>
                                @endforeach
                            </p>
                            <a href="{{ route('admin.productos.variantes', [$producto, $item]) }}"
                                class="ml-auto btn btn-blue">Editar</a>

                        </li>
                    @endforeach
                </ul>
            </div>
        </section>

    @endif
    <x-dialog-modal wire:model="openModal">
        <x-slot name="title">
            Agregar nueva Accion
        </x-slot>
        <x-slot name="content">

            <x-validation-errors class="mb-4" />
            <div class="mb-4">
                <x-label class="mb-1">
                    Opción
                </x-label>
                <x-select class="w-full" wire:model.live="variante.opcion_id">
                    <option value="" disabled>Seleccione una Opción</option>
                    @foreach ($opciones as $opcion)
                        <option value="{{ $opcion->id }}">
                            {{ $opcion->nombre }}
                        </option>
                    @endforeach
                </x-select>
            </div>
            <div class="flex items-center mb-6">
                <hr class="flex-1">

                <span class="mx-4">Valores</span>

                <hr class="flex-1">
            </div>
            <ul class="mb-4 space-y-4">
                @foreach ($variante['caracteristicas'] as $index => $caracteristica)
                    <li wire:key="variante-caracteristica-".{{ $index }}
                        class="relative border border-gray-200 rounded-lg p-6">

                        <div class="absolute -top-3 bg-white px-4">
                            <button wire:click="removeCaracteristica({{ $index }})">
                                <i class="fa-solid fa-trash-can text-red-500 hover:text-red-600"></i>
                            </button>
                        </div>

                        <div>
                            <x-label class="mb-1">Valores</x-label>
                            <x-select class="w-full" wire:model="variante.caracteristicas.{{ $index }}.id"
                                wire:change="caracteristica_change({{ $index }})">
                                <option value="">
                                    Selecciona Valor
                                </option>
                                @foreach ($this->caracteristicas as $caracteristica)
                                    <option value="{{ $caracteristica->id }}">{{ $caracteristica->descripcion }}
                                    </option>
                                @endforeach
                            </x-select>
                        </div>

                    </li>
                @endforeach
            </ul>
            <div class="flex justify-end">
                <x-button wire:click="addCaracteristica">
                    Agregar Valor
                </x-button>
            </div>
        </x-slot>
        <x-slot name="footer">
            <x-danger-button wire:click="$set('openModal',false)">
                Cancelar
            </x-danger-button>
            <x-button class="ml-2" wire:click="save">
                Guardar
            </x-button>
        </x-slot>
    </x-dialog-modal>



    @push('js')
        <script>
            function confirmDeleteCaracteristica(opcion_id, caracteristica_id) {
                Swal.fire({
                    title: "¿Estas Seguro?",
                    text: "No se podra revertir",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Si, eliminar",
                    cancelButtonText: "Cancelar"
                }).then((result) => {
                    if (result.isConfirmed) {

                        @this.call('deleteCaracteristica', opcion_id, caracteristica_id);
                    }
                });
            }

            function confirmDeleteOpcion(opcion_id) {

                Swal.fire({
                    title: "¿Estas Seguro?",
                    text: "No se podra revertir",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Si, eliminar",
                    cancelButtonText: "Cancelar"
                }).then((result) => {
                    if (result.isConfirmed) {

                        @this.call('deleteOpcion', opcion_id);
                    }
                });
            }
        </script>
    @endpush
</div>
