<div class="card">
    <form wire:submit="save" method="POST">
        <figure class="mb-4 relative">
            <div class="absolute top-8 right-8">
                <label class="flex items-center px-4 py-2 rounded-lg bg-white cursor-pointer text-gray-700">
                    <i class="fas fa-camera mr-2"></i>
                    Actualizar Imagen
                    <input type="file" class="hidden" accept="image/*" wire:model.live="imagen">
                </label>
            </div>
            <img class="aspect-[16/9] object-cover object-center w-full"
                src="{{ $imagen ? $imagen->temporaryUrl() : asset('img/upload.png') }}" alt="">
        </figure>
        <div class="card">
            <div class="mb-4">
                <x-label class="mb-2">Codigo</x-label>
                <x-input class="w-full" placeholder="Ingrese el código del producto" wire:model="producto.codigo" />
            </div>

            <div class="mb-4">
                <x-label class="mb-2">Nombre</x-label>
                <x-input class="w-full" placeholder="Ingrese el nombre del producto" wire:model="producto.nombre" />
            </div>

            <div class="mb-4">
                <x-label class="mb-l">Descripción</x-label>
                <x-textarea wire:model="producto.descripcion" class="w-full"
                    placeholder="Ingrese la descripcion del producto"></x-textarea>

            </div>
            <x-validation-errors class="mb-4" />
            <div class="mb-4">
                <x-label class="mb-2">Familia</x-label>
                <x-select class="w-full" wire:model.live="producto.familia_id">
                    <option value="" disabled selected>
                        Selecione una familia
                    </option>
                    @foreach ($familias as $familia)
                        <option value="{{ $familia->id }}">{{ $familia->nombre }}</option>
                    @endforeach
                </x-select>

            </div>

            <div class="mb-4">
                <x-label class="mb-2">Categoria</x-label>
                <x-select class="w-full" wire:model.live="producto.categoria_id">
                    <option value="" disabled selected>
                        Selecione una categoria
                    </option>
                    @foreach ($this->categorias as $categoria)
                        <option value="{{ $categoria->id }}">{{ $categoria->nombre }}</option>
                    @endforeach
                </x-select>

            </div>

            <div class="mb-4">
                <x-label class="mb-2">Subcategoria</x-label>
                <x-select class="w-full" wire:model.live="producto.subcategoria_id">
                    <option value="" disabled selected>
                        Selecione una subcategoria
                    </option>
                    @foreach ($this->subcategorias as $subcategoria)
                        <option value="{{ $subcategoria->id }}">{{ $subcategoria->nombre }}</option>
                    @endforeach
                </x-select>

            </div>

            <div class="mb-4">
                <x-label class="mb-2">Precio</x-label>
                <x-input class="w-full" placeholder="Ingrese el precio del producto" 
                    wire:model="producto.precio" type="number" step='0.01'/>
            </div>
            {{--<div class="mb-4">
                <x-label class="mb-2">Stock</x-label>
                <x-input class="w-full" placeholder="Ingrese la cantidad existente del producto"
                    wire:model="producto.stock" type="number" step='1'/>
            </div>--}}


        </div>
        <div class="flex justify-end mt-4">
            <x-button>Guardar</x-button>
        </div>
    </form>
</div>
