<div class="card">
    <form wire:submit="save" method="POST">
        <figure class="mb-4 relative">
            <div class="absolute top-8 right-8">
                <label class="flex items-center px-4 py-2 rounded-lg bg-white cursor-pointer text-gray-700">
                    <i class="fas fa-camera mr-2"></i>
                    Actualizar Imagen
                    <input type="file" class="hidden" accept="image/*" wire:model.live="imagen">
                </label>
            </div>
            <img class="aspect-[16/9] object-cover object-center w-full"
                src="{{ $imagen ? $imagen->temporaryUrl() : Storage::url($productoEdit['dir_imagen']) }}"
                alt="">
        </figure>
        <div class="card">
            <div class="mb-4">
                <x-label class="mb-2">Codigo</x-label>
                <x-input class="w-full" placeholder="Ingrese el código del producto" wire:model="productoEdit.codigo" />
            </div>

            <div class="mb-4">
                <x-label class="mb-2">Nombre</x-label>
                <x-input class="w-full" placeholder="Ingrese el nombre del producto" wire:model="productoEdit.nombre" />
            </div>

            <div class="mb-4">
                <x-label class="mb-l">Descripción</x-label>
                <x-textarea wire:model="productoEdit.descripcion" class="w-full"
                    placeholder="Ingrese la descripcion del producto"></x-textarea>

            </div>
            <x-validation-errors class="mb-4" />
            <div class="mb-4">
                <x-label class="mb-2">Familia</x-label>
                <x-select class="w-full" wire:model.live="productoEdit.familia_id">
                    <option value="" disabled selected>
                        Selecione una familia
                    </option>
                    @foreach ($familias as $familia)
                        <option value="{{ $familia->id }}">{{ $familia->nombre }}</option>
                    @endforeach
                </x-select>

            </div>

            <div class="mb-4">
                <x-label class="mb-2">Categoria</x-label>
                <x-select class="w-full" wire:model.live="productoEdit.categoria_id">
                    <option value="" disabled selected>
                        Selecione una categoria
                    </option>
                    @foreach ($this->categorias as $categoria)
                        <option value="{{ $categoria->id }}">{{ $categoria->nombre }}</option>
                    @endforeach
                </x-select>

            </div>

            <div class="mb-4">
                <x-label class="mb-2">Subcategoria</x-label>
                <x-select class="w-full" wire:model.live="productoEdit.subcategoria_id">
                    <option value="" disabled selected>
                        Selecione una subcategoria
                    </option>
                    @foreach ($this->subcategorias as $subcategoria)
                        <option value="{{ $subcategoria->id }}">{{ $subcategoria->nombre }}</option>
                    @endforeach
                </x-select>

            </div>

            <div class="mb-4">
                <x-label class="mb-2">Precio</x-label>
                <x-input class="w-full" placeholder="Ingrese el precio del producto" wire:model="productoEdit.precio"
                    type="number" step='0.01' />
            </div>
            @empty($producto->variantes->count()>0)
                <div class="mb-4">
                    <x-label class="mb-2">Stock</x-label>
                    <x-input class="w-full" placeholder="Ingrese la cantidad existente del producto"
                        wire:model="productoEdit.stock" type="number" step='1' />
                </div>
            @endempty



        </div>
        <div class="flex justify-end space-x-2">
            <x-button>
                Actualizar
            </x-button>
            <x-danger-button onclick="confirmDelete()">
                Eliminar
            </x-danger-button>
        </div>
    </form>

    <form action="{{ route('admin.productos.destroy', $producto) }}" method="POST" id="delete-form">
        @csrf
        @method('DELETE')
    </form>

    @push('js')
        <script>
            function confirmDelete() {
                Swal.fire({
                    title: "¿Estas Seguro?",
                    text: "No se podra revertir",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Si, eliminar",
                    cancelButtonText: "Cancelar"
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById('delete-form').submit();

                    }
                });
            }
        </script>
    @endpush
</div>
