<div class="card">
    <form wire:submit="save" method="POST">

        <div class="card">
            <x-validation-errors class="mb-4" />
            <div class="mb-4">
                <x-label class="mb-2">Familia</x-label>
                <x-select class="w-full" wire:model.live="subcategoriaEdit.familia_id">
                    <option value="" disabled selected>
                        Selecione una familia
                    </option>
                    @foreach ($familias as $familia)
                        <option value="{{ $familia->id }}">{{ $familia->nombre }}</option>
                    @endforeach
                </x-select>

            </div>    
            
            <div class="mb-4">
                <x-label class="mb-2">Categoria</x-label>
                <x-select class="w-full" wire:model.live="subcategoriaEdit.categoria_id">
                    <option value="" disabled selected>
                        Selecione una categoria
                    </option>
                    @foreach ($this->categorias as $categoria)
                        <option value="{{ $categoria->id }}">{{ $categoria->nombre }}</option>
                    @endforeach
                </x-select>

            </div>

            
            <div class="mb-4">
                <x-label class="mb-2">Nombre</x-label>
                <x-input class="w-full" placeholder="" wire:model="subcategoriaEdit.nombre" />
            </div>
            
            
        </div>
        <div class="flex justify-end mt-4">
            <x-button>Actualizar</x-button>
            <x-danger-button onclick="confirmDelete()">
                Eliminar
            </x-danger-button>
        </div>
        
    </form>
    <form action="{{ route('admin.subcategorias.destroy', $subcategoria) }}" method="POST" id="delete-form">
        @csrf
        @method('DELETE')
    </form>
    @push('js')
        <script>
            
            function confirmDelete() {
                Swal.fire({
                    title: "¿Estas Seguro?",
                    text: "No se podra revertir",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Si, eliminar",
                    cancelButtonText: "Cancelar"
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById('delete-form').submit();
                        
                    }
                });
            }
        </script>
    @endpush
    
</div>

