<div class="">

    @if ($users->count())
        <div class="relative overflow-x-auto w-full">
            <table class="w-full text-sm text-left rtl:text-right text-gray-500 dark:text-gray-400">
                <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                    <tr>
                        <th scope="col" class="px-6 py-3">
                            Id
                        </th>
                        <th scope="col" class="px-6 py-3">
                            Nombre
                        </th>
                        <th scope="col" class="px-6 py-3">
                            Correo
                        </th>
                        <th scope="col" class="px-6 py-3">
                            Rol
                        </th>
                        <th scope="col" class="px-6 py-3">
                            Acción
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($users as $user)
                        <tr class="bg-white border-b dark:bg-gray-800 dark:border-gray-700" wire:key="{{$user->id}}">
                            <th scope="row"
                                class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap dark:text-white">
                                {{ $user->id }}
                            </th>
                            <td class="px-6 py-4">
                                {{ $user->name }}
                            </td>
                            <td class="px-6 py-4">
                                {{ $user->email }}
                            </td>
                            <td class="px-6 py-4">
                                <ul>
                                    @if ($user->roles->count())
                                        @foreach ($user->roles as $rol)
                                            <li>{{ $rol->name }}</li>
                                        @endforeach
                                    @else
                                        <li>No tiene Rol</li>
                                    @endif

                                </ul>
                            </td>
                            <td class="px-6 py-4">
                                <label>
                                    <x-input type="radio" name="{{$user->id}}" value="1" :checked="count($user->roles) > 0" wire:change="assignRole({{$user->id}}, $event.target.value)"/>
                                    Si
                                </label>
                                <label>
                                    <x-input type="radio" name="{{$user->id}}" value="0" :checked="$user->roles->count() == 0" wire:change="assignRole({{$user->id}}, $event.target.value)"/>
                                    No
                                </label>
                            </td>
                        </tr>
                    @endforeach

                </tbody>
            </table>
        </div>

        <div class="mt-4">
            {{ $users->links() }}
        </div>
    @else
        <div class="p-4 mb-4 text-sm text-blue-800 rounded-lg bg-blue-50 dark:bg-gray-800 dark:text-blue-400"
            role="alert">
            <span class="font-medium">Info alert!</span> Todavia no hay Usuarios registrados
        </div>
    @endif
</div>
