<div x-data="{
    open: false,
}">
    <header class="bg-rose-500">

        <x-container class="px-4 py-4">
            <div class="flex justify-between items-center space-x-8">
                <button class="text-2xl md:text-3xl" x-on:click="open=true">
                    <i class="fas fa-bars text-white"></i>
                </button>
                <h1 class="text-white ">
                    <a href="/" class="flex ">
                        <div>
                            <img src="{{asset('img/logo.jpeg')}}" class="w-16 me-3" alt="FlowBite Logo" />
                        </div>
                        <div class="inline-flex flex-col items-end">
                            <span class="text-2xl md:text-3xl leading-6 font-serif">
                                MABELLE
                            </span>
                            <span class="text-xs">
                                ELIGE TU PROPIO ESTILO
                            </span>
                        </div>
                    </a>
                </h1>
                <div class="flex-1 hidden md:block">
                    <x-input oninput="search(this.value)" class="w-full"
                        placeholder="Buscar por porducto, tienda o marca" />
                </div>
                <div class="flex items-center space-x-4 md:space-x-8">
                    <x-dropdown>
                        <x-slot name="trigger">
                            @auth
                                <img class="h-8 w-8 rounded-full object-cover" src="{{ Auth::user()->profile_photo_url }}"
                                    alt="{{ Auth::user()->name }}" />
                            @else
                                <button class="text-3xl"><i class="fas fa-user text-white"></i> </button>
                            @endauth


                        </x-slot>
                        <x-slot name="content">
                            @guest
                                <div class="px-4 py-2">
                                    <div class="flex justify-center">
                                        <a href="{{ route('login') }}" class="btn btn-rose">
                                            Iniciar Sesion
                                        </a>
                                    </div>
                                    <p class="text-sm text-center mt-2">¿No tienes cuenta?
                                        <a href="{{ route('register') }}"
                                            class="text-rose-500 hover:underline">Registrate</a>
                                    </p>
                                </div>
                            @else
                                <x-dropdown-link href="{{ route('profile.show') }}">
                                    Mi perfil
                                </x-dropdown-link>
                                @if (Auth::user()->roles->count())
                                    <x-dropdown-link href="{{ route('admin.dashboard') }}">
                                        Administrador
                                    </x-dropdown-link>
                                @endif
                                <div class="border-t border-gray-200"></div>
                                <!-- Authentication -->
                                <form method="POST" action="{{ route('logout') }}" x-data>
                                    @csrf

                                    <x-dropdown-link href="{{ route('logout') }}" @click.prevent="$root.submit();">
                                        {{ __('Log Out') }}
                                    </x-dropdown-link>
                                </form>
                            @endguest

                        </x-slot>
                    </x-dropdown>
                    {{-- <button class="text-2xl md:text-3xl"><i class="fas fa-shopping-cart text-white"></i> </button> --}}
                </div>

            </div>

            <div class="mt-4">
                <x-input oninput="search(this.value)" class="w-full md:hidden"
                    placeholder="Buscar por porducto, tienda o marca" />
            </div>
        </x-container>


    </header>


    <div x-show="open" x-on:click="open = false" style="display:none"
        class="fixed top-0 left-0 inset-0 bg-black bg-opacity-25 z-10"></div>

    <div x-show="open" style="display:none" class="fixed top-0 left-0  z-20">
        <div class="flex">
            <div class="w-screen md:w-80 h-screen bg-white">
                <div class="px-4 py-3 bg-rose-600 text-white font-semibold">
                    <div class="flex justify-between items-center">
                        <span class="text-lg">MENU</span>
                        <button x-on:click="open = false">
                            <i class="fas fa-times"></i>
                        </button>

                    </div>
                </div>
                <div class="h-[calc(100vh-52px)] overflow-auto">
                    <ul>
                        @foreach ($familias as $familia)
                            <li wire:mouseover="set('familia_id', {{ $familia->id }})">
                                <a href="{{ route('familias.show', $familia) }}"
                                    class="flex items-center justify-between px-4 py-4 text-gray-700 hover:bg-rose-300">{{ $familia->nombre }}
                                    <i class="fa-solid fa-angle-right"></i>
                                </a>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
            <div class="w-80 xl:w-[57rem] pt-[52px] hidden  md:block">
                <div class="h-[calc(100vh-52px)] overflow-auto bg-white px-6 py-8">
                    <div class="mb-8 flex justify-between items-center">
                        <p class="border-b-[3px] border-rose-800 uppercase text-xl font-semibold pb-1">
                            {{ $this->familiaNombre }}</p>

                        <a href="{{ route('familias.show', $familia_id) }}" class="btn btn-rose">
                            Ver todo
                        </a>
                    </div>

                    <ul class="grid grid-cols-1 xl:grid-cols-3 gap-8">
                        @foreach ($this->categorias as $categoria)
                            <li>
                                <a href="{{ route('categorias.show', $categoria->id) }}"
                                    class="text-rose-700 font-semibold text-l">{{ $categoria->nombre }}</a>
                                <ul class="mt-4 space-y-2">
                                    @foreach ($categoria->subcategorias as $subcategoria)
                                        <li>
                                            <a href="{{ route('subcategorias.show', $subcategoria->id) }}"
                                                class="text-sm text-gray-700 hover:text-rose-600">
                                                {{ $subcategoria->nombre }}
                                            </a>
                                        </li>
                                    @endforeach

                                </ul>
                            </li>
                        @endforeach
                    </ul>
                </div>

            </div>
        </div>
    </div>

    @push('js')
        <script>
            function search(value) {
                Livewire.dispatch('search', {
                    search: value
                })
            }
        </script>
    @endpush
</div>
