<?php

use App\Http\Controllers\Admin\CategoriaController;
use App\Http\Controllers\Admin\FamiliaController;
use App\Http\Controllers\Admin\OpcionController;
use App\Http\Controllers\Admin\PortadaController;
use App\Http\Controllers\Admin\ProductoController;
use App\Http\Controllers\Admin\SubcategoriaController;
use App\Livewire\Admin\UserComponent;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('admin.dashboard');
})->middleware('can:accesos dashboard')->name('dashboard');

Route::resource('familias', FamiliaController::class)->middleware('can:admin familias');

Route::resource('categorias', CategoriaController::class)->middleware('can:admin categorias');

Route::resource('subcategorias', SubcategoriaController::class)->middleware('can:admin subcategorias');

Route::resource('productos', ProductoController::class)->middleware('can:admin productos');

Route::get('/opciones', [OpcionController::class, 'index'])->name('opciones.index')->middleware('can:admin opciones');


Route::get('productos/{producto}/variantes/{variante}', [ProductoController::class, 'variantes'])->middleware('can:admin productos')
    ->name('productos.variantes')
    ->scopeBindings();


Route::put('productos/{producto}/variantes/{variante}', [ProductoController::class, 'variantesUpdate'])->middleware('can:admin productos')
    ->name('productos.variantesUpdate')
    ->scopeBindings();


Route::resource('portadas', PortadaController::class)->middleware('can:admin portadas');

Route::get('users', UserComponent::class)->middleware('can:admin usuarios')->name('users.index');