<?php
    $links = [
        [
            'icon' => 'fa-solid fa-gauge',
            'name' => 'Dashboard',
            'route' => route('admin.dashboard'),
            'active' => request()->routeIs('admin.dashboard'),
        ],
        [
            'icon' => 'fa-solid fa-cog',
            'name' => 'Opciones',
            'route' => route('admin.opciones.index'),
            'active' => request()->routeIs('admin.opciones.*'),
        ],
        [
            'icon' => 'fa-solid fa-box-open',
            'name' => 'Familias',
            'route' => route('admin.familias.index'),
            'active' => request()->routeIs('admin.familias.*'),
        ],
        [
            'icon' => 'fa-solid fa-tags',
            'name' => 'Categorias',
            'route' => route('admin.categorias.index'),
            'active' => request()->routeIs('admin.categorias.*'),
        ],
        [
            'icon' => 'fa-solid fa-tag',
            'name' => 'Subcategorias',
            'route' => route('admin.subcategorias.index'),
            'active' => request()->routeIs('admin.subcategorias.*'),
        ],
        [
            'icon' => 'fa-solid fa-box',
            'name' => 'Productos',
            'route' => route('admin.productos.index'),
            'active' => request()->routeIs('admin.productos.*'),
        ],
        [
            'icon' => 'fa-solid fa-images',
            'name' => 'Portada',
            'route' => route('admin.portadas.index'),
            'active' => request()->routeIs('admin.portadas.*'),
        ],
        [
            'icon' => 'fa-solid fa-user',
            'name' => 'Usuarios',
            'route' => route('admin.users.index'),
            'active' => request()->routeIs('admin.users.*'),
        ],
    ];
?>


<aside id="logo-sidebar"
    class="fixed top-0 left-0 z-40 w-64 h-[100dvh] pt-20 transition-transform -translate-x-full bg-white border-r border-gray-200 sm:translate-x-0 dark:bg-gray-800 dark:border-gray-700"
    :class="{
        'translate-x-0 ease-out': sidebarOpen,
        '-translate-x-full ease-in': !sidebarOpen
    }"
    aria-label="Sidebar">
    <div class="h-full px-3 pb-4 overflow-y-auto bg-white dark:bg-gray-700">
        <ul class="space-y-2 font-medium">
            <?php $__currentLoopData = $links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li>
                    <a href="<?php echo e($link['route']); ?>"
                        class="flex items-center p-2 text-gray-900 rounded-lg dark:text-white hover:bg-gray-100 dark:hover:bg-gray-700 group <?php echo e($link['active'] ? 'bg-gray-100' : ''); ?>">
                        <span class="inline-flex w-6 h-6 justify-center items-center">
                            <i class="<?php echo e($link['icon']); ?> text-gray-500"></i>
                        </span>
                        <span class="ml-2"><?php echo e($link['name']); ?></span>
                    </a>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


        </ul>
    </div>
</aside>
<?php /**PATH D:\R\laragon\www\laravel\ecommerce\resources\views/layouts/partials/admin/sidebar.blade.php ENDPATH**/ ?>