<?php if (isset($component)) { $__componentOriginal91fdd17964e43374ae18c674f95cdaa3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3 = $attributes; } ?>
<?php $component = App\View\Components\AdminLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AdminLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['breadcrumbs' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute([
    [
        'name' => 'Dashboard',
        'route' => route('admin.dashboard'),
    ],
    [
        'name' => 'Portadas',
    ],
])]); ?>

     <?php $__env->slot('action', null, []); ?> 
        <a class="btn btn-blue" href="<?php echo e(route('admin.portadas.create')); ?>">
            Nuevo
        </a>

     <?php $__env->endSlot(); ?>

    <?php if($portadas->count()): ?>

        <ul class="space-y-4" id="portadas">
            <?php $__currentLoopData = $portadas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $portada): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="bg-white rounded-lg shadow-lg overflow-hidden lg:flex cursor-move" data-id="<?php echo e($portada->id); ?>">
                    <img src="<?php echo e($portada->imagen); ?>" alt=""
                        class="w-full lg:w-64 aspect-[3/1] object-cover object-center">
                    <div class="p-4 lg:flex-1 lg:flex lg:justify-between lg:items-center space-y-3 lg:space-y-0">
                        <div>
                            <h1 class="font-semibold"><?php echo e($portada->titulo); ?></h1>
                            <p>
                                <?php if($portada->estado): ?>
                                    <span
                                        class="bg-green-100 text-green-800 text-xs font-medium me-2 px-2.5 py-0.5 rounded dark:bg-green-900 dark:text-green-300">Activo</span>
                                <?php else: ?>
                                    <span
                                        class="bg-red-100 text-red-800 text-xs font-medium me-2 px-2.5 py-0.5 rounded dark:bg-red-900 dark:text-red-300">Inactivo</span>
                                <?php endif; ?>
                            </p>
                        </div>
                        <div>
                            <p class="text-sm font-bold">
                                Fecha de inicio
                            </p>
                            <p><?php echo e($portada->inicio->format('d/m/Y')); ?></p>
                        </div>
                        <div>
                            <p class="text-sm font-bold">
                                Fecha de finalización
                            </p>
                            <p><?php echo e($portada->fin ? $portada->fin->format('d/m/Y') : '-'); ?></p>
                        </div>
                        <div>
                            <a class="btn btn-blue" href="<?php echo e(route('admin.portadas.edit', $portada)); ?>">
                                Editar
                            </a>
                        </div>
                    </div>

                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    <?php else: ?>
        <div class="p-4 mb-4 text-sm text-blue-800 rounded-lg bg-blue-50 dark:bg-gray-800 dark:text-blue-400"
            role="alert">
            <span class="font-medium">Info alert!</span> Todavia no hay portadas registradas
        </div>
    <?php endif; ?>

    <?php $__env->startPush('js'); ?>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/Sortable/1.15.3/Sortable.min.js"></script>
        <script>
            new Sortable(portadas, {
                animation: 150,
                ghostClass: 'bg-blue-100'
                store: {
                    set: (sortable) => {
                        const sorts = sortable.toArray();
                        axios.post("<?php echo e(route('api.sort.portadas')); ?>", {
                            sorts: sorts
                        }).catch((error) => {
                            console.log(error)
                        })
                    }
                }
            });
        </script>
    <?php $__env->stopPush(); ?>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $attributes = $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $component = $__componentOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php /**PATH D:\R\laragon\www\laravel\ecommerce\resources\views/admin/portadas/index.blade.php ENDPATH**/ ?>