<?php



class Avanzado extends Controller{

    public function __construct()
    {
        session_start();
        $this->loadModel('EnlacesModel');
        $this->loadModel('SistemaModel');
        $this->loadModel('EmpresaModel');
        $this->loadModel('AmbienteModel');
        $this->loadModel('PuntoVentaModel');
        $this->loadModel('SucursalesModel');
        $this->loadModel('UsuariosModel');
        $this->loadModel('CufdModel');
        $this->loadModel('EventosModel');
        
        parent::__construct();
    }
    
    private function loadModel($model) {
        $modelPath = __DIR__ . '/../Models/' . $model . '.php';
        if (file_exists($modelPath)) {
            require_once $modelPath;
        } else {
            throw new Exception("Model file not found: " . $modelPath);
        }
    }
    public function index(){
        $this->views->getView($this,"index");
    }

    

    
    public function generarCufd(){
        require_once "SiatCodigos.php";
        $siat = new SiatCodigos();
        $sistemaModel= new SistemaModel();
        $empresaModel=new EmpresaModel();
        $usuarioModel=new UsuariosModel();
        $puntoVentaModel= new PuntoVentaModel();
        $ambienteModel= new AmbienteModel();
        $sucursalModel=new SucursalesModel();
        $cufdModel=new CufdModel();
        $usuario=$usuarioModel->editarUsuario($_SESSION['id_usuario']);
        $sistema=$sistemaModel->getSistema(1);
        $pv=$puntoVentaModel->editarPuntoVenta($usuario['id_puntoventa']);
        $empresa=$empresaModel->getEmpresa(1);
        $ambiente=$ambienteModel->getAmbiente($sistema['ambiente']);
        $suc=$sucursalModel->editarSucursal($pv['codigoSucursal']);
        $datosgenerales['sistema']=$sistema;
        $datosgenerales['empresa']=$empresa;
        $datosgenerales['puntoventa']=$pv;
        $datosgenerales['ambiente']=$ambiente;
        $datosgenerales['sucursal']=$suc;
        $rescufd = $siat->cufd($datosgenerales,$pv);
        if ($rescufd->RespuestaCufd->transaccion == true) {
            $cufd = $rescufd->RespuestaCufd->codigo;
            $codigoControl = $rescufd->RespuestaCufd->codigoControl;
            $fechaVigencia = $rescufd->RespuestaCufd->fechaVigencia;
            $fechaSolicitud = new DateTime($fechaVigencia);
            $fechaSolicitud->modify("-1 day");
            $fSol=$fechaSolicitud->format("Y-m-d\TH:i:s.vP");
            $msgCufd=$cufdModel->insertCufd($cufd,$codigoControl,$fSol,$fechaVigencia,$pv['id_puntoVenta']);
            $_SESSION['scufd'] = $cufd;
            $_SESSION['scodigoControl'] = $codigoControl;
            $_SESSION['svigenciaCufd'] = $fechaVigencia;
            

        } else {
            $rescufd = false;
        } 
    }
    
    public function nuevo_cufd(){
        $sistemaModel= new SistemaModel();
        $empresaModel=new EmpresaModel();
        $usuarioModel=new UsuariosModel();
        $puntoVentaModel= new PuntoVentaModel();
        $ambienteModel= new AmbienteModel();
        $sucursalModel=new SucursalesModel();
        $usuario=$usuarioModel->editarUsuario($_SESSION['id_usuario']);
        $sistema=$sistemaModel->getSistema(1);
        $pv=$puntoVentaModel->editarPuntoVenta($usuario['id_puntoventa']);
        $empresa=$empresaModel->getEmpresa(1);
        $ambiente=$ambienteModel->getAmbiente($sistema['ambiente']);
        $suc=$sucursalModel->editarSucursal($pv['codigoSucursal']);
        $datosgenerales['sistema']=$sistema;
        $datosgenerales['empresa']=$empresa;
        $datosgenerales['puntoventa']=$pv;
        $datosgenerales['ambiente']=$ambiente;
        $datosgenerales['sucursal']=$suc;
        
        date_default_timezone_set('America/La_Paz');

        // Formatea la fecha y hora con microsegundos
        $fechaHora = new DateTime('now');
        require "SiatSincronizacion.php";
        $siat = new SiatSincronizacion();
        $res = $siat->sincronizarFechaHora($datosgenerales);
        $datos=$res->RespuestaFechaHora;
        $datos= json_encode($datos);
        $data= json_decode($datos,TRUE);
        //print_r($data);
        $data['fechaServ']=$fechaHora->format("Y-m-d\TH:i:s.v");
        //$this->views->getView($this,"fecha_hora",$data);
        $this->views->getView($this,"nuevo_cufd",$data);
    }
    


    public function evento_significativo(){
        date_default_timezone_set('America/La_Paz');
        $usuarioModel=new UsuariosModel();
        $puntoVentaModel= new PuntoVentaModel();
        $cufdModel=new CufdModel();
        $usuario=$usuarioModel->editarUsuario($_SESSION['id_usuario']);
        $pv=$puntoVentaModel->editarPuntoVenta($usuario['id_puntoventa']);
        $data['cufd']=$cufdModel->getCufds($pv['id_puntoVenta']);
        $this->views->getView($this,"evento_significativo",$data);
    }
    public function registrarEvento(){
        $usuarioModel=new UsuariosModel();
        $eventosModel=new EventosModel();
        $usuario=$usuarioModel->editarUsuario($_SESSION['id_usuario']);
        $descripcion_evento=$_POST['descripcion_evento'];
        $fechaInicioEvento = $_POST['fechaInicioEvento'];
        if($descripcion_evento>4){
            $cafc = $_POST['cafc'];
        }else{
            $cafc="";
        }
        
        $cufd = $_POST['cufd'];
        if(empty($descripcion_evento) || empty($fechaInicioEvento) || empty($cufd)){
            $msg= "Todos los campos son obligatorios";
        }else{
            $data=$eventosModel->registrarEvento($cufd,$cafc,$descripcion_evento,$fechaInicioEvento,$usuario['id_puntoventa']);
            if($data=="ok"){
                $msg="si";
            }else{
                $msg="Error al registrar el evento";
            }         
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
        
        echo ($fechaInicioEvento);
    }
    public function listarEventos(){
        $usuarioModel=new UsuariosModel();
        $usuario=$usuarioModel->editarUsuario($_SESSION['id_usuario']);
        $eventosModel=new EventosModel();
        $data=$eventosModel->getEventos($usuario['id_puntoventa']);
        for($i=0;$i<count($data);$i++){
            $data[$i]['cufd']=substr($data[$i]['cufd'], 0, 20).'...';
            if($data[$i]['codigoRecepcion']==0){
                $data[$i]['acciones']='<div><button class="btn btn-primary" type="button"  onclick="btnFinalizarEvento('.$data[$i]['id_evento'].')">Fin de Evento</button>
            <button class="btn btn-danger" type="button" onclick="btnEliminarEvento('.$data[$i]['id_evento'].')"><i class="fas fa-trash"></i></button>
            </div>';
            }else{
                $data[$i]['acciones']='';
            }
            

        }
        echo json_encode($data);
        die();
    }
    public function eliminarEvento(int $id){
        $eventosModel=new EventosModel();
        $data = $eventosModel->eliminarEvento($id);
        if($data==1){
            $msg="ok";
        }else{
            $msg="Error al eliminar el evento";
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function finalizarEvento(int $id){
        $sistemaModel= new SistemaModel();
        $empresaModel=new EmpresaModel();
        $usuarioModel=new UsuariosModel();
        $puntoVentaModel= new PuntoVentaModel();
        $ambienteModel= new AmbienteModel();
        $sucursalModel=new SucursalesModel();
        $usuario=$usuarioModel->editarUsuario($_SESSION['id_usuario']);
        $sistema=$sistemaModel->getSistema(1);
        $pv=$puntoVentaModel->editarPuntoVenta($usuario['id_puntoventa']);
        $empresa=$empresaModel->getEmpresa(1);
        $ambiente=$ambienteModel->getAmbiente($sistema['ambiente']);
        $suc=$sucursalModel->editarSucursal($pv['codigoSucursal']);
        $datosgenerales['sistema']=$sistema;
        $datosgenerales['empresa']=$empresa;
        $datosgenerales['puntoventa']=$pv;
        $datosgenerales['ambiente']=$ambiente;
        $datosgenerales['sucursal']=$suc;
        $eventosModel=new EventosModel();
        $evento=$eventosModel->obtenerEvento($id);
        require "SiatSincronizacion.php";
        require "SiatOperaciones.php";
        $siat = new SiatSincronizacion();
        $fec = $siat->sincronizarFechaHora($datosgenerales);
        $fechaFinEvento=$fec->RespuestaFechaHora->fechaHora;
        //print_r($data);
        
        
        $siat1 = new SiatOperaciones();
        
        $resEvento= $siat1->registroEventoSignificativo($datosgenerales,$evento['descripcion_evento'],$evento['cufd'],$fechaFinEvento,$evento['fechaInicioEvento'],$evento['idPuntoVenta']);
        //$mensaje=$resEvento->RespuestaListaEventos->transaccion;
        //echo json_encode($resEvento);
        if(isset($resEvento->RespuestaListaEventos->codigoRecepcionEventoSignificativo)){
            $codigoRecepcion=$resEvento->RespuestaListaEventos->codigoRecepcionEventoSignificativo;
            $data = $this->model->finalizarEvento($id,$fechaFinEvento,$codigoRecepcion);
            if(is_dir('docs/'.$evento['cufd'].'/')){
                rename('docs/'.$evento['cufd'].'/','docs/'.$evento['cufd'].'_'.$codigoRecepcion.'/');
            }
            if($data==1){
                $msg="ok";
                $this->generarCufd();
            }else{
                $msg="Error al finalizar Evento: ".$fechaFinEvento;
            }
        }
        else{
            $resp=$resEvento->RespuestaListaEventos->mensajesList->descripcion;
            $msg="Error al finalizar Evento: ".$resp;
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function validar_facturas_sc(){
        date_default_timezone_set('America/La_Paz');
        $usuarioModel=new UsuariosModel();
        $usuario=$usuarioModel->editarUsuario($_SESSION['id_usuario']);
        
        $data['eventos']=$this->model->getEventosFinalizados($usuario['id_puntoventa']);
        $this->views->getView($this,"validar_facturas",$data);
    }
    public function pedidosSC($id_evento)
    {
        $evento=$this->model->obtenerEvento($id_evento);
        $data = $this->model->getPedidosSC($evento['cufd'],$evento['fechaInicioEvento'],$evento['fechaFinEvento'],2);
        for ($i = 0; $i < count($data); $i++) {
            if ($data[$i]['factura_estado'] == 1) {
                $data[$i]['factura_estado'] = '<span class="badge bg-success">Activo</span>';
            } else {
                $data[$i]['factura_estado'] = '<span class="badge bg-danger">Inactivo</span>';
            }
            $data[$i]['acciones'] = '<div>
                <button class="btn btn-primary" type="button" onclick="btnImprimirFactura(' . $data[$i]['id_factura'] . ')"><i class="fas fa-print"></i></button>
                <a href="https://pilotosiat.impuestos.gob.bo/consulta/QR?nit=2314273018&cuf=' . $data[$i]['cuf'] . '&numero=' . $data[$i]['numeroFactura'] . '&t=2" class="btn btn-success" target="_blank"><i class="fas fa-file-signature"></i></a>
                </div>';
        }
        echo json_encode($data);
        //die();
    }
    public function validarFacturas($id_evento){
        $sistemaModel= new SistemaModel();
        $empresaModel=new EmpresaModel();
        $usuarioModel=new UsuariosModel();
        $puntoVentaModel= new PuntoVentaModel();
        $ambienteModel= new AmbienteModel();
        $sucursalModel=new SucursalesModel();
        $usuario=$usuarioModel->editarUsuario($_SESSION['id_usuario']);
        $sistema=$sistemaModel->getSistema(1);
        $pv=$puntoVentaModel->editarPuntoVenta($usuario['id_puntoventa']);
        $empresa=$empresaModel->getEmpresa(1);
        $ambiente=$ambienteModel->getAmbiente($sistema['ambiente']);
        $suc=$sucursalModel->editarSucursal($pv['codigoSucursal']);
        $datosgenerales['sistema']=$sistema;
        $datosgenerales['empresa']=$empresa;
        $datosgenerales['puntoventa']=$pv;
        $datosgenerales['ambiente']=$ambiente;
        $datosgenerales['sucursal']=$suc;
        $evento=$this->model->obtenerEvento($id_evento);
        $data = $this->model->contarPedidosSC($evento['cufd'],$evento['fechaInicioEvento'],$evento['fechaFinEvento']);
        $dirCufd=str_replace('/', '', $evento['cufd']);
        $carpeta = 'docs/'.$dirCufd.'_'.$evento['codigoRecepcion'];
        if (file_exists('docs/'.$dirCufd.'_'.$evento['codigoRecepcion'].'/'.$dirCufd.'.tar')) {
            unlink('docs/'.$dirCufd.'_'.$evento['codigoRecepcion'].'/'.$dirCufd.'.tar');
        } 
        if (file_exists('docs/'.$dirCufd.'_'.$evento['codigoRecepcion'].'/'.$dirCufd.'.tar.gz')) {
            unlink('docs/'.$dirCufd.'_'.$evento['codigoRecepcion'].'/'.$dirCufd.'.tar.gz');
        } 
        $archivoTar = 'docs/'.$dirCufd.'_'.$evento['codigoRecepcion'].'/'.$dirCufd.'.tar';

        $phar = new PharData($archivoTar);

        $phar->buildFromDirectory($carpeta);
        
        $phar->compress(Phar::GZ);

        $archivoTarGz = 'docs/'.$dirCufd.'/'.$dirCufd.'.tar.gz';

        $archivo = file_get_contents('docs/'.$dirCufd.'_'.$evento['codigoRecepcion'].'/'.$dirCufd.'.tar.gz');
        $hash = hash('sha256', $archivoTarGz);
        
        $fecha = $_POST['time'];
        $cafc= $evento['cafc'];
        require "SiatFacturacion.php";
        $siat = new SiatFacturacion();
        $resFactura = $siat->recepcionPaqueteFactura($datosgenerales,$archivo,$fecha,$hash,$data['cantidad'],$evento['codigoRecepcion'],$cafc);
        if(isset($resFactura->RespuestaServicioFacturacion->transaccion)){
            if($resFactura->RespuestaServicioFacturacion->transaccion==false){
                $msg=($resFactura->RespuestaServicioFacturacion);
            }else{
                $codigoRecepcion=$resFactura->RespuestaServicioFacturacion->codigoRecepcion;
                $codigoEstado=$resFactura->RespuestaServicioFacturacion->codigoEstado;
                $codigoDescripcion=$resFactura->RespuestaServicioFacturacion->codigoDescripcion;    
                $result = $this->model->insertValidacion($codigoRecepcion, $codigoEstado, $codigoDescripcion, $id_evento);
                $facturas = $this->model->validarFacturas($evento['cufd'],$evento['fechaInicioEvento'],$evento['fechaFinEvento'],$codigoRecepcion);
                $msg="PENDIENTE";
            }        
            
        }else{
           $msg=($resFactura);

        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
        
        
    }
    public function facturas_pendientes(){
        $data['validaciones']=$this->model->getValidacionesP();
        $this->views->getView($this,"facturas_pendientes",$data);
    }
    public function pedidosSCP($codigoRecepcion)
    {
        $data = $this->model->getPedidosP($codigoRecepcion,3);
        for ($i = 0; $i < count($data); $i++) {
            if ($data[$i]['factura_estado'] == 1) {
                $data[$i]['factura_estado'] = '<span class="badge bg-success">Activo</span>';
            } else {
                $data[$i]['factura_estado'] = '<span class="badge bg-danger">Inactivo</span>';
            }
            $data[$i]['acciones'] = '<div>
                <button class="btn btn-primary" type="button" onclick="btnImprimirFactura(' . $data[$i]['id_factura'] . ')"><i class="fas fa-print"></i></button>
                <a href="https://pilotosiat.impuestos.gob.bo/consulta/QR?nit=2314273018&cuf=' . $data[$i]['cuf'] . '&numero=' . $data[$i]['numeroFactura'] . '&t=2" class="btn btn-success" target="_blank"><i class="fas fa-file-signature"></i></a>
                </div>';
        }
        echo json_encode($data);
        die();
    }



    public function comprobarEstado($codigoRecepcion){
        $sistemaModel= new SistemaModel();
        $empresaModel=new EmpresaModel();
        $usuarioModel=new UsuariosModel();
        $puntoVentaModel= new PuntoVentaModel();
        $ambienteModel= new AmbienteModel();
        $sucursalModel=new SucursalesModel();
        $usuario=$usuarioModel->editarUsuario($_SESSION['id_usuario']);
        $sistema=$sistemaModel->getSistema(1);
        $pv=$puntoVentaModel->editarPuntoVenta($usuario['id_puntoventa']);
        $empresa=$empresaModel->getEmpresa(1);
        $ambiente=$ambienteModel->getAmbiente($sistema['ambiente']);
        $suc=$sucursalModel->editarSucursal($pv['codigoSucursal']);
        $datosgenerales['sistema']=$sistema;
        $datosgenerales['empresa']=$empresa;
        $datosgenerales['puntoventa']=$pv;
        $datosgenerales['ambiente']=$ambiente;
        $datosgenerales['sucursal']=$suc;require "SiatFacturacion.php";
        $siat = new SiatFacturacion();
        $resFactura = $siat->validacionRecepcionPaqueteFactura($datosgenerales,$codigoRecepcion);
        if(isset($resFactura->RespuestaServicioFacturacion->transaccion)){
            if($resFactura->RespuestaServicioFacturacion->transaccion==false){
                echo json_encode($resFactura->RespuestaServicioFacturacion);
            }else{
                $codigoRecepcion=$resFactura->RespuestaServicioFacturacion->codigoRecepcion;
                $codigoEstado=$resFactura->RespuestaServicioFacturacion->codigoEstado;
                $codigoDescripcion=$resFactura->RespuestaServicioFacturacion->codigoDescripcion;    
                $result = $this->model->updateValidacion($codigoRecepcion, $codigoEstado, $codigoDescripcion);
                if($codigoEstado==904){
                    $estado=4;
                    print_r($resFactura);
                    exit();
                }else if($codigoEstado==908){
                    $estado=1;
                }else{
                    $estado=3;
                }
                $facturas = $this->model->updateFacturas($codigoRecepcion,$estado);
                echo json_encode($codigoDescripcion, JSON_UNESCAPED_UNICODE);
                die();
            }        
            
        }else{
            echo json_encode($resFactura);

        }
        
        
    }
    

}
?>

