<?php
class PuntoVenta extends Controller
{
    public function __construct()
    {   
        session_start();
        $this->loadModel('TipoPuntoVentaModel');
        $this->loadModel('SucursalesModel');
        $this->loadModel('EnlacesModel');
        $this->loadModel('SistemaModel');
        $this->loadModel('EmpresaModel');
        $this->loadModel('AmbienteModel');
        $this->loadModel('PuntoVentaModel');
        $this->loadModel('UsuariosModel');
        parent::__construct();
    }
    private function loadModel($model) {
        $modelPath = __DIR__ . '/../Models/' . $model . '.php';
        if (file_exists($modelPath)) {
            require_once $modelPath;
        } else {
            throw new Exception("Model file not found: " . $modelPath);
        }
    }
    public function index(){
        $sucursalesModel = new SucursalesModel();
        $stipopuntoventaModel = new TipoPuntoVentaModel();
        $data['sucursales']=$sucursalesModel->getSucursales();
        $data['tipopuntoventa']=$stipopuntoventaModel->getPuntoVentas();

        $this->views->getView($this,"index",$data);
    }

    public function listar(){
        $usuarioModel=new UsuariosModel();
        $puntoVentaModel= new PuntoVentaModel();
        $usuario=$usuarioModel->editarUsuario($_SESSION['id_usuario']);
        $pv=$puntoVentaModel->editarPuntoVenta($usuario['id_puntoventa']);
        $data=$this->model->getPuntoVenta();

        for($i=0;$i<count($data);$i++){
            if($data[$i]['codigopuntoventa']!=0 and $pv['codigoPuntoVenta']==0){
                $data[$i]['acciones']='<div>
                <button class="btn btn-danger" type="button" onclick="btnEliminarPV('.$data[$i]['id'].')"><i class="fas fa-trash"></i></button>
                </div>';  
            }else{
                $data[$i]['acciones']='<div>
                </div>';
            }
                   
        }
        echo(json_encode($data));
        die();
    }

    public function registrar(){
        
        $id_puntoventa=$_POST['id_puntoventa'];
        $id_sucursal = $_POST['id_sucursal'];
        $tipopuntoventa = $_POST['tipopuntoventa'];
        $descripcion = $_POST['descripcion'];
        
        if(empty($tipopuntoventa)  || empty($descripcion) ){
            $msg= "Los campos son obligatorios";
        }else{
            if($id_puntoventa==""){
                require "SiatOperaciones.php";
                $sistemaModel= new SistemaModel();
                $empresaModel=new EmpresaModel();
                $usuarioModel=new UsuariosModel();
                $puntoVentaModel= new PuntoVentaModel();
                $ambienteModel= new AmbienteModel();
                $siat=new SiatOperaciones();
                ////////////////////////////////////////////////
                $usuario=$usuarioModel->editarUsuario($_SESSION['id_usuario']);
                $sistema=$sistemaModel->getSistema(1);
                $pv=$puntoVentaModel->editarPuntoVenta($usuario['id_puntoventa']);
                $empresa=$empresaModel->getEmpresa(1);
                $ambiente=$ambienteModel->getAmbiente($sistema['ambiente']);
                $datosgenerales['sistema']=$sistema;
                $datosgenerales['empresa']=$empresa;
                $datosgenerales['puntoventa']=$pv;
                $datosgenerales['ambiente']=$ambiente;
                /////////////////////////////////////////////////////
                $puntoVenta['codigoSucursal']=$id_sucursal;
                $puntoVenta['tipopuntoventa']=$tipopuntoventa;
                $puntoVenta['descripcion']=$descripcion;
                
                $res = $siat->registroPuntoVenta($datosgenerales,$puntoVenta);
                if(isset($res->RespuestaRegistroPuntoVenta->codigoPuntoVenta)){
                    require "SiatCodigos.php";
                    $siat1=new SiatCodigos();
                    $puntoVenta['codigoPuntoVenta']=$res->RespuestaRegistroPuntoVenta->codigoPuntoVenta;
                    $res2 = $siat1->cuis($datosgenerales,$puntoVenta);
                    if(isset($res2->RespuestaCuis->transaccion)){
                        $puntoVenta['cuis']=$res2->RespuestaCuis->codigo;
                        $puntoVenta['vigencia']=$res2->RespuestaCuis->fechaVigencia;
                        $data=$this->model->registrarPuntoVenta($puntoVenta['codigoSucursal'],$puntoVenta['codigoPuntoVenta'],$puntoVenta['cuis'],$puntoVenta['vigencia'],$puntoVenta['tipopuntoventa'],$puntoVenta['descripcion']);
                        if($data=="ok"){
                            $msg="si";
                        }else{
                            $msg="Error al registrar el punto de venta". json_encode($res2);
                        }
                    }else{
                        print_r(json_encode($res2));
                        exit;
                    }
                    
                }else{
                    $msg="Error al registrar el punto de venta: ". json_encode($res);
                }

                
                
            }
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
        
    }

    public function eliminar(int $id){
        require "SiatOperaciones.php";
        $sistemaModel= new SistemaModel();
        $empresaModel=new EmpresaModel();
        $usuarioModel=new UsuariosModel();
        $puntoVentaModel= new PuntoVentaModel();
        $ambienteModel= new AmbienteModel();
        $siat=new SiatOperaciones();
        ////////////////////////////////////////////////
        $usuario=$usuarioModel->editarUsuario($_SESSION['id_usuario']);
        $sistema=$sistemaModel->getSistema(1);
        $pv=$puntoVentaModel->editarPuntoVenta($usuario['id_puntoventa']);
        $empresa=$empresaModel->getEmpresa(1);
        $ambiente=$ambienteModel->getAmbiente($sistema['ambiente']);
        $datosgenerales['sistema']=$sistema;
        $datosgenerales['empresa']=$empresa;
        $datosgenerales['puntoventa']=$pv;
        $datosgenerales['ambiente']=$ambiente;
        $puntoVenta=$puntoVentaModel->editarPuntoVenta($id);
        $res=$siat->cierrePuntoVenta($datosgenerales,$puntoVenta);
        if($res->RespuestaCierrePuntoVenta->transaccion){
            $data = $this->model->eliminar($id);
            if($data=="ok"){
                $msg="ok";
            }else{
                $msg="Error al eliminar el punto de venta";
            }
        }else{
            $msg="Error al eliminar el punto de venta: ".$res->mensajesList->descripcion;
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    
    

}
?>
