<?php

use Shuchkin\SimpleXLSXGen;

class Reportes extends Controller
{
    public function __construct()
    {
        session_start();
        $this->loadModel('PagoModel');
        $this->loadModel('EmpresaModel');
        $this->loadModel('SucursalesModel');
        $this->loadModel('ClientesModel');
        $this->loadModel('PedidosModel');
        parent::__construct();
    }
    private function loadModel($model)
    {
        $modelPath = __DIR__ . '/../Models/' . $model . '.php';
        if (file_exists($modelPath)) {
            require_once $modelPath;
        } else {
            throw new Exception("Model file not found: " . $modelPath);
        }
    }

    public function imprimirReporte()
    {
        $empresaModel = new EmpresaModel();
        $tipoPagoModel = new PagoModel();
        $pedidosModel = new PedidosModel();
        $empresa = $empresaModel->getEmpresa(1);
        $datos = [
            ['Fecha' => '2024-12-15', 'Monto' => '100.00', 'Método' => 'Tarjeta'],
            ['Fecha' => '2024-12-14', 'Monto' => '200.00', 'Método' => 'Efectivo'],
            ['Fecha' => '2024-12-13', 'Monto' => '150.00', 'Método' => 'Transferencia'],
        ];
        $tipo_pago = $_POST['tipo_pago'];
        $desde = $_POST['desde'];
        $hasta = $_POST['hasta'];
        if ($desde == '') {
            $desde = '2024-01-01';
        }
        if ($hasta == '') {
            $hasta =  date("Y-m-d");
        }

        $desdeFormateada = (new DateTime($desde))->format('d-m-Y');
        $hastaFormateada = (new DateTime($hasta))->format('d-m-Y');

        if ($tipo_pago == 0) {
            $nombreTipoPago = "Todos";
            $data1 = $tipoPagoModel->getPagos();
        } else {
            $pago = $tipoPagoModel->getPago($tipo_pago);
            $data2 = $pedidosModel->reporteFacturas($tipo_pago, $desde, $hasta);
            $nombreTipoPago = $pago['descripcion'];
        }
        require_once 'Assets/tcpdf/tcpdf.php';

        // Obtener datos del formulario


        // Crear una instancia de TCPDF
        $pdf = new TCPDF();

        // Configurar propiedades generales del PDF
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('ProyectosR23W7');
        $pdf->SetTitle('Reporte de Facturas');
        $pdf->SetSubject('Reporte');

        // Configurar encabezado
        $nombreEmpresa = $empresa['nombreempresa'];
        $nombreReporte = "Reporte de Facturas";
        $pdf->SetHeaderData(
            '', // Ruta a una imagen para el logo (dejar vacío si no tienes logo)
            0,  // Ancho del logo
            $nombreEmpresa, // Título de la cabecera (nombre de la empresa)
            $nombreReporte // Subtítulo de la cabecera (nombre del reporte)
        );

        // Configurar estilos del encabezado y pie de página

        // Configurar márgenes
        $pdf->SetMargins(15, 27, 15); // Márgenes (izquierdo, superior, derecho)
        $pdf->SetHeaderMargin(10); // Margen del encabezado
        $pdf->SetFooterMargin(10); // Margen del pie de página

        // Configurar salto de página automático
        $pdf->SetAutoPageBreak(TRUE, 25);

        // Agregar una página
        $pdf->AddPage();

        // Agregar contenido principal
        $pdf->SetFont('helvetica', '', 12);
        $pdf->Write(0, "Tipo de Pago Seleccionado: $nombreTipoPago\n\n");
        $pdf->Write(0, "Desde: $desdeFormateada  -  Hasta: $hastaFormateada \n\n");




        if (isset($data1)) {
            $tot = 0;
            foreach ($data1 as $dt) {
                
                $data2 = $pedidosModel->reporteFacturas($dt['codigo'], $desde, $hasta);
                if (is_array($data2) && !empty($data2)) {
                    // Agregar la tabla
                    $tipoP = $dt['descripcion'];

                    $stot = 0;

                    $pdf->SetFont('helvetica', 'B', 10);
                    $pdf->Write(0, "Metodo de Pago: $tipoP  \n\n");
                    $pdf->SetFillColor(220, 220, 220); // Fondo gris claro para la cabecera
                    $pdf->Cell(15, 10, 'N°', 1, 0, 'C', 1);
                    $pdf->Cell(40, 10, 'Fecha', 1, 0, 'C', 1);
                    $pdf->Cell(30, 10, 'NIT/CI', 1, 0, 'C', 1);
                    $pdf->Cell(65, 10, 'Tipo de Pago', 1, 0, 'C', 1);
                    $pdf->Cell(30, 10, 'Monto', 1, 1, 'C', 1);
                    // Agregar las filas de la tabla
                    $pdf->SetFont('helvetica', '', 10);
                    foreach ($data2 as $data) {
                        $pdf->Cell(15, 10, $data['numeroFactura'], 1, 0, 'C');
                        $pdf->Cell(40, 10, date('d-m-Y H:i', strtotime($data['fechaEmision'])), 1, 0, 'C');
                        $pdf->Cell(30, 10, $data['documentoid'], 1, 0, 'C');
                        $pdf->Cell(65, 10, $data['descripcion'], 1, 0, 'C');
                        $pdf->Cell(30, 10, $data['montoTotal'], 1, 1, 'C');
                        $stot = $stot + $data['montoTotal'];
                    }
                    $pdf->SetFont('helvetica', 'B', 10);
                    $pdf->Cell(15, 10, '', 0, 0, 'C');
                    $pdf->Cell(40, 10, '', 0, 0, 'C');
                    $pdf->Cell(30, 10, '', 0, 0, 'C');
                    $pdf->Cell(65, 10, 'SubTotal', 1, 0, 'C', 1);
                    $pdf->Cell(30, 10, number_format($stot, 2), 1, 1, 'C');
                    $tot = $tot + $stot;
                }
                $pdf->SetFont('helvetica', 'B', 12);
                
            }
            $pdf->Write(0, "Total General: " . number_format($tot, 2) . "\n\n");
        } else {
            $tot = 0;
            // Agregar la tabla
            $pdf->SetFont('helvetica', 'B', 10);
            $pdf->SetFillColor(220, 220, 220); // Fondo gris claro para la cabecera
            $pdf->Cell(15, 10, 'N°', 1, 0, 'C', 1);
            $pdf->Cell(40, 10, 'Fecha', 1, 0, 'C', 1);
            $pdf->Cell(30, 10, 'NIT/CI', 1, 0, 'C', 1);
            $pdf->Cell(65, 10, 'Tipo de Pago', 1, 0, 'C', 1);
            $pdf->Cell(30, 10, 'Monto', 1, 1, 'C', 1);
            // Agregar las filas de la tabla
            $pdf->SetFont('helvetica', '', 10);
            foreach ($data2 as $data) {
                $pdf->Cell(15, 10, $data['numeroFactura'], 1, 0, 'C');
                $pdf->Cell(40, 10, date('d-m-Y H:i', strtotime($data['fechaEmision'])), 1, 0, 'C');
                $pdf->Cell(30, 10, $data['documentoid'], 1, 0, 'C');
                $pdf->Cell(65, 10, $data['descripcion'], 1, 0, 'C');
                $pdf->Cell(30, 10, $data['montoTotal'], 1, 1, 'C');
                $tot = $tot + $data['montoTotal'];
            }
            $pdf->SetFont('helvetica', 'B', 10);
            $pdf->Cell(15, 10, '', 0, 0, 'C');
            $pdf->Cell(40, 10, '', 0, 0, 'C');
            $pdf->Cell(30, 10, '', 0, 0, 'C');
            $pdf->Cell(65, 10, 'Total', 1, 0, 'C', 1);
            $pdf->Cell(30, 10, number_format($tot, 2), 1, 1, 'C');
        }

        // Salida del PDF
        $pdf->Output('reporte.pdf', 'I');

        // Salida del PDF
        $pdf->Output('reporte.pdf', 'I'); // 'I' indica que el PDF se abre en el navegador
    }
    
    public function descargarExcel()
    {
        require_once 'Assets/SimpleXLSXGen.php';

        // Datos para el reporte
        // Modelos y datos
        $empresaModel = new EmpresaModel();
        $tipoPagoModel = new PagoModel();
        $pedidosModel = new PedidosModel();

        $empresa = $empresaModel->getEmpresa(1);

        $tipo_pago = $_POST['tipo_pago'];
        $desde = $_POST['desde'] ?: '2024-01-01'; // Si está vacío, asigna la fecha por defecto
        $hasta = $_POST['hasta'] ?: date("Y-m-d");

        $desdeFormateada = (new DateTime($desde))->format('d-m-Y');
        $hastaFormateada = (new DateTime($hasta))->format('d-m-Y');

        if ($tipo_pago == 0) {
            $nombreTipoPago = "Todos";
            $data1 = $tipoPagoModel->getPagos();
        } else {
            $pago = $tipoPagoModel->getPago($tipo_pago);
            $data2 = $pedidosModel->reporteFacturas($tipo_pago, $desde, $hasta);
            $nombreTipoPago = $pago['descripcion'];
        }

        // Datos para el Excel
        $excelData = [];

        // Título del reporte
        $excelData[] = ['Reporte de Facturas'];
        $excelData[] = ["Tipo de Pago: $nombreTipoPago"];
        $excelData[] = ["Desde: $desdeFormateada - Hasta: $hastaFormateada"];
        $excelData[] = []; // Línea en blanco

        // Encabezados de la tabla
        $excelData[] = ['N°', 'Fecha', 'NIT/CI', 'Tipo de Pago', 'Monto'];

        $tot = 0;

        if (isset($data1) && is_array($data1)) {
            foreach ($data1 as $dt) {
                $data2 = $pedidosModel->reporteFacturas($dt['codigo'], $desde, $hasta);
                if (is_array($data2) && !empty($data2)) {
                    foreach ($data2 as $data) {
                        $excelData[] = [
                            $data['numeroFactura'],
                            date('d-m-Y H:i', strtotime($data['fechaEmision'])),
                            $data['documentoid'],
                            $data['descripcion'],
                            $data['montoTotal']
                        ];
                        $tot += $data['montoTotal'];
                    }
                }
            }
        } elseif (isset($data2) && is_array($data2)) {
            foreach ($data2 as $data) {
                $excelData[] = [
                    $data['numeroFactura'],
                    date('d-m-Y H:i', strtotime($data['fechaEmision'])),
                    $data['documentoid'],
                    $data['descripcion'],
                    $data['montoTotal']
                ];
                $tot += $data['montoTotal'];
            }
        }

        // Agregar el total general
        $excelData[] = [];
        $excelData[] = ['', '', '', 'Total', number_format($tot, 2)];

        // Generar y descargar el archivo Excel
        $xlsx = SimpleXLSXGen::fromArray($excelData);
        $xlsx->downloadAs('reporte_facturas.xlsx');
        exit;
    }
}
