<?php
class EventosModel extends Query{
    public function __construct()
    {
        parent::__construct();
    }
    private $idPuntoVenta,$cufd,$cafc,$fechaInicioEvento,$descripcion_evento,$id_evento,$fechaFinEvento,$codigoRecepcion;

    public function registrarEvento(string $cufd,string $cafc,int $descripcion_evento,string $fechaInicioEvento,int $idPuntoVenta)
    {
        $this->cufd=$cufd;
        $this->cafc=$cafc;
        $this->fechaInicioEvento=$fechaInicioEvento;
        $this->descripcion_evento=$descripcion_evento;
        $this->idPuntoVenta=$idPuntoVenta;
        
        $sql= "insert into eventosignificativo (cufd,cafc,descripcion_evento,fechaInicioEvento,codigoRecepcion,idPuntoVenta) values (?,?,?,?,0,?)";
        $datos= array( $this->cufd,$this->cafc,$this->descripcion_evento,$this->fechaInicioEvento,$this->idPuntoVenta);
        $data=$this->save($sql,$datos);
        if($data==1){
            $res="ok";
        }else{
            $res="error";
        }
        return $res;

    }
    public function getEventos($idPuntoVenta){
        $sql = "select * from eventosignificativo where idPuntoVenta=".$idPuntoVenta." ORDER BY id_evento DESC";
        $data = $this->selectAll($sql);
        return $data;
    }
    public function obtenerEvento(int $id){
        $sql="select * from eventosignificativo where id_evento='$id'";
        $data=$this->select($sql);
        return $data;
    }
    public function eliminarEvento(int $id){
        $this->id_evento = $id;
        $sql = "delete from eventosignificativo where id_evento=?";
        $datos= array($this->id_evento);
        $data=$this->save($sql,$datos);
        return $data;
    }
    public function finalizarEvento(int $id,string $fechaFinEvento,int $codigoRecepcion){
        $this->fechaFinEvento = $fechaFinEvento;
        $this->codigoRecepcion=$codigoRecepcion;
        $this->id_evento = $id;
        $sql = "update eventosignificativo set fechaFinEvento=?,codigoRecepcion=? where id_evento=?";
        $datos= array($this->fechaFinEvento,$this->codigoRecepcion,$this->id_evento);
        $data=$this->save($sql,$datos);
        return $data;
    }
    public function getEventosFinalizados($idPuntoVenta){
        $sql = "select e.cufd as cufd, e.descripcion_evento as descripcion_evento, e.id_evento as id_evento, e.codigoRecepcion as codigoRecepcion
                from facturas f
                join eventosignificativo e on f.cufd=e.cufd 
                where e.codigoRecepcion != 0 and e.idPuntoVenta=".$idPuntoVenta." and f.factura_estado=2
                group by (e.codigoRecepcion)
                order by id_evento desc";
        $data = $this->selectAll($sql);
        return $data;
    }
    
    public function lastEvento($idPuntoVenta){
        $sql = "select * FROM eventosignificativo where idPuntoVenta=".$idPuntoVenta." ORDER BY id_evento DESC LIMIT 1";
        $data = $this->select($sql);
        return $data;
    }
    
    

    
}
?>