<?php require_once "Views/templates/header.php"; ?>
<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Pedidos</h1>

        <a href="<?= base_url ?>Pedidos/nuevo_pedido" class="btn btn-primary"><i class="fas fa-plus"></i> Nuevo pedido</a>
    </div>
    <table class="table" id="tblPedidos">
        <thead class="thead-dark">
            <tr>
                <th>Nro.</th>
                <th>Fecha</th>
                <th>Razon social</th>
                <th>NIT/CI</th>
                <th>Total</th>
                <th>Estado</th>
                <th></th>
            </tr>
        </thead>
    </table>

    <!-- /.Modal Agragar Producto -->
    <button class="btn btn-primary" type="button" onclick="frmReportes();"><i class="fas fa-plus-circle"></i> Reporte de Ventas</button>


    <div class="modal fade" id="reporte" tabindex="-1" role="dialog" aria-labelledby="my-modal-title" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="title">Reporte de Ventas</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form method="POST" id="frmReporte">

                        <div class="form-group">
                            <label for="tipoPago">Tipo de Pago</label>
                            <select name="tipo_pago" id="tipo_pago" class="form-control">
                                <option value="0">Todos</option>
                                <?php foreach ($data['pagos'] as $pago) { ?>
                                    <option class="mb-5" value=<?= $pago['codigo'] ?>><?= $pago['descripcion'] ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="desde" class="col-form-label">Desde:</label>
                            <input type="date" class="form-control" id="desde" name="desde">
                        </div>
                        <div class="form-group">
                            <label for="hasta" class="col-form-label">Hasta:</label>
                            <input type="date" class="form-control" id="hasta" name="hasta">
                        </div>

                    </form>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-secondary" onclick="descargarExcel(event);" id="btnAccion1">Descargar Excel</button>
                    <button type="submit" class="btn btn-primary" onclick="verReporte(event);" id="btnAccion">Ver PDF</button>
                </div>
            </div>
        </div>
    </div>

</div>
<!-- /.container-fluid -->

</div>
<?php require_once "Views/templates/footer.php"; ?>