<?php



class Sincronizacion extends Controller{

    public function __construct()
    {
        session_start();
        $this->loadModel('ActividadesModel');
        $this->loadModel('ActividadesDocumentoSectorModel');
        $this->loadModel('ProductosServiciosModel');
        $this->loadModel('LeyendasModel');
        $this->loadModel('MensajesServiciosModel');
        $this->loadModel('EventosSignificativosModel');
        $this->loadModel('MotivosAnulacionModel');
        $this->loadModel('PaisesModel');
        $this->loadModel('DocumentoIdentidadModel');
        $this->loadModel('DocumentoSectorModel');
        $this->loadModel('EmisionModel');
        $this->loadModel('HabitacionModel');
        $this->loadModel('PagoModel');
        $this->loadModel('MonedaModel');
        $this->loadModel('TipoPuntoVentaModel');
        $this->loadModel('TipoFacturaModel');
        $this->loadModel('UnidadMedidasModel');
        $this->loadModel('EnlacesModel');
        $this->loadModel('SistemaModel');
        $this->loadModel('EmpresaModel');
        $this->loadModel('AmbienteModel');
        $this->loadModel('PuntoVentaModel');
        $this->loadModel('UsuariosModel');
        parent::__construct();
    }

    private function loadModel($model) {
        $modelPath = __DIR__ . '/../Models/' . $model . '.php';
        if (file_exists($modelPath)) {
            require_once $modelPath;
        } else {
            throw new Exception("Model file not found: " . $modelPath);
        }
    }

    public function index(){
        require "SiatSincronizacion.php";
        if(isset($_SESSION['id_usuario'])){
            
            $actividadesModel = new ActividadesModel();
            $actividadesDocumentoSectorModel = new ActividadesDocumentoSectorModel();
            $productosServiciosModel = new ProductosServiciosModel();
            $leyendasModel = new LeyendasModel();
            $mensajesServiciosModel= new MensajesServciosModel();
            $eventosSignifciativosModel= new EventosSignificativosModel();
            $motivosAnulacionModel= new MotivosAnulacionModel();
            $paisesModel=new PaisesModel();
            $documentoIdentidadModel= new DocumentoIdentidadModel();
            $documentoSectorModel= new DocumentoSectorModel();
            $emisionModel= new EmisionModel();
            $habitacionModel= new HabitacionModel();
            $pagosModel= new PagoModel();
            $monedasModel= new MonedaModel();
            $tipoPuntoVentaModel= new TipoPuntoVentaModel();
            $tipoFacturaModel= new TipoFacturaModel();
            $unidadmedidasModel = new UnidadMedidasModel();
            $enlacesModel=new EnlacesModel();
            $sistemaModel= new SistemaModel();
            $empresaModel=new EmpresaModel();
            $usuarioModel=new UsuariosModel();
            $puntoVentaModel= new PuntoVentaModel();
            $ambienteModel= new AmbienteModel();
            $siat = new SiatSincronizacion();

            ////////////////////////////////////////////////
            $usuario=$usuarioModel->editarUsuario($_SESSION['id_usuario']);
            $sistema=$sistemaModel->getSistema(1);
            $enlace=$enlacesModel->getEnlace(3);
            $pv=$puntoVentaModel->editarPuntoVenta($usuario['id_puntoventa']);
            $empresa=$empresaModel->getEmpresa(1);
            $ambiente=$ambienteModel->getAmbiente($sistema['ambiente']);
            $datosgenerales['wsdl']=$enlace;
            $datosgenerales['sistema']=$sistema;
            $datosgenerales['empresa']=$empresa;
            $datosgenerales['puntoventa']=$pv;
            $datosgenerales['ambiente']=$ambiente;
            /////////////////////////////////////////////////////




            $res = $siat->sincronizarActividades($datosgenerales);
            $datos=$res->RespuestaListaActividades->listaActividades;
            $upd=0;
            $new=0;
            if (is_array($datos)) {
                foreach ($datos as $actividad) {
                    if($actividadesModel->getActividad($actividad->codigoCaeb)){
                        $upd=$upd+$actividadesModel->updateActividad($actividad->codigoCaeb,$actividad->descripcion,$actividad->tipoActividad);
                        
                    }else{
                        $new=$new+$actividadesModel->insertActividad($actividad->codigoCaeb,$actividad->descripcion,$actividad->tipoActividad);
                    }
                    
    
                }
            } else {
                $actividad = $res->RespuestaListaActividades->listaActividades;
                if($actividadesModel->getActividad($actividad->codigoCaeb)){
                    $upd=$upd+$actividadesModel->updateActividad($actividad->codigoCaeb,$actividad->descripcion,$actividad->tipoActividad);
                }else{
                    $new=$new+$actividadesModel->insertActividad($actividad->codigoCaeb,$actividad->descripcion,$actividad->tipoActividad);
                }
            }
            $data['act']= $actividadesModel->getActividades();
            
            ///////////////////////////////////////////////
            $res1 = $siat->sincronizarListaProductosServicios($datosgenerales);
            $datos1=$res1->RespuestaListaProductos->listaCodigos;
            foreach ($datos1 as $productosservicios) {
                if($productosServiciosModel->getProductoServicio($productosservicios->codigoProducto,$productosservicios->codigoActividad)){
                    $upd=$upd+$productosServiciosModel->updateProductosServicios($productosservicios->codigoProducto,$productosservicios->codigoActividad,$productosservicios->descripcionProducto);
                    
                }else{
                    $new=$new+$productosServiciosModel->insertProductosServicios($productosservicios->codigoProducto,$productosservicios->codigoActividad,$productosservicios->descripcionProducto);
                    
                }
                
    
            }
            $data['prod']= $productosServiciosModel->getProductosServicios();
            
            $res2 = $siat->sincronizarListaLeyendasFactura($datosgenerales);
            $datos2=$res2->RespuestaListaParametricasLeyendas->listaLeyendas;
    
            foreach ($datos2 as $leyendas) {
                $desc=($leyendas->descripcionLeyenda);
                if(!$leyendasModel->getLeyenda($desc)){
                    $new=$new+$leyendasModel->insertLeyendas($leyendas->codigoActividad,$desc);
                }
                
    
            }
            $data['leyendas']= $leyendasModel->getLeyendas();
            ////////////////////////////////////////////////
            $res3 = $siat->sincronizarListaMensajesServicios($datosgenerales);
            $datos3=$res3->RespuestaListaParametricas->listaCodigos;
            foreach ($datos3 as $mensajesServicios) {
                
                if($mensajesServiciosModel->getMensajeServicio($mensajesServicios->codigoClasificador)){
                    $upd=$upd+$mensajesServiciosModel->updateMensajeServicio($mensajesServicios->codigoClasificador,$mensajesServicios->descripcion);
                    
                }else{
                    $new=$new+$mensajesServiciosModel->insertMensajeServicio($mensajesServicios->codigoClasificador,$mensajesServicios->descripcion);
                    
                }
                
    
            }
    
            $data['mensajes']= $mensajesServiciosModel->getMensajeServicios();//print_r($data);
            ////////////////////////////////////////////////
            $res4 = $siat->sincronizarListaActividadesDocumentoSector($datosgenerales);
            $datos4=$res4->RespuestaListaActividadesDocumentoSector->listaActividadesDocumentoSector;
            foreach ($datos4 as $actividad) {
                if($actividadesDocumentoSectorModel->getActividadDocumentoSector($actividad->codigoDocumentoSector)){
                    $upd=$upd+$actividadesDocumentoSectorModel->updateActividadDocumentoSector($actividad->codigoDocumentoSector,$actividad->codigoActividad,$actividad->tipoDocumentoSector);
                    
                }else{
                    $new=$new+$actividadesDocumentoSectorModel->insertActividadDocumentoSector($actividad->codigoDocumentoSector,$actividad->codigoActividad,$actividad->tipoDocumentoSector);
                }
                
    
            }
            
            
            $data['documento']= $actividadesDocumentoSectorModel->getActividadesDocumentoSector();//print_r($data);
            ////////////////////////////////////////////////
            $res5 = $siat->sincronizarParametricaEventosSignificativos($datosgenerales);
            $datos5=$res5->RespuestaListaParametricas->listaCodigos;
            
            foreach ($datos5 as $eventos) {
                
                if($eventosSignifciativosModel->getEventosSignificativo($eventos->codigoClasificador)){
                    $upd=$upd+$eventosSignifciativosModel->updateEventosSignificativo($eventos->codigoClasificador,$eventos->descripcion);
                    
                }else{
                    $new=$new+$eventosSignifciativosModel->insertEventosSignificativos($eventos->codigoClasificador,$eventos->descripcion);
                    
                }
                
    
            }
    
            $data['eventos']= $eventosSignifciativosModel->getEventosSignificativos();//print_r($data);
            ////////////////////////////////////////////////
            $res6 = $siat->sincronizarParametricaMotivoAnulacion($datosgenerales);
            $datos6=$res6->RespuestaListaParametricas->listaCodigos;
            foreach ($datos6 as $motivos) {
                if($motivosAnulacionModel->getMotivoAnulacion($motivos->codigoClasificador)){
                    $upd=$upd+$motivosAnulacionModel->updateMotivosAnulacion($motivos->codigoClasificador,$motivos->descripcion);
                        
                }else{
                    $new=$new+$motivosAnulacionModel->insertMotivosAnulacion($motivos->codigoClasificador,$motivos->descripcion);
                    
                }
                
    
            }
            $data['anulacion']= $motivosAnulacionModel->getMotivosAnulacion();//print_r($data);
            
            ////////////////////////////////////////////////
            $res7 = $siat->sincronizarParametricaPaisOrigen($datosgenerales);
            $datos7=$res7->RespuestaListaParametricas->listaCodigos;
            foreach ($datos7 as $pais) {
                if($paisesModel->getPais($pais->codigoClasificador)){
                    $upd=$upd+$paisesModel->updatePaises($pais->codigoClasificador,$pais->descripcion);
                        
                }else{
                    $new=$new+$paisesModel->insertPaises($pais->codigoClasificador,$pais->descripcion);
                    
                }
                
    
            }
            
            $data['pais']= $paisesModel->getPaises();//print_r($data);
            
            ////////////////////////////////////////////////
            $res8 = $siat->sincronizarParametricaTipoDocumentoIdentidad($datosgenerales);
            $datos8=$res8->RespuestaListaParametricas->listaCodigos;
    
            foreach ($datos8 as $documentos) {
                if($documentoIdentidadModel->getDocumentoIdentidad($documentos->codigoClasificador)){
                    $upd=$upd+$documentoIdentidadModel->updateDocumentoIdentidad($documentos->codigoClasificador,$documentos->descripcion);
                        
                }else{
                    $new=$new+$documentoIdentidadModel->insertDocumentoIdentidad($documentos->codigoClasificador,$documentos->descripcion);
                    
                }
                
    
            }
            $data['identidad']= $documentoIdentidadModel->getDocumentoIdentidades();//print_r($data);
            ////////////////////////////////////////////////
            $res9 = $siat->sincronizarParametricaTipoDocumentoSector($datosgenerales);
            $datos9=$res9->RespuestaListaParametricas->listaCodigos;
            foreach ($datos9 as $tipoDocumentoSector) {
                if($documentoSectorModel->getDocumentoSector($tipoDocumentoSector->codigoClasificador)){
                    $upd=$upd+$documentoSectorModel->updateDocumentoSector($tipoDocumentoSector->codigoClasificador,$tipoDocumentoSector->descripcion);
                        
                }else{
                    $new=$new+$documentoSectorModel->insertDocumentoSector($tipoDocumentoSector->codigoClasificador,$tipoDocumentoSector->descripcion);
                    
                }
                
    
            }
            $datos9= json_encode($datos9);
            $data['docsector']= $documentoSectorModel->getDocumentoSectores();//print_r($data);
            
            ////////////////////////////////////////////////
            $res10 = $siat->sincronizarParametricaTipoEmision($datosgenerales);
            $datos10=$res10->RespuestaListaParametricas->listaCodigos;
            foreach ($datos10 as $tipoEmision) {
                if($emisionModel->getEmision($tipoEmision->codigoClasificador)){
                    $upd=$upd+$emisionModel->updateEmision($tipoEmision->codigoClasificador,$tipoEmision->descripcion);
                        
                }else{
                    $new=$new+$emisionModel->insertEmision($tipoEmision->codigoClasificador,$tipoEmision->descripcion);
                    
                }
                
    
            }
            $data['emision']= $emisionModel->getEmisiones();//print_r($data);
            
            ////////////////////////////////////////////////
            $res11 = $siat->sincronizarParametricaTipoHabitacion($datosgenerales);
            $datos11=$res11->RespuestaListaParametricas->listaCodigos;
            foreach ($datos11 as $tipoHabitacion) {
                if($habitacionModel->getHabitacion($tipoHabitacion->codigoClasificador)){
                    $upd=$upd+$habitacionModel->updateHabitacion($tipoHabitacion->codigoClasificador,$tipoHabitacion->descripcion);
                        
                }else{
                    $new=$new+$habitacionModel->insertHabitacion($tipoHabitacion->codigoClasificador,$tipoHabitacion->descripcion);
                    
                }
                
    
            }
            $data['habitacion']= $habitacionModel->getHabitaciones();//print_r($data);
            
            ////////////////////////////////////////////////
            $res12 = $siat->sincronizarParametricaTipoMetodoPago($datosgenerales);
            $datos12=$res12->RespuestaListaParametricas->listaCodigos;
            foreach ($datos12 as $tipoPagos) {
                if($pagosModel->getPago($tipoPagos->codigoClasificador)){
                    $upd=$upd+$pagosModel->updatePago($tipoPagos->codigoClasificador,$tipoPagos->descripcion);
                        
                }else{
                    $new=$new+$pagosModel->insertPago($tipoPagos->codigoClasificador,$tipoPagos->descripcion);
                    
                }
                
    
            }
            $data['pagos']= $pagosModel->getPagos();//print_r($data);
            
            
            ////////////////////////////////////////////////
            $res13 = $siat->sincronizarParametricaTipoMoneda($datosgenerales);
            $datos13=$res13->RespuestaListaParametricas->listaCodigos;
            foreach ($datos13 as $tipoMonedas) {
                if($monedasModel->getMoneda($tipoMonedas->codigoClasificador)){
                    $upd=$upd+$monedasModel->updateMoneda($tipoMonedas->codigoClasificador,$tipoMonedas->descripcion);
                        
                }else{
                    $new=$new+$monedasModel->insertMoneda($tipoMonedas->codigoClasificador,$tipoMonedas->descripcion);
                    
                }
                
    
            }
            $data['monedas']= $monedasModel->getMonedas();//print_r($data);
            
            ////////////////////////////////////////////////
            $res14 = $siat->sincronizarParametricaTipoPuntoVenta($datosgenerales);
            $datos14=$res14->RespuestaListaParametricas->listaCodigos;
            foreach ($datos14 as $tipoPuntoVenta) {
                if($tipoPuntoVentaModel->getPuntoVenta($tipoPuntoVenta->codigoClasificador)){
                    $upd=$upd+$tipoPuntoVentaModel->updatePuntoVenta($tipoPuntoVenta->codigoClasificador,$tipoPuntoVenta->descripcion);
                        
                }else{
                    $new=$new+$tipoPuntoVentaModel->insertPuntoVenta($tipoPuntoVenta->codigoClasificador,$tipoPuntoVenta->descripcion);
                    
                }
                
    
            }
            $data['puntos']= $tipoPuntoVentaModel->getPuntoVentas();//print_r($data);
            
            ////////////////////////////////////////////////
            $res15 = $siat->sincronizarParametricaTiposFactura($datosgenerales);
            $datos15=$res15->RespuestaListaParametricas->listaCodigos;
            foreach ($datos15 as $tipoFactura) {
                if($tipoFacturaModel->getTipoFactura($tipoFactura->codigoClasificador)){
                    $upd=$upd+$tipoFacturaModel->updateTipoFactura($tipoFactura->codigoClasificador,$tipoFactura->descripcion);
                        
                }else{
                    $new=$new+$tipoFacturaModel->insertTipoFactura($tipoFactura->codigoClasificador,$tipoFactura->descripcion);
                    
                }
                
    
            }
            $data['tiposfac']= $tipoFacturaModel->getTipoFacturas();//print_r($data);
            ////////////////////////////////////////////////
            $res16 = $siat->sincronizarParametricaUnidadMedida($datosgenerales);
            $datos16=$res16->RespuestaListaParametricas->listaCodigos;
            foreach ($datos16 as $medidas) {
                if($unidadmedidasModel->getUnidadMedida($medidas->codigoClasificador)){
                    $upd=$upd+$unidadmedidasModel->updateUnidadMedida($medidas->codigoClasificador,$medidas->descripcion);
                        
                }else{
                    $new=$new+$unidadmedidasModel->insertUnidadMedida($medidas->codigoClasificador,$medidas->descripcion);
                    
                }
                
    
            }
            
            $data['medidas']= $unidadmedidasModel->getUnidadMedidas();//print_r($data);
            //echo $upd . "<br>";
            //echo $new . "<br>";
            date_default_timezone_set('America/La_Paz');
            $hoy=new DateTime();
            $hoy = $hoy->format('Y-m-d H:i:s');
            $resSinc=$this->model->insertSincronizacion($hoy,$new,$upd);
            
            //exit();
        }else{
            $data="1";
        }

        
        $this->views->getView($this,"index",$data);
    }

    

    public function actividades(){
        
    }




    
    

}
?>

