<?php
class Usuarios extends Controller
{
    public function __construct()
    {   
        session_start();
        $this->loadModel('PuntoVentaModel');
        $this->loadModel('SistemaModel');
        $this->loadModel('EmpresaModel');
        $this->loadModel('AmbienteModel');
        $this->loadModel('CufdModel');
        parent::__construct();
    }
    private function loadModel($model) {
        $modelPath = __DIR__ . '/../Models/' . $model . '.php';
        if (file_exists($modelPath)) {
            require_once $modelPath;
        } else {
            throw new Exception("Model file not found: " . $modelPath);
        }
    }

    public function index(){
        $puntoventaModel= new PuntoVentaModel();
        $data['puntoventas']=$puntoventaModel->getPuntoVenta();
        $this->views->getView($this,"index",$data);
    }
    

    public function cufd($puntoventa){
        require "SiatCodigos.php";
        $sistemaModel= new SistemaModel();
        $empresaModel=new EmpresaModel();
        $ambienteModel= new AmbienteModel();
        $cufdModel= new CufdModel();
        $sistema=$sistemaModel->getSistema(1);
        $empresa=$empresaModel->getEmpresa(1);
        $ambiente=$ambienteModel->getAmbiente($sistema['ambiente']);
        $datosgenerales['sistema']=$sistema;
        $datosgenerales['empresa']=$empresa;
        $datosgenerales['puntoventa']=$puntoventa;
        $datosgenerales['ambiente']=$ambiente;
        $siat = new SiatCodigos();
        $res = $siat->cuis($datosgenerales,$puntoventa);
        if($res->RespuestaCuis->transaccion){
            $puntoventaModel2=new PuntoVentaModel();
            $puntoventa['cuis']=$res->RespuestaCuis->codigo;
            $puntoventa['vigenciaCuis']=$res->RespuestaCuis->fechaVigencia;
            $respuesta=$puntoventaModel2->actualizarCuis($puntoventa['cuis'],$puntoventa['vigenciaCuis'],$puntoventa['id_puntoVenta']);
            $_SESSION['scuis']=$res->RespuestaCuis->codigo;
            $_SESSION['sfechavigenciaCuis']=$res->RespuestaCuis->fechaVigencia;
            $_SESSION['estado']="1";
            $rescufd = $siat->cufd($datosgenerales,$puntoventa);
            if ($rescufd->RespuestaCufd->transaccion == true) {
                $cufd = $rescufd->RespuestaCufd->codigo;
                $codigoControl = $rescufd->RespuestaCufd->codigoControl;
                $fechaVigencia = $rescufd->RespuestaCufd->fechaVigencia;
                $fechaSolicitud = new DateTime($fechaVigencia);
                $fechaSolicitud->modify("-1 day");
                $fSol=$fechaSolicitud->format("Y-m-d\TH:i:s.vP");
                $msgCufd=$cufdModel->insertCufd($cufd,$codigoControl,$fSol,$fechaVigencia,$puntoventa['id_puntoVenta']);
                $_SESSION['scufd'] = $cufd;
                $_SESSION['scodigoControl'] = $codigoControl;
                $_SESSION['svigenciaCufd'] = $fechaVigencia;
            } else {
                $rescufd = false;
            } 
        }else{

            $_SESSION['scuis']=$puntoventa['cuis'];
            $_SESSION['sfechavigenciaCuis']=$puntoventa['vigenciaCuis'];
            $_SESSION['estado']="1";


            date_default_timezone_set('America/La_Paz');
            $cufd1=$cufdModel->getCufd($puntoventa['id_puntoVenta']);
            if(isset($cufd1)){
                $fechaV = new DateTime($cufd1['fechaVigencia']);
                
            }else{
                $fechaV= new DateTime();
                $fechaV->setTime(
                    $fechaV->format('H'),
                    $fechaV->format('i'),
                    $fechaV->format('s'),
                    (int)$fechaV->format('u') // Configurar microsegundos
                );
            }
            $fechaActual = new DateTime();
            $fechaActual->setTime(
                $fechaActual->format('H'),
                $fechaActual->format('i'),
                $fechaActual->format('s'),
                (int)$fechaActual->format('u') // Configurar microsegundos
            );
            if($fechaActual->format('Y-m-d') >= $fechaV->format('Y-m-d')){
                
                $rescufd = $siat->cufd($datosgenerales,$puntoventa);
                if ($rescufd->RespuestaCufd->transaccion == true) {
                    $cufd = $rescufd->RespuestaCufd->codigo;
                    $codigoControl = $rescufd->RespuestaCufd->codigoControl;
                    $fechaVigencia = $rescufd->RespuestaCufd->fechaVigencia;
                    $fechaSolicitud = new DateTime($fechaVigencia);
                    $fechaSolicitud->modify("-1 day");
                    $fSol=$fechaSolicitud->format("Y-m-d\TH:i:s.vP");
                    $msgCufd=$cufdModel->insertCufd($cufd,$codigoControl,$fSol,$fechaVigencia,$puntoventa['id_puntoVenta']);
                    $_SESSION['scufd'] = $cufd;
                    $_SESSION['scodigoControl'] = $codigoControl;
                    $_SESSION['svigenciaCufd'] = $fechaVigencia;
                } else {
                    $rescufd = false;
                } 
            }else{
                $_SESSION['scufd'] = $cufd1['codigo'];
                $_SESSION['scodigoControl'] = $cufd1['codigoControl'];
                $_SESSION['svigenciaCufd'] = $cufd1['fechaVigencia'];
            }
        }
    }
   
    public function validar(){
        date_default_timezone_set('America/La_Paz');
        if(empty($_POST['nick']) || empty($_POST['clave'])){
            $msg="Todos los campos son obligatorios";
        }else{
            $nick=$_POST['nick'];
            $clave=md5($_POST['clave']);
            $data=$this->model->getUsuario($nick,$clave);
            if($data){
                $puntoventaModel= new PuntoVentaModel();
                $_SESSION['id_usuario']= $data['id_usuario'];
                $_SESSION['nick']= $data['nick'];
                $_SESSION['nombre']= $data['nombre'];
                $_SESSION['rol']= $data['rol'];
                $_SESSION['fechaIngreso']= new DateTime();
                $puntoventa=$puntoventaModel->editarPuntoVenta($data['id_puntoventa']);
                $this->cufd($puntoventa);
                $msg="ok";
                /*require "Categorias.php";
                $cat= new Categorias();
                $cat->SincronizarSIAT1();*/
            }else{
                $msg="Usuario o contraseña incorrecto";
            }
        }
        echo json_encode($msg,JSON_UNESCAPED_UNICODE);
        die();
    }
    public function listar(){
        $data=$this->model->getUsuarios();
        for($i=0;$i<count($data);$i++){
            if($data[$i]['usuario_estado']==1){
                $data[$i]['usuario_estado']='<span class="badge bg-success">Activo</span>';
                $data[$i]['acciones']='<div><button class="btn btn-primary" type="button" onclick="btnEditarUsuario('.$data[$i]['id_usuario'].')"><i class="fas fa-edit"></i></button>
            <button class="btn btn-danger" type="button" onclick="btnInactivarUsuario('.$data[$i]['id_usuario'].')""><i class="fas fa-trash"></i></button>
            </div>';
            }else{
                $data[$i]['usuario_estado']='<span class="badge bg-danger">Inactivo</span>';
                $data[$i]['acciones']='<div><button class="btn btn-success" type="button" onclick="btnReactivarUsuario('.$data[$i]['id_usuario'].')""><i class="fas fa-plus-circle"></i></button>
            </div>';
            }
            

        }
        echo json_encode($data);
        die();
    }

    public function registrar(){
        $id_usuario=$_POST['id_usuario'];
        $nick = $_POST['nick'];
        $nombre = $_POST['nombre'];
        $clave = md5($_POST['clave']);
        $confirmar = md5($_POST['confirmar']);
        $id_puntoventa = $_POST['id_puntoventa'];

        if(empty($nick) || empty($nombre) || empty($clave)){
            $msg= "Todos los campos son obligatorios";
        }else{
            if($id_usuario==""){
                if($clave!=$confirmar){
                    $msg="Las contraseñas no coinciden";
                }else{
                    $data=$this->model->registrarUsuario($nick,$nombre,$clave,$id_puntoventa);
                    if($data=="ok"){
                        $msg="si";
                    }else{
                        $msg="Error al registrar el usuario";
                    }
                }    
            }else{
                $data=$this->model->modificarUsuario($nick,$nombre,$id_puntoventa,$id_usuario);
                if($data=="modificado"){
                    $msg="modificado";
                }else{
                    $msg="Error al modificar el usuario";
                }
            }
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
        
    }
    public function editar(int $id){
        $data = $this->model->editarUsuario($id);
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function inactivar(int $id){
        $data = $this->model->accion(0,$id);
        if($data==1){
            $msg="ok";
        }else{
            $msg="Error al inactivar el usuario";
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    
    public function activar(int $id){
        $data = $this->model->accion(1,$id);
        if($data==1){
            $msg="ok";
        }else{
            $msg="Error al activar el usuario";
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    

}
?>
