let tblUsuarios;
let tblCajas;
document.addEventListener("DOMContentLoaded", function(){
    tblUsuarios= $("#tblUsuarios").DataTable({
        ajax:{
            url: base_url + 'Usuarios/listar',
            dataSrc: ''
        },
        columns:[
            {'data':'id_usuario'},
            {'data':'nick'},
            {'data':'nombre'},
            {'data':'descripcion'},
            {'data':'usuario_estado'},
            {'data':'acciones'}
        ],
        language: {
            "lengthMenu": "Mostrar _MENU_ resultados por pagina",
            "zeroRecords": "No se encontro",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "No hay registros",
            "infoFiltered": "(Filtrando from _MAX_ total total)",
            "search":         "Buscar:",
            "paginate": {
                "first":      "Primero",
                "last":       "Ultimo",
                "next":       "Siguiente",
                "previous":   "Anterior"
            },
        }

    })

    tblProductosServicios= $("#tblProductosServicios").DataTable({
        ajax:{
            url: base_url + 'ProductosServicios/listar',
            dataSrc: ''
        },
        columns:[
            {'data':'id'},
            {'data':'codigoActividad'},
            {'data':'codigoProducto'},
           {'data':'descripcionProducto'},
            {'data':'acciones'}
        ],
        language: {
            "lengthMenu": "Mostrar _MENU_ resultados por pagina",
            "zeroRecords": "No se encontro",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "No hay registros",
            "infoFiltered": "(Filtrando from _MAX_ total total)",
            "search":         "Buscar:",
            "paginate": {
                "first":      "Primero",
                "last":       "Ultimo",
                "next":       "Siguiente",
                "previous":   "Anterior"
            },
        }
    })

    tblPuntoVenta= $("#tblPuntoVenta").DataTable({
        ajax:{
            url: base_url + 'PuntoVenta/listar',
            dataSrc: ''
        },
        columns:[
            {'data':'sdescripcion'},
            {'data':'descripcion'},
            {'data':'cuis'},
            {'data':'vigencia'},
            {'data':'codigopuntoventa'},
            {'data':'acciones'}
        ],
        language: {
            "lengthMenu": "Mostrar _MENU_ resultados por pagina",
            "zeroRecords": "No se encontro",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "No hay registros",
            "infoFiltered": "(Filtrando from _MAX_ total total)",
            "search":         "Buscar:",
            "paginate": {
                "first":      "Primero",
                "last":       "Ultimo",
                "next":       "Siguiente",
                "previous":   "Anterior"
            },
        }
    })

    tblClientes= $("#tblClientes").DataTable({
        ajax:{
            url: base_url + 'Clientes/listar',
            dataSrc: ''
        },
        columns:[
            {'data':'id_cliente'},
            {'data':'razon_social'},
            {'data':'documentoid'},
            {'data':'complementoid'},
            {'data':'cliente_email'},
            {'data':'cliente_estado'},
            {'data':'acciones'}
        ],
        language: {
            "lengthMenu": "Mostrar _MENU_ resultados por pagina",
            "zeroRecords": "No se encontro",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "No hay registros",
            "infoFiltered": "(Filtrando from _MAX_ total total)",
            "search":         "Buscar:",
            "paginate": {
                "first":      "Primero",
                "last":       "Ultimo",
                "next":       "Siguiente",
                "previous":   "Anterior"
            },
        }
    })

   

    tblUnidadMedidas= $("#tblUnidadMedidas").DataTable({
        ajax:{
            url: base_url + 'UnidadMedidas/listar',
            dataSrc: ''
        },
        columns:[
            {'data':'codigo'},
            {'data':'descripcion'},
            {'data':'estado'},
            {'data':'acciones'}
        ],
        language: {
            "lengthMenu": "Mostrar _MENU_ resultados por pagina",
            "zeroRecords": "No se encontro",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "No hay registros",
            "infoFiltered": "(Filtrando from _MAX_ total total)",
            "search":         "Buscar:",
            "paginate": {
                "first":      "Primero",
                "last":       "Ultimo",
                "next":       "Siguiente",
                "previous":   "Anterior"
            },
        }
    })

    tblProductos= $("#tblProductos").DataTable({
        ajax:{
            url: base_url + 'Productos/listar',
            dataSrc: ''
        },
        columns:[
            {'data':'codigo'},
            {'data':'descripcionProducto'},
            {'data':'nombre_producto'},
            {'data':'precio_venta'},
            {'data':'descripcion'},
            {'data':'producto_estado'},
            {'data':'acciones'}
        ],
        language: {
            "lengthMenu": "Mostrar _MENU_ resultados por pagina",
            "zeroRecords": "No se encontro",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "No hay registros",
            "infoFiltered": "(Filtrando from _MAX_ total total)",
            "search":         "Buscar:",
            "paginate": {
                "first":      "Primero",
                "last":       "Ultimo",
                "next":       "Siguiente",
                "previous":   "Anterior"
            },
        }
    })

    tblPedidos = $("#tblPedidos").DataTable({
        ajax: {
            url: base_url + 'Pedidos/listar',
            dataSrc: ''
        },
        columns: [
            { 'data': 'numeroFactura' },
            { 'data': 'fechaEmision' },
            { 'data': 'razon_social' },
            { 'data': 'documentoid' },
            { 'data': 'montoTotal' },
            { 'data': 'acciones' }
        ],
        order: [[1, 'desc']],
        language: {
            "lengthMenu": "Display _MENU_ resultados por página",
            "zeroRecords": "No se encontro",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "No hay registros",
            "infoFiltered": "(Filrando from _MAX_ total)",
            "search":         "Buscar:",
            "paginate": {
                "first":      "Primera",
                "last":       "Ultima",
                "next":       "Sig.",
                "previous":   "Ant."
            },
        }
    })
    tblEventos= $("#tblEventos").DataTable({
        ajax:{
            url: base_url + 'Avanzado/listarEventos',
            dataSrc: ''
        },
        columns:[
            {'data':'id_evento'},
            {'data':'cufd'},
            {'data':'descripcion_evento'},
            {'data':'fechaInicioEvento'},
            {'data':'fechaFinEvento'},
            {'data':'codigoRecepcion'},
            {'data':'acciones'}
        ],
        order: [[0, 'desc']],
        language: {
            "lengthMenu": "Mostrar _MENU_ resultados por pagina",
            "zeroRecords": "No se encontro",
            "info": "Mostrando página _PAGE_ de _PAGES_",
            "infoEmpty": "No hay registros",
            "infoFiltered": "(Filtrando from _MAX_ total total)",
            "search":         "Buscar:",
            "paginate": {
                "first":      "Primero",
                "last":       "Ultimo",
                "next":       "Siguiente",
                "previous":   "Anterior"
            },
        }
    })

    if(document.getElementById("id_evento").value!=""){
        tblPedidosSC = $("#tblPedidosSC").DataTable({
            ajax: {
                url: base_url + 'Avanzado/PedidosSC/'+document.getElementById("id_evento").value,
                
                dataSrc: ''
            },
            columns: [
                { 'data': 'numeroFactura' },
                { 'data': 'fechaEmision' },
                { 'data': 'razon_social' },
                { 'data': 'documentoid' },
                { 'data': 'cliente_email' },
                { 'data': 'montoTotal' },
                { 'data': 'descuentoAdicional' },
                { 'data': 'acciones' }
            ],
            order: [[0, 'desc']],
            language: {
                "lengthMenu": "Display _MENU_ resultados por página",
                "zeroRecords": "No se encontro",
                "info": "Mostrando página _PAGE_ de _PAGES_",
                "infoEmpty": "No hay registros",
                "infoFiltered": "(Filrando from _MAX_ total)",
                "search":         "Buscar:",
                "paginate": {
                    "first":      "Primera",
                    "last":       "Ultima",
                    "next":       "Sig.",
                    "previous":   "Ant."
                },
            }
        })
    }
    

    if(document.getElementById("codigoRecepcion")!=null){
        tblPedidosSCP = $("#tblPedidosSCP").DataTable({
            ajax: {
                url: base_url + 'Avanzado/PedidosSCP/'+document.getElementById("codigoRecepcion").value,
                
                dataSrc: ''
            },
            columns: [
                { 'data': 'numeroFactura' },
                { 'data': 'fechaEmision' },
                { 'data': 'razon_social' },
                { 'data': 'documentoid' },
                { 'data': 'cliente_email' },
                { 'data': 'montoTotal' },
                { 'data': 'descuentoAdicional' },
                { 'data': 'acciones' }
            ],
            order: [[0, 'desc']],
            language: {
                "lengthMenu": "Display _MENU_ resultados por página",
                "zeroRecords": "No se encontro",
                "info": "Mostrando página _PAGE_ de _PAGES_",
                "infoEmpty": "No hay registros",
                "infoFiltered": "(Filrando from _MAX_ total)",
                "search":         "Buscar:",
                "paginate": {
                    "first":      "Primera",
                    "last":       "Ultima",
                    "next":       "Sig.",
                    "previous":   "Ant."
                },
            }
        })
    }
    

    
})


function frmUsuario(){
    document.getElementById("title").innerHTML="Nuevo Usuario"
    document.getElementById("btnAccion").innerHTML="Registrar"
    document.getElementById("id_usuario").value=""
    document.getElementById("claves").classList.remove("d-none")
    document.getElementById("frmUsuario").reset()
    $("#nuevo_usuario").modal("show");
}

function registrarUsuario(e){
    e.preventDefault()
    const nick=document.getElementById("nick")
    const nombre=document.getElementById("nombre")
    const clave=document.getElementById("clave")
    const id_puntoventa=document.getElementById("id_puntoventa")
    const confirmar=document.getElementById("confirmar")
    if(nick.value=="" || nombre.value=="" || clave.value==""){
        Swal.fire({
          icon: 'warning',
          title: 'Alerta',
          text: 'Los campos son obligatorios'

        })
    }else{
        const url = base_url +"Usuarios/registrar"
        const frm = document.getElementById("frmUsuario")
        const http= new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(frm))
        http.onreadystatechange = function(){
            if(this.readyState == 4 && this.status==200){
                const res = JSON.parse(this.responseText)
                if(res=="si"){
                    Swal.fire({
                        icon: 'success',
                        title: 'Usuario Registrado con éxito',
                        text: '',
                        showConfirmButton:false,
                        timer: 2000
              
                      })  
                      $("#nuevo_usuario").modal("hide")
                      tblUsuarios.ajax.reload()
                }else if(res=="modificado"){
                    Swal.fire({
                        icon: 'success',
                        title: 'Usuario modificado con éxito',
                        text: '',
                        showConfirmButton:false,
                        timer: 2000
              
                      })  
                      $("#nuevo_usuario").modal("hide")
                      tblUsuarios.ajax.reload()
                }
                else{
                    Swal.fire({
                        icon: 'error',
                        title: res,
                        text: ''
              
                      })
                      $("#nuevo_usuario").modal("hide")
                }
            }
        }
    }
    console.log(nick)
}

function btnEditarUsuario(id){
    document.getElementById("title").innerHTML="Actualizar usuario"
    document.getElementById("btnAccion").innerHTML="Modificar"
    const url= base_url+"Usuarios/editar/"+id
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send()
    http.onreadystatechange = function(){
        if(this.readyState == 4 && this.status==200){
            const res = JSON.parse(this.responseText)
            document.getElementById("id_usuario").value=res.id_usuario
            document.getElementById("nick").value=res.nick
            document.getElementById("nombre").value=res.nombre
            document.getElementById("clave").value=1
            document.getElementById("claves").classList.add("d-none")
            $("#nuevo_usuario").modal("show")
            
        }
    }
}

function btnInactivarUsuario(id){
    Swal.fire({
        title: '¿Estás seguro de inactivar al usuario?',
        text: "El usuario no se eliminará de forma permanente solo cambiara el estado a inactivo",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Confirmar',
        cancelButtonText: 'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            const url= base_url+"Usuarios/inactivar/"+id
            const http= new XMLHttpRequest()
            http.open("GET",url,true)
            http.send()
            http.onreadystatechange=function(){
                if(this.readyState == 4 && this.status==200){
                    const res = JSON.parse(this.responseText)
                    if(res=="ok"){
                        Swal.fire(
                            'Mensaje!',
                            'Usuario inactivado con éxito',
                            'success',
                           
                          )
                        tblUsuarios.ajax.reload()
                    }else{
                        Swal.fire(
                            'Mensaje!',
                            res,
                            'error'
                          )
                    }
                }                
            }
            
        }
      })
}

function btnReactivarUsuario(id){
    Swal.fire({
        title: '¿Estás seguro de activar al usuario?',
        text: '',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Confirmar',
        cancelButtonText: 'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            const url= base_url+"Usuarios/activar/"+id
            const http= new XMLHttpRequest()
            http.open("GET",url,true)
            http.send()
            http.onreadystatechange=function(){
                if(this.readyState == 4 && this.status==200){
                    const res = JSON.parse(this.responseText)
                    if(res=="ok"){
                        Swal.fire(
                            'Mensaje!',
                            'Usuario activado con éxito',
                            'success',
                           
                          )
                        tblUsuarios.ajax.reload()
                    }else{
                        Swal.fire(
                            'Mensaje!',
                            res,
                            'error'
                          )
                    }
                }                
            }
            
        }
      })
}

//-------------------PUNTOS DE VENTA--------------------------//
//--------------------------------------------------//
function frmPuntoVenta(){
    document.getElementById("title").innerHTML="Nuevo Punto de Venta"
    document.getElementById("btnAccion").innerHTML="Registrar"
    document.getElementById("id_puntoventa").value=""
    document.getElementById("frmPuntoVenta").reset()
    $("#nuevo_puntoventa").modal("show");
}

function registrarPuntoVenta(e){
    e.preventDefault()
    const id_sucursal=document.getElementById("id_sucursal")
    const tipopuntoventa=document.getElementById("tipopuntoventa")
    const descripcion=document.getElementById("descripcion")
    if(id_sucursal.value=="" || tipopuntoventa.value=="" || descripcion.value==""){
        Swal.fire({
          icon: 'warning',
          title: 'Alerta',
          text: 'Los campos son obligatorios 2'

        })
    }else{
        const url = base_url +"PuntoVenta/registrar"
        const frm = document.getElementById("frmPuntoVenta")
        const http= new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(frm))
        http.onreadystatechange = function(){
            if(this.readyState == 4 && this.status==200){
                const res = JSON.parse(this.responseText)
                if(res=="si"){
                    Swal.fire({
                        icon: 'success',
                        title: 'Punto de Venta Registrado con éxito',
                        text: '',
                        showConfirmButton:false,
                        timer: 2000
              
                      })  
                      $("#nuevo_puntoventa").modal("hide")
                      tblPuntoVenta.ajax.reload()
                }else{
                    Swal.fire({
                        icon: 'error',
                        title: res,
                        text: ''
              
                      })
                      $("#nuevo_puntoventa").modal("hide")
                }
            }
        }
    }
}

function btnEliminarPV(id){
    Swal.fire({
        title: '¿Estás seguro de eliminar el Punto de Venta?',
        text: "El Punto de Venta se eliminará de forma permanente del sistema",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Confirmar',
        cancelButtonText: 'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            const url= base_url+"PuntoVenta/eliminar/"+id
            const http= new XMLHttpRequest()
            http.open("GET",url,true)
            http.send()
            http.onreadystatechange=function(){
                if(this.readyState == 4 && this.status==200){
                    const res = JSON.parse(this.responseText)
                    if(res=="ok"){
                        Swal.fire(
                            'Mensaje!',
                            'Punto Venta Eliminado con éxito',
                            'success',
                           
                          )
                          tblPuntoVenta.ajax.reload()
                    }else{
                        Swal.fire(
                            'Mensaje!',
                            res,
                            'error'
                          )
                    }
                }                
            }
            
        }
      })
}



//-------------------CLIENTES-----------------------//
//--------------------------------------------------//
function frmCliente(){
    document.getElementById("title").innerHTML="Nuevo Cliente"
    document.getElementById("btnAccion").innerHTML="Registrar"
    document.getElementById("id_cliente_c").value=""
    document.getElementById("frmCliente").reset()
    $("#nuevo_cliente").modal("show");
}

function registrarCliente(e){
    e.preventDefault()
    const documentoid=document.getElementById("documentoid_c")
    const complementoid=document.getElementById("complementoid_c")
    const razon_social=document.getElementById("razon_social_c")
    const tipo_documento=document.getElementById("tipo_documento_c")
    const cliente_email=document.getElementById("cliente_email_c")
    const cliente_celular=document.getElementById("cliente_celular_c")
    
    if(documentoid.value=="" || razon_social.value=="" || tipo_documento.value==""){
        Swal.fire({
          icon: 'warning',
          title: 'Alerta',
          text: 'Los campos son obligatorios'

        })
    }else{
        const url = base_url +"Clientes/registrar"
        const frm = document.getElementById("frmCliente")
        const http= new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(frm))
        http.onreadystatechange = function(){
            if(this.readyState == 4 && this.status==200){
                const res = JSON.parse(this.responseText)
                if(res=="si"){
                    Swal.fire({
                        icon: 'success',
                        title: 'Cliente Registrado con éxito',
                        text: '',
                        showConfirmButton:false,
                        timer: 2000
              
                      })  
                      $("#nuevo_cliente").modal("hide")
                      buscarCliente();
                      tblClientes.ajax.reload()
                }else if(res=="modificado"){
                    Swal.fire({
                        icon: 'success',
                        title: 'Cliente modificado con éxito',
                        text: '',
                        showConfirmButton:false,
                        timer: 2000
              
                      })  
                      $("#nuevo_cliente").modal("hide")
                      document.getElementById("documentoid").value=document.getElementById("documentoid_c").value
                    document.getElementById("razon_social").value=document.getElementById("razon_social_c").value
                    document.getElementById("tipo_documento").value=document.getElementById("tipo_documento_c").value
                    document.getElementById("cliente_email").value=document.getElementById("cliente_email_c").value
                      tblClientes.ajax.reload()
                }
                else{
                    Swal.fire({
                        icon: 'error',
                        title: res,
                        text: ''
              
                      })
                      $("#nuevo_cliente").modal("hide")
                }
            }
        }
    }
}

function btnEditarCliente(id){
    document.getElementById("title").innerHTML="Actualizar cliente"
    document.getElementById("btnAccion").innerHTML="Modificar"
    const url= base_url+"Clientes/editar/"+id
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send()
    http.onreadystatechange = function(){
        if(this.readyState == 4 && this.status==200){
            const res = JSON.parse(this.responseText)
            document.getElementById("id_cliente_c").value=res.id_cliente
            document.getElementById("documentoid_c").value=res.documentoid
            document.getElementById("complementoid_c").value=res.complementoid
            document.getElementById("tipo_documento_c").value=res.tipoDocumento
            document.getElementById("razon_social_c").value=res.razon_social
            document.getElementById("cliente_email_c").value=res.cliente_email
            document.getElementById("cliente_celular_c").value=res.cliente_celular
            $("#nuevo_cliente").modal("show")
            
        }
    }
}

function btnInactivarCliente(id){
    Swal.fire({
        title: '¿Estás seguro de inactivar el cliente?',
        text: "El cliente no se eliminará de forma permanente solo cambiara el estado a inactivo",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Confirmar',
        cancelButtonText: 'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            const url= base_url+"Clientes/inactivar/"+id
            const http= new XMLHttpRequest()
            http.open("GET",url,true)
            http.send()
            http.onreadystatechange=function(){
                if(this.readyState == 4 && this.status==200){
                    const res = JSON.parse(this.responseText)
                    if(res=="ok"){
                        Swal.fire(
                            'Mensaje!',
                            'Cliente inactivado con éxito',
                            'success',
                           
                          )
                        tblClientes.ajax.reload()
                    }else{
                        Swal.fire(
                            'Mensaje!',
                            res,
                            'error'
                          )
                    }
                }                
            }
            
        }
      })
}

function btnReactivarCliente(id){
    Swal.fire({
        title: '¿Estás seguro de activar al cliente?',
        text: '',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Confirmar',
        cancelButtonText: 'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            const url= base_url+"Clientes/activar/"+id
            const http= new XMLHttpRequest()
            http.open("GET",url,true)
            http.send()
            http.onreadystatechange=function(){
                if(this.readyState == 4 && this.status==200){
                    const res = JSON.parse(this.responseText)
                    if(res=="ok"){
                        Swal.fire(
                            'Mensaje!',
                            'Cliente activado con éxito',
                            'success',
                           
                          )
                        tblClientes.ajax.reload()
                    }else{
                        Swal.fire(
                            'Mensaje!',
                            res,
                            'error'
                          )
                    }
                }                
            }
            
        }
      })
}

//-------------------CATEGORIAS-----------------------//
//--------------------------------------------------//

function btnInactivarCategoria(id){
    Swal.fire({
        title: '¿Estás seguro de inactivar la categoria?',
        text: "La categoria no se eliminará de forma permanente solo cambiara el estado a inactivo",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Confirmar',
        cancelButtonText: 'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            const url= base_url+"ProductosServicios/inactivar/"+id
            const http= new XMLHttpRequest()
            http.open("GET",url,true)
            http.send()
            http.onreadystatechange=function(){
                if(this.readyState == 4 && this.status==200){
                    const res = JSON.parse(this.responseText)
                    if(res=="ok"){
                        Swal.fire(
                            'Mensaje!',
                            'Categoria inactivada con éxito',
                            'success',
                           
                          )
                        tblProductosServicios.ajax.reload()
                    }else{
                        Swal.fire(
                            'Mensaje!',
                            res,
                            'error'
                          )
                    }
                }                
            }
            
        }
      })
}

function btnReactivarCategoria(id){
    Swal.fire({
        title: '¿Estás seguro de activar la categoria?',
        text: '',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Confirmar',
        cancelButtonText: 'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            const url= base_url+"ProductosServicios/activar/"+id
            const http= new XMLHttpRequest()
            http.open("GET",url,true)
            http.send()
            http.onreadystatechange=function(){
                if(this.readyState == 4 && this.status==200){
                    const res = JSON.parse(this.responseText)
                    if(res=="ok"){
                        Swal.fire(
                            'Mensaje!',
                            'Categoria activada con éxito',
                            'success',
                           
                          )
                          tblProductosServicios.ajax.reload()
                    }else{
                        Swal.fire(
                            'Mensaje!',
                            res,
                            'error'
                          )
                    }
                }                
            }
            
        }
      })
}


//-------------------MEDIDAS-----------------------//
//--------------------------------------------------//


function btnInactivarMedida(id){
    Swal.fire({
        title: '¿Estás seguro de inactivar la medida?',
        text: "La medida no se eliminará de forma permanente solo cambiara el estado a inactivo",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Confirmar',
        cancelButtonText: 'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            const url= base_url+"UnidadMedidas/inactivar/"+id
            const http= new XMLHttpRequest()
            http.open("GET",url,true)
            http.send()
            http.onreadystatechange=function(){
                if(this.readyState == 4 && this.status==200){
                    const res = JSON.parse(this.responseText)
                    if(res=="ok"){
                        Swal.fire(
                            'Mensaje!',
                            'Medida inactivada con éxito',
                            'success',
                           
                          )
                        tblUnidadMedidas.ajax.reload()
                    }else{
                        Swal.fire(
                            'Mensaje!',
                            res,
                            'error'
                          )
                    }
                }                
            }
            
        }
      })
}

function btnReactivarMedida(id){
    Swal.fire({
        title: '¿Estás seguro de activar la medida?',
        text: '',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Confirmar',
        cancelButtonText: 'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            const url= base_url+"UnidadMedidas/activar/"+id
            const http= new XMLHttpRequest()
            http.open("GET",url,true)
            http.send()
            http.onreadystatechange=function(){
                if(this.readyState == 4 && this.status==200){
                    const res = JSON.parse(this.responseText)
                    if(res=="ok"){
                        Swal.fire(
                            'Mensaje!',
                            'Medida activada con éxito',
                            'success',
                           
                          )
                        tblUnidadMedidas.ajax.reload()
                    }else{
                        Swal.fire(
                            'Mensaje!',
                            res,
                            'error'
                          )
                    }
                }                
            }
            
        }
      })
}


//-------------------PRODUCTOS-----------------------//
//--------------------------------------------------//
function frmProducto(){
    document.getElementById("title").innerHTML="Nuevo Producto"
    document.getElementById("btnAccion").innerHTML="Registrar"
    document.getElementById("id_producto").value=""
    document.getElementById("frmProducto").reset()
    $("#nuevo_producto").modal("show");
}

function registrarProducto(e){
    e.preventDefault()
    const codigo=document.getElementById("codigo")
    const nombre_producto=document.getElementById("nombre_producto")
    const precio_venta=document.getElementById("precio_venta")
    const id_medida=document.getElementById("id_medida")
    const id_categoria=document.getElementById("id_categoria")
    if(nombre_producto.value=="" || precio_venta.value=="" ){
        Swal.fire({
          icon: 'warning',
          title: 'Alerta',
          text: 'Los campos son obligatorios'

        })
    }else{
        const url = base_url +"Productos/registrar"
        const frm = document.getElementById("frmProducto")
        const http= new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(frm))
        http.onreadystatechange = function(){
            if(this.readyState == 4 && this.status==200){
                const res = JSON.parse(this.responseText)
                if(res=="si"){
                    Swal.fire({
                        icon: 'success',
                        title: 'Producto Registrado con éxito',
                        text: '',
                        showConfirmButton:false,
                        timer: 2000
              
                      })  
                      $("#nuevo_producto").modal("hide")
                      tblProductos.ajax.reload()
                }else if(res=="modificado"){
                    Swal.fire({
                        icon: 'success',
                        title: 'Producto modificado con éxito',
                        text: '',
                        showConfirmButton:false,
                        timer: 2000
              
                      })  
                      $("#nuevo_producto").modal("hide")
                      tblProductos.ajax.reload()
                }
                else{
                    Swal.fire({
                        icon: 'error',
                        title: res,
                        text: ''
              
                      })
                      $("#nuevo_producto").modal("hide")
                }
            }
        }
    }
}

function btnEditarProducto(id){
    document.getElementById("title").innerHTML="Actualizar producto"
    document.getElementById("btnAccion").innerHTML="Modificar"
    const url= base_url+"Productos/editar/"+id
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send()
    http.onreadystatechange = function(){
        if(this.readyState == 4 && this.status==200){
            const res = JSON.parse(this.responseText)
            document.getElementById("id_producto").value=res.id_producto
            document.getElementById("codigo").value=res.codigo
            document.getElementById("nombre_producto").value=res.nombre_producto
            document.getElementById("precio_venta").value=res.precio_venta
            document.getElementById("id_medida").value=res.id_medida
            document.getElementById("id_categoria").value=res.id_categoria
            $("#nuevo_producto").modal("show")
            
        }
    }
}

function btnInactivarProducto(id){
    Swal.fire({
        title: '¿Estás seguro de inactivar al producto?',
        text: "El producto no se eliminará de forma permanente solo cambiara el estado a inactivo",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Confirmar',
        cancelButtonText: 'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            const url= base_url+"Productos/inactivar/"+id
            const http= new XMLHttpRequest()
            http.open("GET",url,true)
            http.send()
            http.onreadystatechange=function(){
                if(this.readyState == 4 && this.status==200){
                    const res = JSON.parse(this.responseText)
                    if(res=="ok"){
                        Swal.fire(
                            'Mensaje!',
                            'Producto inactivado con éxito',
                            'success',
                           
                          )
                        tblProductos.ajax.reload()
                    }else{
                        Swal.fire(
                            'Mensaje!',
                            res,
                            'error'
                          )
                    }
                }                
            }
            
        }
      })
}

function btnReactivarProducto(id){
    Swal.fire({
        title: '¿Estás seguro de activar al producto?',
        text: '',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Confirmar',
        cancelButtonText: 'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            const url= base_url+"Productos/activar/"+id
            const http= new XMLHttpRequest()
            http.open("GET",url,true)
            http.send()
            http.onreadystatechange=function(){
                if(this.readyState == 4 && this.status==200){
                    const res = JSON.parse(this.responseText)
                    if(res=="ok"){
                        Swal.fire(
                            'Mensaje!',
                            'Producto activado con éxito',
                            'success',
                           
                          )
                        tblProductos.ajax.reload()
                    }else{
                        Swal.fire(
                            'Mensaje!',
                            res,
                            'error'
                          )
                    }
                }                
            }
            
        }
      })
}



//-------------------PEDIDOS-------------------------//
//--------------------------------------------------//
function btnImprimirFactura(id){
    $.ajax({
        type: "POST",
        url: base_url + "Pedidos/imprimirFacturaRollo",
        data: {id: id},
        cache: false,
        success: function(data){
            
        }
    })
}




function cufdG(){
    $.ajax({
        type: "POST",
        url: base_url + "Avanzado/generarCufd",
        //cache: false,
        //contentType: false,
        //processData: false,
        //dataType: "json",
        success: function(data){
            //console.log(data)
            location.reload()
        }
    })
}




function registrarEventoSignificativo(e){
    e.preventDefault()
    const descripcion_evento=document.getElementById("descripcion_evento")
    const fechaInicioEvento=document.getElementById("fechaInicioEvento")
    const cafc=document.getElementById("cafc")
    const cufd=document.getElementById("cufd")
    if(descripcion_evento.value=="" || fechaInicioEvento.value=="" || cufd.value=="" ){
        Swal.fire({
          icon: 'warning',
          title: 'Alerta',
          text: 'Los campos son obligatorios'

        })
    }else{
        const url = base_url +"Avanzado/registrarEvento"
        const frm = document.getElementById("frmEvento")
        const formData = new FormData(frm);
        
        const http= new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(frm))
        http.onreadystatechange = function(){
            if(this.readyState == 4 && this.status==200){
                const res = JSON.parse(this.responseText)
                if(res=="si"){
                    Swal.fire({
                        icon: 'success',
                        title: 'Evento Registrado con éxito',
                        text: '',
                        showConfirmButton:false,
                        timer: 2000
              
                      })  
                      //$("#nuevo_producto").modal("hide")
                      var fechaHoraActual = new Date();

                        var year = fechaHoraActual.getFullYear();
                        var month = ("0" + (fechaHoraActual.getMonth() + 1)).slice(-2);
                        var day = ("0" + fechaHoraActual.getDate()).slice(-2);
                        var hours = ("0" + fechaHoraActual.getHours()).slice(-2);
                        var minutes = ("0" + fechaHoraActual.getMinutes()).slice(-2);
                        var seconds = ("0" + fechaHoraActual.getSeconds()).slice(-2);
                        var milliseconds = ("00" + fechaHoraActual.getMilliseconds()).slice(-3);

                        var fechaHoraCadena = year + "-" + month + "-" + day + "T" + hours + ":" + minutes + ":" + seconds + "." + milliseconds;

                      document.getElementById("fechaInicioEvento").value=fechaHoraCadena;

                      tblEventos.ajax.reload()
                }/*else if(res=="modificado"){
                    Swal.fire({
                        icon: 'success',
                        title: 'Producto modificado con éxito',
                        text: '',
                        showConfirmButton:false,
                        timer: 2000
              
                      })  
                      $("#nuevo_producto").modal("hide")
                      tblProductos.ajax.reload()
                }*/
                else{
                    Swal.fire({
                        icon: 'error',
                        title: res,
                        text: ''
              
                      })
                      //$("#nuevo_producto").modal("hide")
                }
            }
        }
    }
}
function btnEliminarEvento(id){
    Swal.fire({
        title: '¿Estás seguro de eliminar el evento?',
        text: "El evento se eliminará de forma permanente",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Confirmar',
        cancelButtonText: 'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            const url= base_url+"Avanzado/eliminarEvento/"+id
            const http= new XMLHttpRequest()
            http.open("GET",url,true)
            http.send()
            http.onreadystatechange=function(){
                if(this.readyState == 4 && this.status==200){
                    const res = JSON.parse(this.responseText)
                    if(res=="ok"){
                        Swal.fire(
                            'Mensaje!',
                            'Evento Eliminado con éxito',
                            'success',
                           
                          )
                        var fechaHoraActual = new Date();

                        var year = fechaHoraActual.getFullYear();
                        var month = ("0" + (fechaHoraActual.getMonth() + 1)).slice(-2);
                        var day = ("0" + fechaHoraActual.getDate()).slice(-2);
                        var hours = ("0" + fechaHoraActual.getHours()).slice(-2);
                        var minutes = ("0" + fechaHoraActual.getMinutes()).slice(-2);
                        var seconds = ("0" + fechaHoraActual.getSeconds()).slice(-2);
                        var milliseconds = ("00" + fechaHoraActual.getMilliseconds()).slice(-3);

                        var fechaHoraCadena = year + "-" + month + "-" + day + "T" + hours + ":" + minutes + ":" + seconds + "." + milliseconds;

                      document.getElementById("fechaInicioEvento").value=fechaHoraCadena;
                        tblEventos.ajax.reload()
                    }else{
                        Swal.fire(
                            'Mensaje!',
                            res,
                            'error'
                          )
                    }
                }                
            }
            
        }
      })
}
function btnFinalizarEvento(id){
    Swal.fire({
        title: '¿Estás seguro de terminar el evento?',
        text: "El evento se registrará al SIAT",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Confirmar',
        cancelButtonText: 'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: "Cargando",
                html: "Reportando evento Significativo...",
                didOpen: () => {
                    Swal.showLoading();
                },
                willClose: () => {
                }
                }).then((result) => {
                
                });


            const url= base_url+"Avanzado/finalizarEvento/"+id
            const http= new XMLHttpRequest()
            http.open("GET",url,true)
            http.send()
            http.onreadystatechange=function(){
                if(this.readyState == 4 && this.status==200){
                    const res = JSON.parse(this.responseText)
                    if(res=="ok"){
                        Swal.fire(
                            'Mensaje!',
                            'Evento Finalizado con éxito',
                            'success',
                           
                          )
                        var fechaHoraActual = new Date();

                        var year = fechaHoraActual.getFullYear();
                        var month = ("0" + (fechaHoraActual.getMonth() + 1)).slice(-2);
                        var day = ("0" + fechaHoraActual.getDate()).slice(-2);
                        var hours = ("0" + fechaHoraActual.getHours()).slice(-2);
                        var minutes = ("0" + fechaHoraActual.getMinutes()).slice(-2);
                        var seconds = ("0" + fechaHoraActual.getSeconds()).slice(-2);
                        var milliseconds = ("00" + fechaHoraActual.getMilliseconds()).slice(-3);

                        var fechaHoraCadena = year + "-" + month + "-" + day + "T" + hours + ":" + minutes + ":" + seconds + "." + milliseconds;

                      document.getElementById("fechaInicioEvento").value=fechaHoraCadena;
                        tblEventos.ajax.reload()

                        window.setTimeout(function(){
                            window.location.href = base_url + "Avanzado/validar_facturas_sc";
                        }, 2000);
                    }else{
                        Swal.fire(
                            'Mensaje!',
                            res,
                            'error'
                          )
                    }
                }                
            }
            
        }
      })
}


function buscarFaturasSC(){
    tblPedidosSC.ajax.url(base_url + 'Avanzado/PedidosSC/'+document.getElementById("id_evento").value)
    tblPedidosSC.ajax.reload()
    
}
function buscarFaturasP(){
    tblPedidosSC.ajax.url(base_url + 'Avanzado/PedidosSCP/'+document.getElementById("codigoRecepcion").value)
    tblPedidosSC.ajax.reload()
    
}



function btnAnularFactura(cuf){
    Swal.fire({
        title: '¿Estás seguro de anular esta factura?',
        text: "Esta acción no será reversible",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Confirmar',
        cancelButtonText: 'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: "Anulando...",
                html: "Puede tardar unos cuantos segundos...",
                didOpen: () => {
                    Swal.showLoading();
                },
                willClose: () => {
                }
                }).then((result) => {
                
                });


            const url= base_url+"Pedidos/anularFactura/"+cuf
            const http= new XMLHttpRequest()
            http.open("GET",url,true)
            http.send()
            http.onreadystatechange=function(){
                if(this.readyState == 4 && this.status==200){
                    const res = JSON.parse(this.responseText)
                    tblPedidos.ajax.reload()
                    if(res){
                        Swal.fire(
                            'Mensaje!',
                            'Factura anulada con éxito',
                            'success',
                           
                          )
                        tblCajas.ajax.reload()
                    }else{
                        Swal.fire(
                            'Mensaje!',
                            res,
                            'Error'
                          )
                    }
                }                
            }
            
        }
      })
}


function btnRevertirAnularFactura(cuf){
    Swal.fire({
        title: '¿Estás seguro de revertir la anulacion de esta factura?',
        text: "No se podrá volver a anular despues de realizar esta acción",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Confirmar',
        cancelButtonText: 'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: "Revirtiendo...",
                html: "Puede tardar unos cuantos segundos...",
                didOpen: () => {
                    Swal.showLoading();
                },
                willClose: () => {
                }
                }).then((result) => {
                
                });


            const url= base_url+"Pedidos/revertirFactura/"+cuf
            const http= new XMLHttpRequest()
            http.open("GET",url,true)
            http.send()
            http.onreadystatechange=function(){
                if(this.readyState == 4 && this.status==200){
                    const res = JSON.parse(this.responseText)
                    tblPedidos.ajax.reload()
                    if(res){
                        Swal.fire(
                            'Mensaje!',
                            'Factura revertida con éxito',
                            'success',
                           
                          )
                        tblCajas.ajax.reload()
                    }else{
                        Swal.fire(
                            'Mensaje!',
                            res,
                            'Error'
                          )
                    }
                }                
            }
            
        }
      })
}

//////////////////////////////////////////////////////////////////////////////////////}
////////////////////////////////////FILTRO///////////////////////////////////////////////


// Función para obtener sugerencias
//console.log(productos);

document.addEventListener('DOMContentLoaded', function() {
    var descripcionEvento = document.getElementById('descripcion_evento');
    if (descripcionEvento) {
        descripcionEvento.addEventListener('change', function() {
            var cafcInput = document.getElementById('cafc');
            var selectedValue = this.value;

            if (selectedValue === '5' || selectedValue === '6' || selectedValue === '7') {
                cafcInput.disabled = false;
            } else {
                cafcInput.disabled = true;
                cafcInput.value=""
            }
        });
    }

    var tipoPago = document.getElementById('tipoPago');
    if (tipoPago) {
        tipoPago.addEventListener('change', function () {
            const cardInput = document.getElementById('cardNumber');
            const giftInput = document.getElementById('montoGiftCard');
            const selectedOption = this.options[this.selectedIndex].text.toLowerCase();
            const errorDiv = document.getElementById('cardNumberError');

            if (selectedOption.includes('tarjeta')) {
                cardInput.disabled = false;
                cardInput.classList.remove('disabled');
            } else {
                cardInput.disabled = true;
                errorDiv.style.display = 'none';
                cardInput.value = null;
                cardInput.classList.add('disabled');
            }

            if (selectedOption.includes('gift')) {
                giftInput.disabled = false;
                giftInput.classList.remove('disabled');
            } else {
                giftInput.disabled = true;
                giftInput.value = "0.00";
                giftInput.classList.add('disabled');
            }
        });

        document.getElementById('cardNumber').addEventListener('input', function (e) {
            const input = e.target;
            const value = input.value.replace(/\D/g, ''); // Remove all non-digit characters
            const formattedValue = value.match(/.{1,4}/g)?.join('-') ?? value;
            
            input.value = formattedValue.slice(0, 19); // Ensure it doesn't exceed the pattern length
        });
        
        document.getElementById('cardNumber').addEventListener('blur', function (e) {
            const input = e.target;
            const regex = /^\d{4}-\d{4}-\d{4}-\d{4}$/;
            const errorDiv = document.getElementById('cardNumberError');
        
            if (!regex.test(input.value)) {
                errorDiv.style.display = 'block';
            } else {
                errorDiv.style.display = 'none';
            }
        });
        
        document.getElementById('paymentForm').addEventListener('submit', function (e) {
            const input = document.getElementById('cardNumber');
            const regex = /^\d{4}-\d{4}-\d{4}-\d{4}$/;
        
            if (!regex.test(input.value) && !input.disabled) {
                e.preventDefault();
                alert('El número de tarjeta no está en el formato correcto.');
            }
        });
    }
});


// JavaScript for input formatting and validation



function buscarCliente(){
    let documentoid = document.getElementById("documentoid").value
    var data_objeto={documentoid: documentoid}
    $.ajax({
        type: "POST",
        url: base_url + "Pedidos/buscarCliente",
        data: data_objeto,
        dataType: "json",
        success: function(data){
            if(data=="error"){
                if(documentoid==0){
                    Swal.fire({
                        icon: 'error',
                        title: 'No puede registrar el nro de documento 0',
                        text: '',
                        timer: 2000
                      })

                }else{
                    Swal.fire({
                        icon: 'error',
                        title: 'El cliente no existe debe registrarlo',
                        text: '',
                        timer: 2000
                      })
                      document.getElementById("title").innerHTML="Registrar Nuevo Cliente"
                      document.getElementById("btnAccion").innerHTML="Registrar"
                      document.getElementById("id_cliente_c").value=""
                      document.getElementById("frmCliente").reset()
                      document.getElementById("documentoid_c").value=documentoid
                      
                      $("#nuevo_cliente").modal("show");
    
                }
            }else{
                if (documentoid==99001){
                    Swal.fire({
                        icon: 'error',
                        title: 'Ingrese los datos del cliente',
                        text: '',
                        timer: 2000
                      })  
                    document.getElementById("title").innerHTML="Ingresar datos del Cliente"
                    document.getElementById("btnAccion").innerHTML="Registrar"
                    document.getElementById("frmCliente").reset()
                    document.getElementById("id_cliente_c").value=data["id_cliente"]
                    document.getElementById("documentoid_c").value=documentoid
                    document.getElementById("tipo_documento_c").value = 5
                    document.getElementById("id_cliente").value = data["id_cliente"]
                    $("#nuevo_cliente").modal("show");    
                }else{
                    document.getElementById("razon_social").value = data["razon_social"]
                    document.getElementById("tipo_documento").value = data["tipoDocumento"]
                    document.getElementById("cliente_email").value = data["cliente_email"]
                    document.getElementById("id_cliente").value = data["id_cliente"]
                    document.getElementById("complementoid").value = data["complementoid"]
                }
            }
        }
    })
}

