<?php
class Clientes extends Controller
{
    public function __construct()
    {   
        session_start();
        parent::__construct();
    }
    public function index(){
        $this->views->getView($this,"index");
    }

    public function listar(){
        $data=$this->model->getClientes();
        for($i=0;$i<count($data);$i++){
            if($data[$i]['cliente_estado']==1){
                $data[$i]['cliente_estado']='<span class="badge bg-success">Activo</span>';
                $data[$i]['acciones']='<div><button class="btn btn-primary" type="button" onclick="btnEditarCliente('.$data[$i]['id_cliente'].')"><i class="fas fa-edit"></i></button>
            <button class="btn btn-danger" type="button" onclick="btnInactivarCliente('.$data[$i]['id_cliente'].')""><i class="fas fa-trash"></i></button>
            </div>';
            }else{
                $data[$i]['cliente_estado']='<span class="badge bg-danger">Inactivo</span>';
                $data[$i]['acciones']='<div><button class="btn btn-success" type="button" onclick="btnReactivarCliente('.$data[$i]['id_cliente'].')""><i class="fas fa-plus-circle"></i></button>
            </div>';
            }
            

        }
        echo json_encode($data);
        die();
    }

    public function registrar(){
        $id_cliente=$_POST['id_cliente_c'];
        $documentoid = $_POST['documentoid_c'];
        $complementoid = $_POST['complementoid_c'];
        $tipoDocumento = $_POST['tipo_documento_c'];
        $razon_social = strtoupper($_POST['razon_social_c']);
        $cliente_email = $_POST['cliente_email_c'];
        $cliente_celular = $_POST['cliente_celular_c'];
        

        if(empty($documentoid) || empty($razon_social) || empty($tipoDocumento)){
            $msg= "Los campos es obligatorio";
        }else{
            if($id_cliente==""){
                if($tipoDocumento==5 || $tipoDocumento==1){
                    if(is_numeric($documentoid)){
                        $data=$this->model->registrarCliente($tipoDocumento,$documentoid,$complementoid,$razon_social,$cliente_email,$cliente_celular);
                        if($data=="ok"){
                            $msg="si";
                        }else{
                            $msg="Error al registrar cliente";
                        }
                    }else{
                        $msg="Error al registrar cliente";
                    }
                }else{
                    $data=$this->model->registrarCliente($tipoDocumento,$documentoid,$complementoid,$razon_social,$cliente_email,$cliente_celular);
                    if($data=="ok"){
                        $msg="si";
                    }else{
                        $msg="Error al registrar cliente";
                    }
                }
            }else{
                if($tipoDocumento==5 || $tipoDocumento==1){
                    if(is_numeric($documentoid)){
                        $data=$this->model->modificarCliente($tipoDocumento,$documentoid,$complementoid,$razon_social,$cliente_email,$cliente_celular,$id_cliente);
                        if($data=="ok"){
                            $msg="si";
                        }else{
                            $msg="Error al registrar cliente";
                        }
                    }else{
                        $msg="Error al registrar cliente";
                    }
                }else{
                    $data=$this->model->modificarCliente($tipoDocumento,$documentoid,$complementoid,$razon_social,$cliente_email,$cliente_celular,$id_cliente);
                    if($data=="modificado"){
                        $msg="modificado";
                    }else{
                        $msg="Error al modificar cliente";
                    }                    
                }

            }
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
        
    }
    public function editar(int $id){
        $data = $this->model->editarCliente($id);
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function inactivar(int $id){
        $data = $this->model->accion(0,$id);
        if($data==1){
            $msg="ok";
        }else{
            $msg="Error al inactivar la cliente";
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    
    public function activar(int $id){
        $data = $this->model->accion(1,$id);
        if($data==1){
            $msg="ok";
        }else{
            $msg="Error al activar la cliente";
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    

}
?>
