<?php
class ProductosServicios extends Controller
{
    public function __construct()
    {   
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }
        
        parent::__construct();
    }
    public function index(){
        $this->views->getView($this,"index");
    }

    public function listar(){
        $data=$this->model->getProductosServicios();
        for($i=0;$i<count($data);$i++){
            if($data[$i]['estado']==1){
                $data[$i]['estado']='<span class="badge bg-success">Activo</span>';
                $data[$i]['acciones']='<div><button class="btn btn-danger" type="buton" onclick="btnInactivarCategoria('.$data[$i]['id'].')""><i class="fas fa-trash"></i></button>
            </div>';
            }else{
                $data[$i]['estado']='<span class="badge bg-danger">Inactivo</span>';
                $data[$i]['acciones']='<div><button class="btn btn-success" type="button" onclick="btnReactivarCategoria('.$data[$i]['id'].')""><i class="fas fa-plus-circle"></i></button>
            </div>';
            }
            

        }
        echo json_encode($data);
        die();
    }

    

    public function inactivar(int $id){
        $data = $this->model->accion(0,$id);
        if($data==1){
            $msg="ok";
        }else{
            $msg="Error al inactivar la categoria";
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    
    public function activar(int $id){
        $data = $this->model->accion(1,$id);
        if($data==1){
            $msg="ok";
        }else{
            $msg="Error al activar la categoria";
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    

}
?>
