<?php
class AvanzadoModel extends Query{
    public function __construct()
    {
        parent::__construct();
    }
    private $codigoPuntoVenta;

    private $cufd,$cafc,$fechaInicioEvento,$descripcion_evento,$id_evento,$fechaFinEvento,$codigoRecepcion;

    public function registrarEvento(string $cufd,string $cafc,int $descripcion_evento,string $fechaInicioEvento,int $codigoPuntoVenta)
    {
        $this->cufd=$cufd;
        $this->cafc=$cafc;
        $this->fechaInicioEvento=$fechaInicioEvento;
        $this->descripcion_evento=$descripcion_evento;
        $this->codigoPuntoVenta=$codigoPuntoVenta;
        
        $sql= "insert into eventosignificativo (cufd,cafc,descripcion_evento,fechaInicioEvento,codigoRecepcion,codigoPuntoVenta) values (?,?,?,?,0,?)";
        $datos= array( $this->cufd,$this->cafc,$this->descripcion_evento,$this->fechaInicioEvento,$this->codigoPuntoVenta);
        $data=$this->save($sql,$datos);
        if($data==1){
            $res="ok";
        }else{
            $res="error";
        }
        return $res;

    }
    public function getEventos(){
        $sql = "select * from eventosignificativo where codigoPuntoVenta=0 ORDER BY id_evento DESC";
        $data = $this->selectAll($sql);
        return $data;
    }
    public function obtenerEvento(int $id){
        $sql="select * from eventosignificativo where id_evento='$id'";
        $data=$this->select($sql);
        return $data;
    }
    public function eliminarEvento(int $id){
        $this->id_evento = $id;
        $sql = "delete from eventosignificativo where id_evento=?";
        $datos= array($this->id_evento);
        $data=$this->save($sql,$datos);
        return $data;
    }
    public function finalizarEvento(int $id,string $fechaFinEvento,int $codigoRecepcion){
        $this->fechaFinEvento = $fechaFinEvento;
        $this->codigoRecepcion=$codigoRecepcion;
        $this->id_evento = $id;
        $sql = "update eventosignificativo set fechaFinEvento=?,codigoRecepcion=? where id_evento=?";
        $datos= array($this->fechaFinEvento,$this->codigoRecepcion,$this->id_evento);
        $data=$this->save($sql,$datos);
        return $data;
    }
    public function getEventosFinalizados($idPuntoVenta){
        $sql = "select e.cufd as cufd, e.descripcion_evento as descripcion_evento, e.id_evento as id_evento, e.codigoRecepcion as codigoRecepcion 
                from eventosignificativo e 
                join facturas f on f.cufd=e.cufd 
                where e.codigoRecepcion != 0 and e.idPuntoVenta=".$idPuntoVenta." and f.factura_estado=2 
                group by (e.id_evento) 
                order by id_evento desc";
        $data = $this->selectAll($sql);
        return $data;
    }
    public function getPedidosSC($cufd,$ini,$fin,$est){
        $sql="select f.*, c.razon_social, c.documentoid, c.cliente_email  
        from facturas f 
        inner join clientes c on c.id_cliente=f.id_cliente 
        where f.cufd='". $cufd ."' and f.factura_estado=".$est." and  f.fechaEmision > STR_TO_DATE('".$ini."', '%Y-%m-%dT%H:%i:%s.%f')
        and  f.fechaEmision < STR_TO_DATE('".$fin."', '%Y-%m-%dT%H:%i:%s.%f')
        order by f.id_factura desc";
        //print_r($sql);
        $data=$this->selectAll($sql);
        return $data;
    }
    public function getPedidosP($codigoRecepcion,$est){
        $sql="select f.*, c.razon_social, c.documentoid, c.cliente_email  
        from facturas f 
        inner join clientes c on c.id_cliente=f.id_cliente 
        where f.codigoRecepcion='". $codigoRecepcion ."' and f.factura_estado=".$est."
        order by f.id_factura desc";
        $data=$this->selectAll($sql);
        return $data;
    }
    public function contarPedidosSC($cufd,$ini,$fin){
        $sql="select count(*) as cantidad  
        from facturas f 
        inner join clientes c on c.id_cliente=f.id_cliente 
        where f.cufd='". $cufd ."' and f.factura_estado=2 and  f.fechaEmision > STR_TO_DATE('".$ini."', '%Y-%m-%dT%H:%i:%s.%f')
        and  f.fechaEmision < STR_TO_DATE('".$fin."', '%Y-%m-%dT%H:%i:%s.%f')
        order by f.id_factura desc";
        $data=$this->select($sql);
        return $data;
    }
    public function insertValidacion($codigoRecepcion, $codigoEstado, $codigoDescripcion, $id_evento)
    {
        $sql= "insert into validaciones (codigoRecepcion, codigoEstado, codigoDescripcion, id_evento) values (?,?,?,?)";
        $datos= array( $codigoRecepcion, $codigoEstado, $codigoDescripcion, $id_evento);
        $data=$this->save($sql,$datos);
        if($data==1){
            $res="ok";
        }else{
            $res="error";
        }
        return $res;

    }
    public function validarFacturas($cufd,$ini,$fin,$codigoRecepcion){
        
        $sql="update facturas
        set factura_estado = 3, codigoRecepcion='".$codigoRecepcion."'   
        where cufd='". $cufd ."' and factura_estado=2 and  fechaEmision > STR_TO_DATE('".$ini."', '%Y-%m-%dT%H:%i:%s.%f')
        and  fechaEmision < STR_TO_DATE('".$fin."', '%Y-%m-%dT%H:%i:%s.%f')";
        $data=$this->select($sql);
        $datos= array();
        $data=$this->save($sql,$datos);
        if($data==1){
            $res="ok";
        }else{
            $res="error";
        }
        return $res;
    }
    public function getValidacionesP(){
        $sql = "select * from validaciones v
                join facturas f on v.codigoRecepcion=f.codigoRecepcion
                where v.codigoDescripcion='PENDIENTE'
                order by v.id_validacion desc";//group by v.codigoRecepcion
                
        $data = $this->selectAll($sql);
        return $data;
    }

    public function updateValidacion($codigoRecepcion, $codigoEstado, $codigoDescripcion)
    {
        $sql= "update validaciones set codigoEstado=?, codigoDescripcion=? where codigoRecepcion=?";
        $datos= array( $codigoEstado, $codigoDescripcion, $codigoRecepcion);
        $data=$this->save($sql,$datos);
        if($data==1){
            $res="ok";
        }else{
            $res="error";
        }
        return $res;

    }
    public function updateFacturas($codigoRecepcion,$estado){
        
        $sql="update facturas
        set factura_estado = ".$estado." where codigoRecepcion='".$codigoRecepcion."'";
        $data=$this->select($sql);
        $datos= array();
        $data=$this->save($sql,$datos);
        if($data==1){
            $res="ok";
        }else{
            $res="error";
        }
        return $res;
    }
}
?>