<?php
class SiatCodigos{
    
    var $dir="FacturacionCodigos?wsdl";
    public function __construct()
    {
        
    }
    
    public function verificarComunicacion($datosgenerales){
        $wsdl=$datosgenerales['ambiente']['enlace'].$this->dir;
        $options = array(
            'http' => array(
                'header' => "apikey: TokenApi ".$datosgenerales['empresa']['token'],
                'timeout' => 5
            )
        );

        $context = stream_context_create($options);
        try{
            $client = new \SoapClient($wsdl,[
                'stream_context' => $context,
                'cache_wsdl' => WSDL_CACHE_NONE,
                'compression' => SOAP_COMPRESSION_ACCEPT | SOAP_COMPRESSION_GZIP | SOAP_COMPRESSION_DEFLATE,
            ]);
            $result = $client->verificarComunicacion();
        }catch(SoapFault $fault){
            $result = false;
        }
        return $result;
    }

    public function registroPuntoVenta($datosgenerales,$puntoventa){
        $wsdl = $datosgenerales['ambiente']['enlace'].$datosgenerales['wsdl']['enlace'];
        $codigoAmbiente = $datosgenerales['sistema']['ambiente'];
        $codigoModalidad = $datosgenerales['sistema']['modalidad'];
        $codigoSistema = $datosgenerales['sistema']['codigo'];
        $codigoSucursal = $puntoventa['id_sucursal'];
        $codigoTipoPuntoVenta=$puntoventa['tipopuntoventa'];
        $cuis = $datosgenerales['puntoventa']['cuis'];
        $descripcion=$puntoventa['descripcion'];
        $nit = $datosgenerales['empresa']['nit'];
        $nombrePuntoVenta=$puntoventa['descripcion'];
        $params = array("SolicitudRegistroPuntoVenta" =>
        array(
            "codigoAmbiente" => $codigoAmbiente,
            "codigoModalidad" => $codigoModalidad,
            "codigoSistema" => $codigoSistema,
            "codigoSucursal" => $codigoSucursal,
            "codigoTipoPuntoVenta" => $codigoTipoPuntoVenta,
            "cuis" => $cuis,
            "descripcion" => $descripcion,
            "nit" => $nit,
            "nombrePuntoVenta" => $nombrePuntoVenta,
        ));

        $options = array(
            'http' => array(
                'header' => "apikey: TokenApi ".$datosgenerales['empresa']['token'],
                'timeout' => 5
            )
        );

        $context = stream_context_create($options);

        try {
            $client = new \SoapClient($wsdl,[
                'stream_context' => $context,
                'cache_wsdl' => WSDL_CACHE_NONE,
                'compression' => SOAP_COMPRESSION_ACCEPT | SOAP_COMPRESSION_GZIP | SOAP_COMPRESSION_DEFLATE,
            ]);
            $result = $client->registroEventoSignificativo($params);
        } catch (SoapFault $fault) {
            $result = false;
        }
        return $result;
    }

    public function cuis($datosgenerales,$puntoventa){
        $wsdl=$datosgenerales['ambiente']['enlace'].$this->dir;

        $codigoAmbiente=$datosgenerales['sistema']['ambiente'];
        $codigoModalidad=$datosgenerales['sistema']['modalidad'];
        $codigoPuntoVenta=$puntoventa['codigoPuntoVenta'];
        $codigoSistema=$datosgenerales['sistema']['codigo'];
        $codigoSucursal=$puntoventa['codigoSucursal'];
        $nit=$datosgenerales['empresa']['nit'];
        $params=array("SolicitudCuis"=>
        array(
            "codigoAmbiente" => $codigoAmbiente,
            "codigoModalidad" => $codigoModalidad,
            "codigoPuntoVenta" => $codigoPuntoVenta,
            "codigoSistema" => $codigoSistema,
            "codigoSucursal" => $codigoSucursal,
            "nit" => $nit
        ));
        $options = array(
            'http' => array(
                'header' => "apikey: TokenApi ".$datosgenerales['empresa']['token'],
                'timeout' => 5
            )
        );

        $context = stream_context_create($options);
        try{
            $client = new \SoapClient($wsdl,[
                'stream_context' => $context,
                'cache_wsdl' => WSDL_CACHE_NONE,
                'compression' => SOAP_COMPRESSION_ACCEPT | SOAP_COMPRESSION_GZIP | SOAP_COMPRESSION_DEFLATE,
            ]);
            $result = $client->cuis($params);
        }catch(SoapFault $fault){
            $result = false;
        }
        return $result;
    }

    
    public function cufd($datosgenerales,$puntoventa)    {
        $wsdl=$datosgenerales['ambiente']['enlace'].$this->dir;

        $codigoAmbiente=$datosgenerales['sistema']['ambiente'];
        $codigoModalidad=$datosgenerales['sistema']['modalidad'];
        $codigoPuntoVenta=$puntoventa['codigoPuntoVenta'];
        $codigoSistema=$datosgenerales['sistema']['codigo'];
        $codigoSucursal=$puntoventa['codigoSucursal'];
        $cuis = $puntoventa['cuis'];
        $nit=$datosgenerales['empresa']['nit'];
        
        $params = array("SolicitudCufd" =>
        array(
            "codigoAmbiente" => $codigoAmbiente,
            "codigoModalidad" => $codigoModalidad,
            "codigoPuntoVenta" => $codigoPuntoVenta,
            "codigoSistema" => $codigoSistema,
            "codigoSucursal" => $codigoSucursal,
            "cuis" => $cuis,
            "nit" => $nit
        ));

        $options = array(
            'http' => array(
                'header' => "apikey: TokenApi ".$datosgenerales['empresa']['token'],
                'timeout' => 5
            )
        );

        $context = stream_context_create($options);

        try {
            $client = new \SoapClient($wsdl,[
                'stream_context' => $context,
                'cache_wsdl' => WSDL_CACHE_NONE,
                'compression' => SOAP_COMPRESSION_ACCEPT | SOAP_COMPRESSION_GZIP | SOAP_COMPRESSION_DEFLATE,
            ]);
            $result = $client->cufd($params);
        } catch (SoapFault $fault) {
            $result = false;
        }
        return $result;
    }

    

   

}
?>