<?php
require 'phpmailer/src/Exception.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/SMTP.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use RobRichards\XMLSecLibs\XMLSecurityDSig;
use RobRichards\XMLSecLibs\XMLSecurityKey;

class Pedidos extends Controller{
    public function __construct()
    {
        session_start();
        $this->loadModel('EnlacesModel');
        $this->loadModel('SistemaModel');
        $this->loadModel('EmpresaModel');
        $this->loadModel('AmbienteModel');
        $this->loadModel('PuntoVentaModel');
        $this->loadModel('SucursalesModel');
        $this->loadModel('UsuariosModel');
        $this->loadModel('LeyendasModel');
        $this->loadModel('PagoModel');
        $this->loadModel('ActividadesModel');
        $this->loadModel('EventosModel');
        parent::__construct();
    }
    public function index(){
        $metodoPagoModel= new PagoModel();
        $pagos=$metodoPagoModel->getPagos();
        $data['pagos']=$pagos;
        $this->views->getView($this,"index",$data);
    }
    private function loadModel($model) {
        $modelPath = __DIR__ . '/../Models/' . $model . '.php';
        if (file_exists($modelPath)) {
            require_once $modelPath;
        } else {
            throw new Exception("Model file not found: " . $modelPath);
        }
    }

    public function listar()
    {
        $usuarioModel=new UsuariosModel();
        $usuario=$usuarioModel->editarUsuario($_SESSION['id_usuario']);
        $sistemaModel=new SistemaModel();
        $ambienteModel= new AmbienteModel();
        $empresaModel= new EmpresaModel();
        $sistema=$sistemaModel->getSistema(1);
        $empresa=$empresaModel->getEmpresa(1);
        $ambiente=$ambienteModel->getAmbiente($sistema['ambiente']);
        $pv=$usuario['id_puntoventa'];
        $data = $this->model->getPedidos($pv);
        
        for ($i = 0; $i < count($data); $i++) {
            $numeroFactura=$data[$i]['numeroFactura'];
            $fecha=new DateTime($data[$i]['fechaEmision']);
            if ($data[$i]['factura_estado'] == 1) {
                $data[$i]['fechaEmision'] = '<span class="bg-success text-light">'.$data[$i]['fechaEmision'].'</span>';
                $data[$i]['acciones'] = '<div>
                
                <a href='. base_url . $data[$i]['raiz'] . 'factura.pdf class="btn btn-primary" type="button" target="_blank"><i class="fas fa-print"></i></i></a>
                <a href="'.$ambiente['qr'].'consulta/QR?nit='.$empresa['nit'].'&cuf=' . $data[$i]['cuf'] . '&numero=' . $numeroFactura . '&t=2" class="btn btn-success" target="_blank"><i class="fas fa-file-signature"></i></a>';
                $mes=$fecha->format('m');
                date_default_timezone_set('America/La_Paz');
                $mesActual = date('m');
                if($mes==$mesActual && $data[$i]['anulacion']==0){
                    $data[$i]['acciones']=$data[$i]['acciones'].'<button class="btn btn-danger" type="button" onclick="btnAnularFactura('."'" . $data[$i]['cuf'] ."'" . ')"><i class="fas fa-ban"></i></button>
                    </div>';
    
                }else{
                    $data[$i]['acciones']=$data[$i]['acciones'].'</div>';
                }
            } else if ($data[$i]['factura_estado'] == 0){
                $data[$i]['fechaEmision'] = '<span class="bg-danger text-light">'.$data[$i]['fechaEmision'].'</span>';
                $data[$i]['acciones'] = '<div>
                <a href="'.$ambiente['qr'].'consulta/QR?nit='.$empresa['nit'].'&cuf=' . $data[$i]['cuf'] . '&numero=' . $numeroFactura . '&t=2" class="btn btn-success" target="_blank"><i class="fas fa-file-signature"></i></a>
                <a href="'. base_url . $data[$i]['raiz'] . 'factura.pdf" class="btn btn-primary" type="button" target="_blank"><i class="fas fa-print"></i></i></a>
                <button class="btn btn-warning" type="button" onclick="btnRevertirAnularFactura('."'" . $data[$i]['cuf'] ."'" . ')"><i class="fas fa-plus"></i></button>
                </div>';

            }else if ($data[$i]['factura_estado'] == 3){
                $data[$i]['fechaEmision'] = '<span class="bg-warning text-light">'.$data[$i]['fechaEmision'].'</span>';
                $data[$i]['acciones'] = '<div>
                <a href='.$ambiente['qr'].'consulta/QR?nit='.$empresa['nit'].'&cuf=' . $data[$i]['cuf'] . '&numero=' . $numeroFactura . '&t=2" class="btn btn-success" target="_blank"><i class="fas fa-file-signature"></i></a>
                <a href='. base_url . $data[$i]['raiz'] . 'factura.pdf class="btn btn-primary" type="button" target="_blank"><i class="fas fa-print"></i></i></a>
                </div>';
            }else {
                $data[$i]['fechaEmision'] = '<span class="bg-secondary text-light">'.$data[$i]['fechaEmision'].'</span>';
                $data[$i]['acciones'] = '<div>
                <a href='. base_url . $data[$i]['raiz'] . 'factura.pdf class="btn btn-success" target="_blank"><i class="fas fa-print"></i></i></a>
                </div>';
            }
            
        }
        echo json_encode($data);
        die();
    }

    public function nuevo_pedido(){
        $actividadesModel=new ActividadesModel();
        $usuarioModel=new UsuariosModel();
        $puntoVentaModel= new PuntoVentaModel();
        $metodoPagoModel= new PagoModel();
        $usuario=$usuarioModel->editarUsuario($_SESSION['id_usuario']);
        $pv=$puntoVentaModel->editarPuntoVenta($usuario['id_puntoventa']);
        $dt=$this->model->getNroPedidos($pv['id_puntoVenta']);
        $pagos=$metodoPagoModel->getPagos();
        $data['numero']=$dt['cantidad']+1;
        $data['actividades']=$actividadesModel->getActividades();
        $data['pagos']=$pagos;
        $this->views->getView($this,"nuevo_pedido",$data);
    }

    public function mostrar_productos(){
        $codigo = $_POST['codigo'];
        $actividad = $_POST['actividad'];
        $productos=$this->model->getProductos($codigo,$actividad);

        $html="";
        foreach($productos as $prod){
            $html.='<li onclick="obtenerProd(\''.$prod['codigo'].'\')">'.$prod['codigo']." - ".$prod['nombre_producto'] ."</li>";
            
        }
        
        echo json_encode($html,  JSON_UNESCAPED_UNICODE);
    }

    public function mostrar_productos_n(){
        $nombre_producto = $_POST['nombre_producto'];
        $actividad = $_POST['actividad'];
        $productos=$this->model->getProductosN($nombre_producto,$actividad);

        $html="";
        foreach($productos as $prod){
            $html.='<li onclick="obtenerProdN(\''.$prod['codigo'].'\')">'.$prod['codigo']." - ".$prod['nombre_producto'] ."</li>";
            
        }
        
        echo json_encode($html,  JSON_UNESCAPED_UNICODE);
    }

    public function leyendas() {
        $actividad = $_POST['actividad'];
        $leyendasModel = new LeyendasModel();
        $leyend = $leyendasModel->getLeyendasAct($actividad);
        $leyendas = [];
        
        foreach ($leyend as $ley) {
            $leyendas[] = $ley['descripcionLeyenda'];
        }
    
        header('Content-Type: application/json');
        echo json_encode($leyendas);
    }
    

    public function nuevo_pedido_sin_conexion(){
        $eventosModel=new EventosModel();
        $actividadesModel=new ActividadesModel();
        $usuarioModel=new UsuariosModel();
        $puntoVentaModel= new PuntoVentaModel();
        $metodoPagoModel= new PagoModel();

        $usuario=$usuarioModel->editarUsuario($_SESSION['id_usuario']);
        $pv=$puntoVentaModel->editarPuntoVenta($usuario['id_puntoventa']);
        $dt=$this->model->getNroPedidos($pv['id_puntoVenta']);
        $pagos=$metodoPagoModel->getPagos();
        $data['numero']=$dt['cantidad']+1;
        $data['actividades']=$actividadesModel->getActividades();
        $data['pagos']=$pagos;
        $evento= $eventosModel->lastEvento($pv['id_puntoVenta']);
        if($evento['fechaFinEvento']==null){
            $data['evento']=true;
            $data['cufd']=$evento['cufd'];
            $data['descripcion_evento']=$evento['descripcion_evento'];
            $data['cafc']=$evento['cafc'];
        }else{
            $data['evento']=false;
        }
        $this->views->getView($this,"nuevo_pedido_sc",$data);
    }

    public function buscarCliente(){
        $documentoid = $_POST['documentoid'];
        $data = $this->model->buscarCliente($documentoid);
        if($data){
            
                echo json_encode($data);

            
        }else{
            $msg="error";
            echo json_encode($msg);
        }
    }

    public function buscarProducto(){
        $codigo = $_POST['codigo'];
        $data = $this->model->buscarProducto($codigo);
        if($data){
            echo json_encode($data);
        }else{
            $msg="error";
            echo json_encode($msg);
        }
    }

    public function verificarComunicacion(){
        require "Siat.php";
        $siat = new Siat();
        $res = $siat->verificarComunicacion();
        if($res->RespuestaComunicacion->transaccion==true){
            if(!isset($_SESSION['scuis'])){
                $rescuis = $siat->cuis();
                if($rescuis->RespuestaCuis->mensajesList->codigo==980){
                    $_SESSION['scuis']=$rescuis->RespuestaCuis->codigo;
                    $_SESSION['sfechavigenciaCuis']=$rescuis->RespuestaCuis->codigo;
                    
                }else{
                    echo "Error al solicitar codigo CUIS";
                }
            }
            echo json_encode($res);
        }else{
            echo "Fallo la comunicación";
        }
    }

    public function cuis(){
        require "Siat.php";
        $siat = new Siat();
        $res = $siat->cuis();
        if($res->RespuestaCuis->mensajesList->codigo==980){
            $_SESSION['scuis']=$res->RespuestaCuis->codigo;
            $_SESSION['sfechavigenciaCuis']=$res->RespuestaCuis->fechaVigencia;
            
        }else{
            echo "Error al solicitar codigo CUIS";
        }
    }

    public function cufd()
    {
        $msgCufd="";

        if (!isset($_SESSION['scufd'])) {
            require "Avanzado.php";
            $avanzado= new Avanzado();
            $avanzado->generarCufd();
        } else {
            date_default_timezone_set('America/La_Paz');
            $fechaVigente = substr($_SESSION['svigenciaCufd'], 0, 16);
            $fechaVigente = str_replace("T", " ", $fechaVigente);
            if ($fechaVigente < date("Y-m-d H:i")) {
                require "Avanzado.php";
                $avanzado= new Avanzado();
                $avanzado->generarCufd();
            } else {
                $rescufd['transaccion'] = true;
                $rescufd['codigo'] = $_SESSION['scufd'];
                $rescufd['fechaVigencia'] = $_SESSION['svigenciaCufd'];
            }
        }
        echo json_encode($rescufd);
    }

    

    public function generaFactura()
    {
        require "SiatSincronizacion.php";
        $sistemaModel= new SistemaModel();
        $empresaModel=new EmpresaModel();
        $usuarioModel=new UsuariosModel();
        $puntoVentaModel= new PuntoVentaModel();
        $ambienteModel= new AmbienteModel();
        $sucursalModel=new SucursalesModel();
        $usuario=$usuarioModel->editarUsuario($_SESSION['id_usuario']);
        $sistema=$sistemaModel->getSistema(1);
        $pv=$puntoVentaModel->editarPuntoVenta($usuario['id_puntoventa']);
        $empresa=$empresaModel->getEmpresa(1);
        $ambiente=$ambienteModel->getAmbiente($sistema['ambiente']);
        $suc=$sucursalModel->editarSucursal($pv['codigoSucursal']);
        $datosgenerales['sistema']=$sistema;
        $datosgenerales['empresa']=$empresa;
        $datosgenerales['puntoventa']=$pv;
        $datosgenerales['ambiente']=$ambiente;
        $datosgenerales['sucursal']=$suc;
        
        $datos = $_POST['factura'];
        $id_cliente = $_POST['id_cliente'];
        $cliente_email = $_POST['cliente_email'];
        $datos['factura'][0]['cabecera']['codigoSucursal']=$pv['codigoSucursal'];
        $datos['factura'][0]['cabecera']['codigoPuntoVenta']=$pv['codigoPuntoVenta'];
        $datos['factura'][0]['cabecera']['nitEmisor']=$empresa['nit'];
        $datos['factura'][0]['cabecera']['razonSocialEmisor']=$empresa['razonsocial'];
        $datos['factura'][0]['cabecera']['municipio']=$suc['ciudad'];
        $datos['factura'][0]['cabecera']['telefono']=$suc['telefono'];
        $datos['factura'][0]['cabecera']['direccion']=$suc['direccion'];
        $siatSincro= new SiatSincronizacion();
        $respfechaEmision= $siatSincro->sincronizarFechaHora($datosgenerales);
        $datos['factura'][0]['cabecera']['fechaEmision']=$respfechaEmision->RespuestaFechaHora->fechaHora;
        $valores = $datos['factura'][0]['cabecera'];
        $nitEmisor = str_pad($valores['nitEmisor'], 13, "0", STR_PAD_LEFT);
        $fechaEmision = $valores['fechaEmision'];
        $fechat = str_replace("T", "", $fechaEmision);
        $fechat = str_replace("-", "", $fechat);
        $fechat = str_replace(":", "", $fechat);
        $fechat = str_replace(".", "", $fechat);
        $sucursal = str_pad($pv['codigoSucursal'], 4, "0", STR_PAD_LEFT);
        $modalidad = $sistema['modalidad'];
        $tipoEmision = 1;
        $tipoFactura = 1;
        $tipoDocSector = str_pad(1, 2, "0", STR_PAD_LEFT);
        $numeroFactura = str_pad($valores['numeroFactura'], 10, "0", STR_PAD_LEFT);
        $puntoVenta = str_pad($pv['codigoPuntoVenta'], 4, "0", STR_PAD_LEFT);
        $cadena = $nitEmisor . $fechat . $sucursal . $modalidad . $tipoEmision . $tipoFactura . $tipoDocSector . $numeroFactura . $puntoVenta;
        $mod11= $this->model->calculaDigitoMod11($cadena);
        $cadena=$cadena.$mod11;        
        $base16= $this->model->baseConvert($cadena,10,16);
        $titulo=$numeroFactura."_".$fechat."_".$valores['numeroDocumento']."_".$valores['nombreRazonSocial'];
        $cuf = $base16.$_SESSION['scodigoControl'];
        $datos['factura'][0]['cabecera']['cuf'] = $cuf;
        require "Siat.php";
        if($datos['factura'][0]['cabecera']['codigoTipoDocumentoIdentidad']==5){
            $siat1 = new Siat();
            $resNit = $siat1->verificarNit($valores['numeroDocumento']);
            $valor=$resNit->RespuestaVerificarNit->mensajesList->codigo;
            if($valor!="986"){
                $datos['factura'][0]['cabecera']['codigoExcepcion'] = 1;
            }

        }
        
        $temporal = $datos['factura'];
        $xml_temporal = new SimpleXMLElement("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><facturaElectronicaCompraVenta xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"
        xsi:noNamespaceSchemaLocation=\"facturaElectronicaCompraVenta.xsd\"></facturaElectronicaCompraVenta>");
        $this->formato_xml($temporal, $xml_temporal);
        $titulo=str_replace('.', '', $titulo);
        $titulo=str_replace(' ', '_', $titulo);
        $directorio = "docs/".$titulo;
        mkdir($directorio, 0777, true);
        $xml_temporal->asXML("docs/".$titulo."/".$titulo.".xml");
        $archivoXml = "";
        $fp = fopen("docs/".$titulo."/".$titulo.".xml", "r");
        while (!feof($fp)) {
            $linea = fgets($fp);
            $archivoXml .= $linea;
        }
        fclose($fp);
        $this->firmaDigital("docs/".$titulo."/",$titulo,".xml");
        $archivo = "";
        $gzdata = gzencode(file_get_contents("docs/".$titulo."/".$titulo."_firmada.xml"), 9);
        $fp = fopen("docs/".$titulo."/".$titulo."_firmada.xml.zip", "w");
        fwrite($fp, $gzdata);
        fclose($fp);
        $archivo = $gzdata;
        $hashArchivo = hash("sha256", file_get_contents("docs/".$titulo."/".$titulo."_firmada.xml"));
        $numeroFactura = $valores['numeroFactura'];
        $codigoMetodoPago = 1;
        $montoTotal = $valores['montoTotal'];
        $montoTotalSujetoIva = $valores['montoTotalSujetoIva'];
        $descuentoAdicional = $valores['descuentoAdicional'];
        $productos = file_get_contents("docs/".$titulo."/".$titulo."_firmada.xml");
        require "SiatFacturacion.php";
        $siat = new SiatFacturacion();
        $resFactura = $siat->recepcionFactura($datosgenerales,$archivo,$fechaEmision,$hashArchivo);
        /////////////////////////////////////////////////////////////////////////////////////////////////
        if(isset($resFactura->RespuestaServicioFacturacion->codigoDescripcion)){
            $mensaje=$resFactura->RespuestaServicioFacturacion->codigoDescripcion;
            //print_r(json_encode($resFactura));
            if($mensaje=="VALIDADA"){
                $codigoRecepcion=$resFactura->RespuestaServicioFacturacion->codigoRecepcion;
                $rz="docs/".$titulo."/";
                $cufd= $_SESSION['scufd'];
                $cuis= $_SESSION['scuis'];
                $result = $this->model->insertFactura($id_cliente, $numeroFactura, $cuf, $fechaEmision, $codigoMetodoPago, $montoTotal, $montoTotalSujetoIva, $descuentoAdicional, $productos, $codigoRecepcion,$rz,$cufd,$cuis,$tipoEmision,1,$pv['id_puntoVenta']);
                
                $url = $datosgenerales['ambiente']['enlace']."QR?nit=".$datosgenerales['empresa']['nit']."&cuf=".$cuf."&numero=".$numeroFactura."&t=2";
                $para = $cliente_email;
                $asunto = 'Envio de Factura';
                $descripcion = 'Estimado cliente le enviamos su factura y agradecemos su compra, que tenga un maravilloso día' ;
        
                // Rutas a los archivos que deseas adjuntar
                $rutaArchivoXML = "docs/".$titulo."/".$titulo."_firmada.xml";
                $factura=$this->model->getUltimo();
                $leyenda= $valores['leyenda'];
                $this->imprimirFacturaRollo($datosgenerales,$factura['id_factura']);
                $rutaArchivoPDF = "docs/".$titulo."/".'factura.pdf';
        
                
        
                // Enviar el correo
                if ($this->mailer2($para, $asunto, $descripcion,$rutaArchivoPDF,$rutaArchivoXML)) {
                    
                    $response = array(
                        'mensaje' => $mensaje,
                        'url' => $rutaArchivoPDF
                    );
    
                    echo json_encode($response);
                } else {
                    $response = array(
                        'mensaje' => $mensaje,
                        'url' => $rutaArchivoPDF
                    );
    
                    echo json_encode($response);
                }
    
            }else{
                $response = array(
                    'mensaje' => json_encode($resFactura->RespuestaServicioFacturacion->mensajesList->descripcion)
                );
    
                echo json_encode($response);
            }
        }else{
            $mensaje=$resFactura;
            print_r(json_encode($mensaje));
            $response = array(
                'mensaje' => json_encode($mensaje)
            );

            echo json_encode($response);
        }

    
        
    }
    public function generaFacturaSC()
    {
        $sistemaModel= new SistemaModel();
        $empresaModel=new EmpresaModel();
        $usuarioModel=new UsuariosModel();
        $puntoVentaModel= new PuntoVentaModel();
        $ambienteModel= new AmbienteModel();
        $sucursalModel=new SucursalesModel();
        $usuario=$usuarioModel->editarUsuario($_SESSION['id_usuario']);
        $sistema=$sistemaModel->getSistema(1);
        $pv=$puntoVentaModel->editarPuntoVenta($usuario['id_puntoventa']);
        $empresa=$empresaModel->getEmpresa(1);
        $ambiente=$ambienteModel->getAmbiente($sistema['ambiente']);
        $suc=$sucursalModel->editarSucursal($pv['codigoSucursal']);
        $datosgenerales['sistema']=$sistema;
        $datosgenerales['empresa']=$empresa;
        $datosgenerales['puntoventa']=$pv;
        $datosgenerales['ambiente']=$ambiente;
        $datosgenerales['sucursal']=$suc;
        
        $datos = $_POST['factura'];
        $id_cliente = $_POST['id_cliente'];
        $cliente_email = $_POST['cliente_email'];
        $datos['factura'][0]['cabecera']['codigoSucursal']=$pv['codigoSucursal'];
        $datos['factura'][0]['cabecera']['codigoPuntoVenta']=$pv['codigoPuntoVenta'];
        $datos['factura'][0]['cabecera']['nitEmisor']=$empresa['nit'];
        $datos['factura'][0]['cabecera']['razonSocialEmisor']=$empresa['razonsocial'];
        $datos['factura'][0]['cabecera']['municipio']=$suc['ciudad'];
        $datos['factura'][0]['cabecera']['telefono']=$suc['telefono'];
        $datos['factura'][0]['cabecera']['direccion']=$suc['direccion'];
        $valores = $datos['factura'][0]['cabecera'];
        $nitEmisor = str_pad($valores['nitEmisor'], 13, "0", STR_PAD_LEFT);
        $fechaEmision = $valores['fechaEmision'];
        $dirCufd=str_replace('/', '', $valores['cufd']);
        $directorioCufd = 'docs/'.$dirCufd;

        if (!file_exists($directorioCufd)) {
            mkdir($directorioCufd, 0777, true);
        } 
        $fechat = str_replace("T", "", $fechaEmision);
        $fechat = str_replace("-", "", $fechat);
        $fechat = str_replace(":", "", $fechat);
        $fechat = str_replace(".", "", $fechat);
        $sucursal = str_pad($pv['codigoSucursal'], 4, "0", STR_PAD_LEFT);
        $modalidad = $sistema['modalidad'];
        $tipoEmision = 2;
        

        $tipoFactura = 1;
        $tipoDocSector = str_pad(1, 2, "0", STR_PAD_LEFT);
        $numeroFactura = str_pad($valores['numeroFactura'], 10, "0", STR_PAD_LEFT);
        $puntoVenta = str_pad($pv['codigoPuntoVenta'], 4, "0", STR_PAD_LEFT);
        $cadena = $nitEmisor . $fechat . $sucursal . $modalidad . $tipoEmision . $tipoFactura . $tipoDocSector . $numeroFactura . $puntoVenta;
        $mod11= $this->model->calculaDigitoMod11($cadena);
        $cadena=$cadena.$mod11;        
        $base16= $this->model->baseConvert($cadena,10,16);
        $titulo=$numeroFactura."_".$fechat."_".$valores['numeroDocumento']."_".$valores['nombreRazonSocial'];
        $codControl= $this->model->getCufd($valores['cufd']);
        $cuf = $base16.$codControl['codigoControl'];
        $datos['factura'][0]['cabecera']['cuf'] = $cuf;

        if($datos['factura'][0]['cabecera']['codigoTipoDocumentoIdentidad']==5){
            $datos['factura'][0]['cabecera']['codigoExcepcion'] = 1;

        }
        $temporal = $datos['factura'];
        $xml_temporal = new SimpleXMLElement("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><facturaElectronicaCompraVenta xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"
        xsi:noNamespaceSchemaLocation=\"facturaElectronicaCompraVenta.xsd\"></facturaElectronicaCompraVenta>");
        $this->formato_xml($temporal, $xml_temporal);
        $titulo=str_replace('.', '', $titulo);
        $titulo=str_replace(' ', '_', $titulo);
        $directorio = "docs/".$titulo;
        mkdir($directorio, 0777, true);
        $xml_temporal->asXML("docs/".$titulo."/".$titulo.".xml");
        $archivoXml = "";
        $fp = fopen("docs/".$titulo."/".$titulo.".xml", "r");
        while (!feof($fp)) {
            $linea = fgets($fp);
            $archivoXml .= $linea;
        }
        //print_r(($datos));
        fclose($fp);
        $directorioCufd=$directorioCufd."/";
        $this->firmaDigital("docs/".$titulo."/",$titulo,".xml");
        $archivoXML = "docs/".$titulo."/".$titulo."_firmada.xml";
        copy($archivoXML, $directorioCufd . basename($archivoXML));
        $archivo = "";
        $gzdata = gzencode(file_get_contents("docs/".$titulo."/".$titulo."_firmada.xml"), 9);
        $fp = fopen("docs/".$titulo."/".$titulo."_firmada.xml.zip", "w");
        fwrite($fp, $gzdata);
        fclose($fp);
        $archivo = $gzdata;
        $hashArchivo = hash("sha256", file_get_contents("docs/".$titulo."/".$titulo."_firmada.xml"));
        $numeroFactura = $valores['numeroFactura'];
        $codigoMetodoPago = 1;
        $montoTotal = $valores['montoTotal'];
        $montoTotalSujetoIva = $valores['montoTotalSujetoIva'];
        $descuentoAdicional = $valores['descuentoAdicional'];
        $productos = file_get_contents("docs/".$titulo."/".$titulo."_firmada.xml");
        $codigoRecepcion=0;
        $rz="docs/".$titulo."/";
        $cufd= $valores['cufd'];
        $cuis= $_SESSION['scuis'];
        $result = $this->model->insertFactura($id_cliente, $numeroFactura, $cuf, $fechaEmision, $codigoMetodoPago, $montoTotal, $montoTotalSujetoIva, $descuentoAdicional, $productos, $codigoRecepcion,$rz,$cufd,$cuis,$tipoEmision,2,$pv['id_puntoVenta']);
                
        if($result=="ok"){
            $mensaje="GUARDADA";
        }else{
            $mensaje="ERROR";
        }
        $rutaArchivoAdjunto = "docs/".$titulo."/".$titulo."_firmada.xml";

        $url = "https://pilotosiat.impuestos.gob.bo/consulta/QR?nit=2314273018&cuf=".$cuf."&numero=".$numeroFactura."&t=2";
        $para = $cliente_email;
        $asunto = 'Envio de Factura';
        $descripcion = 'Estimado cliente le enviamos su factura y agradecemos su compra, que tenga un maravilloso día' ;

        // Rutas a los archivos que deseas adjuntar
        $rutaArchivoXML = "docs/".$titulo."/".$titulo."_firmada.xml";
        $factura=$this->model->getUltimo();
        $this->imprimirFacturaRollo($datosgenerales,$factura['id_factura']);
        $rutaArchivoPDF = "docs/".$titulo."/".'factura.pdf';

        

        // Enviar el correo
        if ($this->mailer2($para, $asunto, $descripcion,$rutaArchivoPDF,$rutaArchivoXML)) {
            echo json_encode($mensaje);
        } else {
            echo json_encode($mensaje);
        }

    }
    public function formato_xml($temporal, $xml_temporal)
    {
        $ns_xsi = "http://www.w3.org/2001/XMLSchema-instance";
        foreach ($temporal as $key => $value) {
            if (is_array($value)) {
                if (!is_numeric($key)) {
                    $subnode = $xml_temporal->addChild("$key");
                    $this->formato_xml($value, $subnode);
                } else {
                    $this->formato_xml($value, $xml_temporal);
                }
            } else {
                // Escapar el valor para evitar problemas con caracteres especiales
                $value = htmlspecialchars($value, ENT_QUOTES, 'UTF-8');

                if ($value == null && $value <> '0') {
                    $hijo = $xml_temporal->addChild("$key", "$value");
                    $hijo->addAttribute('xsi:nil', 'true', $ns_xsi);
                } else {
                    $xml_temporal->addChild("$key", "$value");
                }
            }
        }
    }

    
    public function firmaDigital($raiz,$nombre,$ext){
        require_once('vendor/robrichards/xmlseclibs/xmlseclibs.php');
        $cert = file_get_contents('docs/softoken.p12');
        openssl_pkcs12_read($cert, $pkey, 'ProyectosR23W7');
        $privateKey = $pkey['pkey'];
        $publicKey = $pkey['cert'];
        $xml = file_get_contents($raiz.$nombre.$ext);
        $doc = new DOMDocument();
        $doc->loadXML($xml);
        $objDSig = new XMLSecurityDSig();
        $objDSig->setCanonicalMethod(XMLSecurityDSig::EXC_C14N);
        $objDSig->addReference(
            $doc,
            XMLSecurityDSig::SHA256,
            array('http://www.w3.org/2000/09/xmldsig#enveloped-signature'),
            array('force_uri' => true)
        );
        $objKey = new XMLSecurityKey(XMLSecurityKey::RSA_SHA256, array('type' => 'private'));
        $objKey->loadKey($privateKey);
        $objDSig->sign($objKey);
        $objDSig->add509Cert($publicKey);
        $objDSig->appendSignature($doc->documentElement);
        $signedXML = $doc->saveXML();
        file_put_contents($raiz.$nombre."_firmada.xml", $signedXML);


        
    } 
    
    
    public function imprimirFactura($datosgenerales,$id)
    {
        if(isset($_POST['id'])){
            $id_factura = $_POST['id'];
        }else{
            $id_factura = $id;
        }
        $res = $this->model->getFactura($id_factura);
        $xml = $res['productos'];
        $archivoXML = new SimpleXMLElement($xml);
        $nitEmisor = $archivoXML->cabecera[0]->nitEmisor;
        $numeroFactura = $archivoXML->cabecera[0]->numeroFactura;
        $cuf = $archivoXML->cabecera[0]->cuf;
        $fechaEmision = $archivoXML->cabecera[0]->fechaEmision;
        $documentoid = $archivoXML->cabecera[0]->numeroDocumento . ' ' . $archivoXML->cabecera[0]->complemento;
        $nombreRazonSocial = $archivoXML->cabecera[0]->nombreRazonSocial;
        $codigoCliente = $archivoXML->cabecera[0]->numeroDocumento;
        $descuentoAdicional = $archivoXML->cabecera[0]->descuentoAdicional;
        $montoGiftCard =$archivoXML->cabecera[0]->montoGiftCard;
        $leyenda = $archivoXML->cabecera[0]->leyenda;
        $raiz= $res['raiz'];
        ///
        $tipoEmision=$res['tipoEmision'];
        if($tipoEmision==1){
            $leyenda3='"Este documento es la Representación Gráfica de un Documento Fiscal Digital emitido en una modalidad de facturación en línea"';
        }else{
            $leyenda3='"Este documento es la Representación Gráfica de un Documento Fiscal Digital emitido fuera de línea, verifique su envío con su proveedor o en la página web www.impuestos.gob.bo"';
        }
        require "Assets/fpdf/fpdf.php";
        $pdf = new FPDF('P', 'mm', 'Letter');
        $pdf->AddPage();
        //linea 1
        $pdf->SetFont('Arial', 'B', 9);
        $pdf->Cell(70, 5, ($datosgenerales['empresa']['razonsocial']), 0, 0, 'C');
        $pdf->Cell(30, 5, '', 0, 0, 'C');
        
        $pdf->Cell(20, 5, '', 0, 0, 'C');
        $pdf->Cell(40, 5, utf8_decode('NIT'), 0, 0, 'L');
        $pdf->SetFont('Arial', '', 9);
        $pdf->Cell(40, 5, $nitEmisor, 0, 1, 'L');
       
        
        //linea 2
        $pdf->SetFont('Arial', 'B', 9);
        $pdf->Cell(70, 5, utf8_decode($datosgenerales['sucursal']['descripcion']), 0, 0, 'C');
        $pdf->Cell(30, 5, '', 0, 0, 'C');
        $pdf->Cell(20, 5, '', 0, 0, 'C');
        $pdf->Cell(40, 5, utf8_decode('FACTURA N°'), 0, 0, 'L');
        $pdf->SetFont('Arial', '', 9);
        $pdf->Cell(40, 5, $numeroFactura, 0, 1, 'L');
        //linea 3
        $pdf->Cell(70, 5, utf8_decode('No. '.$datosgenerales['puntoventa']['descripcion']), 0, 0, 'C');
        $pdf->Cell(30, 5, '', 0, 0, 'C');
        $pdf->Cell(20, 5, '', 0, 0, 'C');
        $pdf->SetFont('Arial', 'B', 9);
        $pdf->Cell(40, 5, utf8_decode('CÓD. AUTORIZACIÓN'), 0, 0, 'L');
        $pdf->SetFont('Arial', '', 9);
        $y = $pdf->GetY();
        $pdf->MultiCell(40, 5, $cuf, 0, 'L');
        //linea 4
        $pdf->SetY($y + 5);
        $pdf->MultiCell(70, 5, utf8_decode($datosgenerales['sucursal']['direccion']), 0, 'C');
        //$pdf->Cell(70, 5, utf8_decode($datosgenerales['sucursal']['direccion']), 0, 1, 'C');
        //$pdf->Cell(70, 5, utf8_decode('CALACOTO'), 0, 1, 'C');
        $pdf->Cell(70, 5, utf8_decode('Teléfono: '.$datosgenerales['sucursal']['telefono']), 0, 1, 'C');
        $pdf->Cell(70, 5, utf8_decode($datosgenerales['sucursal']['ciudad']), 0, 1, 'C');
        $pdf->Ln(10);
        //linea 5
        $pdf->SetFont('Arial', 'B', 14);
        $pdf->Cell(0, 5, utf8_decode('FACTURA'), 0, 1, 'C');
        //linea 6
        $pdf->SetFont('Arial', '', 10);
        $pdf->Cell(0, 5, utf8_decode('(Con Derecho a Crédito Fiscal)'), 0, 1, 'C');
        $pdf->Ln();
        $pdf->SetFont('Arial', 'B', 9);
        $pdf->Cell(40, 5, utf8_decode('Fecha:'), 0, 0, 'L');
        $pdf->SetFont('Arial', '', 9);
        $pdf->Cell(60, 5, $fechaEmision, 0, 0, 'L');
        $pdf->Cell(30, 5, '', 0, 0, 'C');
        $pdf->SetFont('Arial', 'B', 9);
        $pdf->Cell(30, 5, utf8_decode('NIT/CI/CEX:'), 0, 0, 'L');
        $pdf->SetFont('Arial', '', 9);
        $pdf->Cell(40, 5, $documentoid, 0, 1, 'L');

        $pdf->SetFont('Arial', 'B', 9);
        $pdf->Cell(40, 5, utf8_decode('Nombre/Razón Social:'), 0, 0, 'L');
        $pdf->SetFont('Arial', '', 9);
        $pdf->Cell(60, 5, utf8_decode($nombreRazonSocial), 0, 0, 'L');
        $pdf->Cell(30, 5, '', 0, 0, 'C');
        $pdf->SetFont('Arial', 'B', 9);
        $pdf->Cell(30, 5, utf8_decode('Cod. Cliente:'), 0, 0, 'L');
        $pdf->SetFont('Arial', '', 9);
        $pdf->Cell(40, 5, $codigoCliente, 0, 1, 'L');
        $pdf->Ln();
        $pdf->SetFont('Arial', 'B', 9);
        $y = $pdf->GetY();
        $pdf->MultiCell(30, 4, utf8_decode('CÓDIGO PRODUCTO / SERVICIO'), 1, 'C');
        $pdf->SetY($y);
        $pdf->SetX(40);
        $y = $pdf->GetY();
        $pdf->MultiCell(15, 4, utf8_decode("\nCANT. \n "), 1, 'C');
        $pdf->SetY($y);
        $pdf->SetX(55);
        $y = $pdf->GetY();
        $pdf->MultiCell(30, 4, utf8_decode("\nUNIDAD DE MEDIDA "), 1, 'C');
        $pdf->SetY($y);
        $pdf->SetX(85);
        $y = $pdf->GetY();
        $pdf->MultiCell(50, 4, utf8_decode("\nDESCRIPCIÓN \n "), 1, 'C');
        $pdf->SetY($y);
        $pdf->SetX(135);
        $y = $pdf->GetY();
        $pdf->MultiCell(22, 4, utf8_decode("\nPRECIO UNITARIO"), 1, 'C');
        $pdf->SetY($y);
        $pdf->SetX(157);
        $y = $pdf->GetY();
        $pdf->MultiCell(22, 4, utf8_decode("\nDESCUENTO \n"), 1, 'C');
        $pdf->SetY($y);
        $pdf->SetX(179);
        $y = $pdf->GetY();
        $pdf->MultiCell(30, 4, utf8_decode("\nSUBTOTAL \n "), 1, 'C');
        $pdf->SetFont('Arial', '', 8);
        $productos_lista = $archivoXML->detalle;
        $total=0;
        $tamanoFuente = 4;
        foreach ($productos_lista as $p) {
            $lineasColumna1 = ceil($pdf->GetStringWidth($p->descripcion) / 50);
            $alturaMaxima = $tamanoFuente*$lineasColumna1;
            $y = $pdf->GetY();
            $data=$this->model->getUniMedida($p->unidadMedida);
            $pdf->Cell(30, $alturaMaxima, utf8_decode($p->codigoProducto), 1, 0, 'R');
            $pdf->Cell(15, $alturaMaxima, $p->cantidad, 1, 0, 'R');
            $pdf->Cell(30, $alturaMaxima, $data['descripcion'], 1, 0, 'L');
            //$pdf->Cell(50, 5, utf8_decode($p->descripcion), 1, 0, 'L');
            $pdf->MultiCell(50, $alturaMaxima/$lineasColumna1, utf8_decode($p->descripcion), 1,'L');
            $pdf->SetY($y);
            $pdf->SetX(135);
            
            $pdf->Cell(22, $alturaMaxima, number_format(floatval($p->precioUnitario),2), 1, 0, 'R');
            $pdf->Cell(22, $alturaMaxima, number_format(floatval($p->montoDescuento),2), 1, 0, 'R');
            $pdf->Cell(30, $alturaMaxima, number_format(floatval($p->subTotal),2), 1, 1, 'R');
            $total+=$p->subTotal;
        }

        $pdf->SetFont('Arial', '', 8);
        $pdf->Cell(125, 4, '', 0, 0, 'L');
        $pdf->Cell(44, 4, 'SUBTOTAL Bs', 1, 0, 'R');
        $pdf->Cell(30, 4, number_format($total,2), 1, 1, 'R');
        $pdf->Cell(125, 4, '', 0, 0, 'L');
        $pdf->Cell(44, 4, 'DESCUENTO Bs', 1, 0, 'R');
        $pdf->Cell(30, 4, number_format(floatval($descuentoAdicional),2), 1, 1, 'R');
        $pdf->SetFont('Arial', 'B', 8);
        $fmt = new NumberFormatter('es', NumberFormatter::SPELLOUT);
        $fmt->setAttribute(NumberFormatter::FRACTION_DIGITS, 2);

        $entero = (int)$total-$descuentoAdicional-$montoGiftCard;
        $fraccion = (int)(($total-$descuentoAdicional-$montoGiftCard) * 100 % 100);
        $fraccion = str_pad($fraccion, 2, '0', STR_PAD_LEFT);
        $letras = $fmt->format($entero) . ' ' . $fraccion . '/100';
        $pdf->Cell(125, 4, utf8_decode("SON: ". strtoupper($letras) ." BOLIVIANOS"), 0, 0, 'L');
        $pdf->SetFont('Arial', '', 8);
        $pdf->Cell(44, 4, 'TOTAL Bs', 1, 0, 'R');
        $pdf->Cell(30, 4, number_format(($total-$descuentoAdicional),2), 1, 1, 'R');
        $pdf->Cell(125, 4, '', 0, 0, 'L');
        $pdf->Cell(44, 4, 'MONTO GIFT CARD Bs', 1, 0, 'R');
        $pdf->Cell(30, 4, number_format(floatval($montoGiftCard),2), 1, 1, 'R');
        $pdf->SetFont('Arial', 'B', 8);
        $pdf->Cell(125, 4, '', 0, 0, 'L');
        $pdf->Cell(44, 4, 'MONTO A PAGAR Bs', 1, 0, 'R');
        $pdf->Cell(30, 4, number_format(($total-$descuentoAdicional-$montoGiftCard),2), 1, 1, 'R');
        $pdf->Cell(125, 4, '', 0, 0, 'L');
        $pdf->SetFont('Arial', 'B', 7);
        $pdf->Cell(44, 4, utf8_decode('IMPORTE BASE CRÉDITO FISCAL'), 1, 0, 'R');
        $pdf->SetFont('Arial', 'B', 8);
        $pdf->Cell(30, 4, number_format(($total-$descuentoAdicional-$montoGiftCard),2), 1, 1, 'R');
        $pdf->Ln(5);
        $pdf->SetFont('Arial', '', 7);
        $y = $pdf->GetY();
        $pdf->Cell(170, 10, utf8_decode('ESTA FACTURA CONTRIBUYE AL DESARROLLO DEL PAÍS, EL USO ILÍCITO SERÁ SANCIONADO PENALMENTE DE ACUERDO A LEY'), 0, 1, 'C');
        $pdf->Cell(170, 4, utf8_decode($leyenda), 0, 1, 'C');
        $pdf->MultiCell(170, 4, utf8_decode($leyenda3));
        require "Assets/qrlib/qrlib.php";

        
        $urlqr=$datosgenerales['ambiente']['qr']."consulta/QR?nit=".$datosgenerales['empresa']['nit']."&cuf=".$cuf."&numero=".$numeroFactura."&t=2";
        //QRcode::png($urlqr);
        QRcode::png($urlqr, $raiz.'qr.png');
        $pdf->Image($raiz.'qr.png', 180, $y, 25);
        $pdf->Output($raiz.'factura.pdf', 'F');
        
    }




    public function imprimirFacturaRollo($datosgenerales,$id)
    {
        if(isset($_POST['id'])){
            $id_factura = $_POST['id'];
        }else{
            $id_factura = $id;
        }
        $res = $this->model->getFactura($id_factura);
        $xml = $res['productos'];
        $archivoXML = new SimpleXMLElement($xml);
        $nitEmisor = $archivoXML->cabecera[0]->nitEmisor;
        $numeroFactura = $archivoXML->cabecera[0]->numeroFactura;
        $cuf = $archivoXML->cabecera[0]->cuf;
        $fechaEmision = $archivoXML->cabecera[0]->fechaEmision;
        $documentoid = $archivoXML->cabecera[0]->numeroDocumento . ' ' . $archivoXML->cabecera[0]->complemento;
        $nombreRazonSocial = $archivoXML->cabecera[0]->nombreRazonSocial;
        $codigoCliente = $archivoXML->cabecera[0]->numeroDocumento;
        $descuentoAdicional = $archivoXML->cabecera[0]->descuentoAdicional;
        $leyenda = $archivoXML->cabecera[0]->leyenda;
        $raiz= $res['raiz'];

        $cant_productos = $archivoXML->detalle;
        $cant=0;
        foreach ($cant_productos as $p) {
            $cant++;
        }
        $tam=210+$cant*7;
        ///
        $tipoEmision=$res['tipoEmision'];
        if($tipoEmision==1){
            $leyenda3='"Este documento es la Representación Gráfica de un Documento Fiscal Digital emitido en una modalidad de facturación en línea"';
        }else{
            $leyenda3='"Este documento es la Representación Gráfica de un Documento Fiscal Digital emitido fuera de línea, verifique su envío con su proveedor o en la página web www.impuestos.gob.bo"';
        }
        require "Assets/fpdf/fpdf.php";
        $pdf = new FPDF('P', 'mm', array(80, $tam)); 
        
        $pdf->AddPage();

        $pdf->SetFont('Arial', 'B', 12);
        $pdf->Cell(0, 10, 'FACTURA', 0, 1, 'C');  // Alineado al centro

        $pdf->SetFont('Arial', '', 8);
        $pdf->Cell(0, 4, utf8_decode('(CON DERECHO A CREDITO FISCAL)'), 0, 1, 'C');
        $pdf->MultiCell(70, 4, utf8_decode($datosgenerales['empresa']['razonsocial']), 0, 'C');
        $pdf->Cell(0, 4, utf8_decode($datosgenerales['sucursal']['descripcion']), 0, 1, 'C');
        
        $pdf->Cell(0, 4, utf8_decode($datosgenerales['puntoventa']['descripcion']), 0, 1, 'C');
        $pdf->MultiCell(70, 4, utf8_decode($datosgenerales['sucursal']['direccion']), 0, 'C');
        $pdf->Cell(0, 4, utf8_decode('Teléfono: '.$datosgenerales['sucursal']['telefono']), 0, 1, 'C');
        $pdf->Cell(0, 4, utf8_decode($datosgenerales['sucursal']['ciudad']), 0, 1, 'C');
        $pdf->SetLeftMargin(5); 
        $pdf->SetRightMargin(5);
        $pdf->Cell(0, 5, utf8_decode('--------------------------------------------------------------------------'), 0, 1, 'C');

        $pdf->SetFont('Arial', 'B', 8);
        $pdf->Cell(40, 4, utf8_decode('NIT Emisor:'), 0, 0, 'L');
        $pdf->SetFont('Arial', '', 9);
        $pdf->Cell(60, 4, $nitEmisor, 0, 1, 'L');        
        //$pdf->Cell(30, 5, '', 0, 0, 'C');

        $pdf->SetFont('Arial', 'B', 8);
        $pdf->Cell(40, 4, utf8_decode('N° Factura:'), 0, 0, 'L');
        $pdf->SetFont('Arial', '', 8);
        $pdf->Cell(40, 4, $numeroFactura, 0, 1, 'L');

        $pdf->SetFont('Arial', 'B', 8);
        $pdf->Cell(40, 4, utf8_decode('Código Autorización:'), 0, 1, 'L');
        $pdf->SetFont('Arial', '', 8);
        $pdf->MultiCell(70, 4, $cuf, 0, 'C');
        
        $pdf->Cell(0, 5, utf8_decode('--------------------------------------------------------------------------'), 0, 1, 'C');

        $pdf->SetFont('Arial', 'B', 8);
        $pdf->Cell(30, 4, utf8_decode('Nombre/Razón Social:'), 0, 1, 'L');
        $pdf->SetFont('Arial', '', 8);
        $pdf->MultiCell(70, 4, utf8_decode($nombreRazonSocial), 0, 'C');
        $pdf->Cell(40, 4, '', 0, 1, 'C'); // Espacio adicional
        
        
        $pdf->SetFont('Arial', 'B', 8);
        $pdf->Cell(30, 5, utf8_decode('NIT/CI/CEX:'), 0, 0, 'L');
        $pdf->SetFont('Arial', '', 8);
        $pdf->Cell(40, 5, $documentoid, 0, 1, 'L');
        
        $pdf->SetFont('Arial', 'B', 8);
        $pdf->Cell(30, 5, utf8_decode('Cod. Cliente:'), 0, 0, 'L');
        $pdf->SetFont('Arial', '', 8);
        $pdf->Cell(40, 5, $codigoCliente, 0, 1, 'L');
        
        $pdf->SetFont('Arial', 'B', 8);
        $pdf->Cell(30, 5, utf8_decode('Fecha:'), 0, 0, 'L');
        $pdf->SetFont('Arial', '', 8);
        $pdf->Cell(40, 5, $fechaEmision, 0, 0, 'L');
        $pdf->Cell(80, 5, '', 0, 1, 'C'); // Espacio adicional

        $pdf->Cell(0, 5, utf8_decode('--------------------------------------------------------------------------'), 0, 1, 'C');
        $pdf->SetFont('Arial', 'B', 8);
        $pdf->Cell(0, 4, utf8_decode('DETALLE'), 0, 0, 'C');
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////DETALLE////////////////////////////////////////////////////////
        $pdf->Ln(); // Salto de línea
        $productos_lista = $archivoXML->detalle;
        $total=0;
        $tamanoFuente = 4;
        foreach ($productos_lista as $p) {
            $pdf->SetFont('Arial', 'B', 8);
            $pdf->MultiCell(70, 3, utf8_decode($p->codigoProducto.' - '.$p->descripcion), 0, 'L');
            $pdf->SetFont('Arial', '', 8);
            $pdf->Cell(40, $tamanoFuente, '( '.$p->cantidad.' x '.$p->precioUnitario.' ) - '.$p->montoDescuento, 0, 0, 'L');
            $pdf->Cell(0, $tamanoFuente, $p->subTotal, 0, 0, 'R');
            $pdf->Ln(4); // Salto de línea
            $total+=$p->subTotal;
        }
        $pdf->Cell(0, 5, utf8_decode('...........................................................................................'), 0, 1, 'C');

        $pdf->SetFont('Arial', 'B', 8);
        $pdf->Cell(52, 4, utf8_decode('Subtotal Bs.'), 0, 0, 'R');
        $pdf->SetFont('Arial', '', 8);
        $pdf->Cell(18, 4, number_format($total,2), 0, 0, 'R');
        $pdf->Ln(); // Salto de línea

        $pdf->SetFont('Arial', 'B', 8);
        $pdf->Cell(52, 4, utf8_decode('Descuento Bs.'), 0, 0, 'R');
        $pdf->SetFont('Arial', '', 8);
        $pdf->Cell(18, 4, number_format('0',2), 0, 0, 'R');
        $pdf->Ln(); // Salto de línea
        
        $pdf->SetFont('Arial', 'B', 8);
        $pdf->Cell(52, 4, utf8_decode('Total Bs.'), 0, 0, 'R');
        $pdf->SetFont('Arial', '', 8);
        $pdf->Cell(18, 4, number_format($total,2), 0, 0, 'R');
        $pdf->Ln(); // Salto de línea
        
        $pdf->SetFont('Arial', 'B', 8);
        $pdf->Cell(52, 4, utf8_decode('Importe Base Para Crédito Fiscal Bs.'), 0, 0, 'R');
        $pdf->SetFont('Arial', '', 8);
        $pdf->Cell(18, 4, number_format($total,2), 0, 0, 'R');
        $pdf->Ln(); // Salto de línea

        $fmt = new NumberFormatter('es', NumberFormatter::SPELLOUT);
        $fmt->setAttribute(NumberFormatter::FRACTION_DIGITS, 2);

        $entero = (int)$total-$descuentoAdicional;
        $fraccion = (int)(($total-$descuentoAdicional) * 100 % 100);
        $fraccion = str_pad($fraccion, 2, '0', STR_PAD_LEFT);
        $letras = $fmt->format($entero) . ' ' . $fraccion . '/100';
        $pdf->Cell(30, 4, utf8_decode("SON: ". strtoupper($letras) ." BOLIVIANOS"), 0, 0, 'L');
        $pdf->Ln(); // Salto de línea

        
        //////////////////////////////////////////////////////////////////////////////////////////////////////////
        $pdf->Cell(0, 5, utf8_decode('--------------------------------------------------------------------------'), 0, 1, 'C');
        $pdf->SetFont('Arial', '', 6);
        $pdf->MultiCell(70, 3, utf8_decode('ESTA FACTURA CONTRIBUYE AL DESARROLLO DEL PAÍS, EL USO ILÍCITO SERÁ SANCIONADO PENALMENTE DE ACUERDO A LEY'), 0, 'C');
        
        $pdf->MultiCell(70, 4, utf8_decode($leyenda),0,'C');
        $pdf->Ln(2); // Salto de línea
        $pdf->MultiCell(70, 4, utf8_decode($leyenda3),0,'C');
        require "Assets/qrlib/qrlib.php";
        $urlqr=$datosgenerales['ambiente']['qr']."consulta/QR?nit=".$datosgenerales['empresa']['nit']."&cuf=".$cuf."&numero=".$numeroFactura."&t=1";
        //QRcode::png($urlqr);
        QRcode::png($urlqr, $raiz.'qr.png');
        $yDespuesDeLineas = $pdf->GetY();
        $y = $yDespuesDeLineas + 5; 
        $pdf->Image($raiz.'qr.png', 25, $y, 30);


        $pdf->Output($raiz.'factura.pdf', 'F');
    }








   

    public function anularFactura($cuf){
        $sistemaModel= new SistemaModel();
        $empresaModel=new EmpresaModel();
        $usuarioModel=new UsuariosModel();
        $puntoVentaModel= new PuntoVentaModel();
        $ambienteModel= new AmbienteModel();
        $sucursalModel=new SucursalesModel();
        $usuario=$usuarioModel->editarUsuario($_SESSION['id_usuario']);
        $sistema=$sistemaModel->getSistema(1);
        $pv=$puntoVentaModel->editarPuntoVenta($usuario['id_puntoventa']);
        $empresa=$empresaModel->getEmpresa(1);
        $ambiente=$ambienteModel->getAmbiente($sistema['ambiente']);
        $suc=$sucursalModel->editarSucursal($pv['codigoSucursal']);
        $datosgenerales['sistema']=$sistema;
        $datosgenerales['empresa']=$empresa;
        $datosgenerales['puntoventa']=$pv;
        $datosgenerales['ambiente']=$ambiente;
        $datosgenerales['sucursal']=$suc;
        require "SiatFacturacion.php";
        $siat = new SiatFacturacion();
        $resFactura = $siat->anulacionFactura($datosgenerales,$cuf);
        $mensaje=$resFactura->RespuestaServicioFacturacion->transaccion;
        if($mensaje==true){
            $data = $this->model->anularFactura($cuf);
            if($data=="ok"){
                $msg="ok";
                $res= $this->model->getFacturaCuf($cuf);
                $numeroFactura=$res['numeroFactura'];
                $cliente_email=$res['cliente_email'];
                $url=$ambiente['qr']."consulta/QR?nit=".$empresa['nit']."&cuf=".$cuf."&numero=".$numeroFactura."&t=2";
                $para      = $cliente_email;
                $asunto    = 'Anulación de Factura: '.$numeroFactura;
                $descripcion   = "Estimado cliente la factura numero: ".$numeroFactura." del siguiente enlace a sido anulada: ".$url." \nMotivo de Anulación: Factura mal Emitida";
                $de = 'facturacionr23w7@proyectosr23w7.com';

                if ($this->mailer($para, $asunto, $descripcion))
                {
                   echo json_encode($mensaje);
                   die();
                }else{
                   echo json_encode($mensaje);
                   die();
                }
            }else{
                $msg="Error al anular la Factura $data";
            }
            
        }else{
            $msg="Error al anular la Factura $mensaje";
            
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function revertirFactura($cuf){
        $sistemaModel= new SistemaModel();
        $empresaModel=new EmpresaModel();
        $usuarioModel=new UsuariosModel();
        $puntoVentaModel= new PuntoVentaModel();
        $ambienteModel= new AmbienteModel();
        $sucursalModel=new SucursalesModel();
        $usuario=$usuarioModel->editarUsuario($_SESSION['id_usuario']);
        $sistema=$sistemaModel->getSistema(1);
        $pv=$puntoVentaModel->editarPuntoVenta($usuario['id_puntoventa']);
        $empresa=$empresaModel->getEmpresa(1);
        $ambiente=$ambienteModel->getAmbiente($sistema['ambiente']);
        $suc=$sucursalModel->editarSucursal($pv['codigoSucursal']);
        $datosgenerales['sistema']=$sistema;
        $datosgenerales['empresa']=$empresa;
        $datosgenerales['puntoventa']=$pv;
        $datosgenerales['ambiente']=$ambiente;
        $datosgenerales['sucursal']=$suc;
        require "SiatFacturacion.php";
        $siat = new SiatFacturacion();
        $resFactura = $siat->reversionAnulacionFactura($datosgenerales,$cuf);
        $mensaje=$resFactura->RespuestaServicioFacturacion->transaccion;
        if($mensaje==true){
            $data = $this->model->revertirAnularFactura($cuf);
            if($data=="ok"){
                $msg="ok";
                $res= $this->model->getFacturaCuf($cuf);
                $numeroFactura=$res['numeroFactura'];
                $cliente_email=$res['cliente_email'];
                $url=$ambiente['qr']."consulta/QR?nit=".$empresa['nit']."&cuf=".$cuf."&numero=".$numeroFactura."&t=2";
                $para      = $cliente_email;
                $asunto    = 'Reverción de Anulación de Factura: '.$numeroFactura;
                $descripcion   = "Estimado cliente la factura numero: ".$numeroFactura." del siguiente enlace esta vigente: ".$url." \nSe ha revertido la anulación de su factura";
                $de = 'facturacionr23w7@proyectosr23w7.com';

                if ($this->mailer($para, $asunto, $descripcion))
                {
                    echo json_encode($mensaje);
                    die();
                }else{
                    echo json_encode($mensaje);
                    die();
                }
            }else{
                $msg="Error al revertir la Factura $data";
            }
            
        }else{
            $msg="Error al revertir la Factura $mensaje";
            
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    


    /*public function correo(){
        
        $cuf=1;
        $numeroFactura=1;
        $cliente_email="royercaf23@gmail.com";
        $url="https://pilotosiat.impuestos.gob.bo/consulta/QR?nit=2314273018&cuf=".$cuf."&numero=".$numeroFactura."&t=2";
        $para      = $cliente_email;
        $asunto    = 'Envio de Factura';
        $descripcion   = 'Puede descargar su factura en el siguiente enlace: '.$url;
        $de = 'facturacionr23w7@proyectosr23w7.com';

        if ($this->mailer($para, $asunto, $descripcion, $de))
        {
            echo (" Correo enviado satisfactoriamente");
        }else{
            echo(" No enviado");
        }
    }*/
    /*public function correo1() {
        $cuf = 1;
        $numeroFactura = 1;
        $cliente_email="eqweqw@gml.com";
        
        $url = "https://pilotosiat.impuestos.gob.bo/consulta/QR?nit=2314273018&cuf=".$cuf."&numero=".$numeroFactura."&t=2";
        $para = $cliente_email;
        $asunto = 'Envio de Factura';
        $descripcion = 'Puede descargar su factura en el siguiente enlace: '.$url;
        $de = 'facturacionr23w7@proyectosr23w7.com';

        $this->mailer($para,$asunto,$descripcion);
    }*/

    public function mailer($para,$asunto,$descripcion){
        if($para==""){
            $para='facturacionr23w7@proyectosr23w7.com';
        }
        $mail = new PHPMailer(true);

        try {
            // Configuración del servidor SMTP
            $mail->isSMTP();
            $mail->Host = 'mail.proyectosr23w7.com'; // Cambia esto por el servidor SMTP de tu proveedor
            $mail->SMTPAuth = true;
            $mail->Username = 'facturacionr23w7@proyectosr23w7.com'; // Tu usuario SMTP
            $mail->Password = 'Sabandijitas723'; // Tu contraseña SMTP
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
            $mail->Port = 587; // El puerto que usa tu servidor SMTP

            // Remitente y destinatarios
            $mail->setFrom('facturacionr23w7@proyectosr23w7.com', 'FacturacionR23W7');
            $mail->addAddress($para);

            // Contenido del correo
            $mail->isHTML(true);
            $mail->Subject = $asunto;
            $mail->Body    = $descripcion;

            $mail->send();
            return true;
        } catch (Exception $e) {
            return $mail->ErrorInfo;
        }
    }
    
    public function mailer2($para,$asunto,$descripcion,$pdf,$xml){
        if($para==""){
            $para='facturacionr23w7@proyectosr23w7.com';
        }
        $mail = new PHPMailer(true);

        try {
            // Configuración del servidor SMTP
            $mail->isSMTP();
            $mail->Host = 'mail.proyectosr23w7.com'; // Cambia esto por el servidor SMTP de tu proveedor
            $mail->SMTPAuth = true;
            $mail->Username = 'facturacionr23w7@proyectosr23w7.com'; // Tu usuario SMTP
            $mail->Password = 'Sabandijitas723'; // Tu contraseña SMTP
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
            $mail->Port = 587; // El puerto que usa tu servidor SMTP

            // Remitente y destinatarios
            $mail->setFrom('facturacionr23w7@proyectosr23w7.com', 'FacturacionR23W7');
            $mail->addAddress($para);

            // Contenido del correo
            $mail->isHTML(true);
            $mail->Subject = $asunto;
            $mail->Body    = $descripcion;
            $mail->addAttachment($xml, 'factura.xml');
            $mail->addAttachment($pdf, 'factura.pdf');
            $mail->send();
            return true;
        } catch (Exception $e) {
            return $mail->ErrorInfo;
        }
    }
   
}

?>