<?php require_once "Views/templates/header.php";
date_default_timezone_set('America/La_Paz');
$fechaHora=(new DateTime())->format("Y-m-d\TH:i:s.v");?>
<!-- Begin Page Content -->
<section class="content">
    <?php if($data['evento']){?>
    <div class="card">
        <div class="card-header">
            <h4 class="card-title">Nuevo Pedido Sin Conexion</h4>
        </div>
        <div class="card-body">
            <form action="" class="row">
                <div class="form-group row col-md-9">
                    <div class="form-group col-md-3">
                        <label for="numeroFactura">Nro. Factura</label>
                        <input type="number" class="form-control" id="numeroFactura" name="numeroFactura" value=<?=$data['numero']?>>
                    </div>
                    <div class="form-group col-md-9">
                        <label for="actEconomica">Actividad Economica</label>
                        <select name="actEconomica" id="actEconomica" class="form-control" >
                        <?php foreach($data['actividades'] as $act){?>
                        <option class="mb-5" value=<?=$act['codigoCaeb']?> <?php if($act['tipoActividad'] == "P") echo 'selected'; ?>> <?=$act['codigoCaeb'].' '.$act['descripcion']?></option>
                        <?php }?>
                        </select>
                    </div>
                    <div class="form-group col-md-3">
                        <label for="documentoid">NIT/CI</label>
                        <div class="input-group-append">
                        <input type="text" class="form-control" id="documentoid" name="documentoid" placeholder="Ingrese el carnet o NIT">
                        <button class="btn btn-outline-secondary" type="button" onclick="buscarCliente()"><i class="fas fa-search"></i></button>
                        </div>
                    </div>
                    <div class="form-group col-md-3">
                        <label for="tipo_documento">Tipo de documento</label>
                        <select name="tipo_documento" id="tipo_documento" class="form-control" disabled>
                            <option value="">Selecciona una opción</option>
                            <option value="1">Cedula de identidad</option>
                            <option value="5">NIT</option>
                            <option value="3">Pasaporte</option>
                            <option value="2">Cedula de identidad de Extranjero</option>
                            <option value="4">Otro Documento</option>
                        </select>
                    </div>
                    
                    <div class="form-group col-md-3">
                        <label for="razon_social">Razon Social</label>
                        <input type="hidden" id="id_cliente" name="id_cliente">
                        <input type="hidden" id="complementoid" name="complementoid">
                        <input type="text" class="form-control" id="razon_social" name="razon_social"  readonly>
                    </div>
                    <div class="form-group col-md-3">
                        <label for="cliente_email">Correo Electrónico</label>
                        <input type="email" class="form-control" id="cliente_email" name="cliente_email"  readonly>
                    </div>
                    <div class="form-group col-md-3">
                        <label for="tipoPago">Metodo de Pago</label>
                        <select name="tipoPago" id="tipoPago" class="form-control" >
                        <?php foreach($data['pagos'] as $pago){?>
                        <option class="mb-5" value=<?=$pago['codigo']?>><?=$pago['descripcion']?></option>
                        <?php }?>
                        </select>
                
                    </div>
                    <div class="form-group col-md-3">
                    <label for="cardNumber">Número de Tarjeta:</label>
                        <input type="text" id="cardNumber" name="cardNumber" class="form-control" placeholder="XXXX-XXXX-XXXX-XXXX"
                        pattern="^\d{4}-\d{4}-\d{4}-\d{4}$" required disabled class="disabled">
                        <label id="cardNumberError" style="color:red; display: none;">Formato incorrecto. Debe ser 4567-4565-4654-1613.</label>
                            
                    </div>
                    <div class="form-group col-md-3">
                        <label for="montoGiftCard">Monto Gift Card:</label>
                        <input type="number" id="montoGiftCard" name="montoGiftCard" class="form-control" value="0.00" style="text-align: right;"
                            required disabled class="disabled">
                    
                    </div>

                </div>
                <input type="hidden" id="cufdvalor" name="cufdvalor" value="<?=$data['cufd']?>"> 
                
                <div class="form-group row col-md-3">
                    <div class="card">
                        <div class="input-group">
                            <span class="input-group-text">S. Total</span>
                            <input type="number" class="form-control" id="subTotal" name="subTotal" value="0.00" style="text-align: right;" readonly>
                        </div>
                        <div class="input-group">
                            <span class="input-group-text">Desc. Add</span>
                            <input type="number" class="form-control" id="descAdicional" name="descAdicional" value="0.00" style="text-align: right;" onchange="calcularstotal()">
                        </div>    
                        <div class="input-group">
                            <span class="input-group-text">Total</span>
                            <input type="number" class="form-control" id="total" name="total" value="0.00" min=0 style="text-align: right;" readonly>
                        </div>
                        <div class="input-group">
                        <span class="badge bg-secondary" id="comunicacionSiat">Desconectado</span>
                        <p id="lineacuis"><?php if(!isset($_SESSION['scuis'])) echo "CUIS inexistente"; else echo "CUIS: ".$_SESSION['scuis'];?></p>
                        <span id="cufd">No existe cufd vigente</span>  
                        </div>  
                    </div>
                </div>
                <input type="hidden" id="snick" name="snick" value="<?=$_SESSION['nick']?>"> 
                <div class="form-group">
            
            <label for="fechaHora" class="col-form-label">Fecha y Hora:</label>
            <input type="datetime-local" id="fechaHora" name="fechaHora" class="form-control" value="<?= $fechaHora ?>">
        </div>  
            </form>
            
            <?php  
            if($data['descripcion_evento']>4){?>
            <label for="cafc">Código de Autoriación de Facturas por Contingencia (CAFC)</label>
            <input type="text" class="form-control" id="cafc" name="cafc" value=<?=$data['cafc']?> readonly>
            <?php }else{?>
                <input type="hidden" id="cafc" name="cafc" value="<?= null ?>">
            <?php }?>
            
            
        </div>
    </div>
    <div class="card">
        <div class="card-header">
            <h4 class="card-title">Agregar Productos</h4>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="form-group col-md-3">
                    <label for="">Cod. Producto</label>
                    <input type="hidden" id="codigoProducto" name="codigoProducto">
                    <div class="input-group-append">
                        <input type="text" class="form-control" id="codigo" name="codigo" autocomplete="off">
                        <button class="btn btn-outline-secondary" type="button" onclick="buscarProducto()"><i class="fas fa-search"></i></button>
                        
                    </div> 
                    <ul id="lista" class="lista">
                  
                    </ul>  
                </div>
                <div class="form-group col-md-3">
            <label for="">Producto</label>
            <div class="input-group-append">
                        <input type="text" class="form-control" id="nombre_producto" name="nombre_producto">
                    </div> 
                    <ul id="lista2" class="lista2">
                  
                    </ul>  
                </div>
                    <input type="hidden" class="form-control" id="descripcion" name="descripcion" disabled>
                    <input type="hidden" class="form-control" id="codigoMedida" name="codigoMedida">
                <div class="form-group col-md-1">
                    <label for="">Cant.</label>
                    <input type="number" class="form-control" id="cantProducto" name="cantProducto" value="1" min="1" onchange="calcularstotal()">
                </div>
                <div class="form-group col-md-1">
                    <label for="">Precio</label>
                    <input type="number" class="form-control" id="precio_venta" name="precio_venta" min="0" step="0.01" onchange="calcularstotal()">
                </div>
                <div class="form-group col-md-1">
                    <label for="">Descuento</label>
                    <input type="number" class="form-control" id="descProducto" name="descProducto" value="0.00" min="0" step="0.01" onchange="calcularstotal()">
                </div>
                <div class="form-group col-md-1">
                    <label for="">Subtotal</label>
                    <input type="number" class="form-control" id="sTotal" name="sTotal" min="0" step="0.01" value="0.00">
                </div>
                <div class="form-group col-md-1">
                    <label for="">&nbsp;</label>
                    <div class="input-group">
                        <buttton class="btn btn-info" type="button" onclick="cargarProductos()"><i class="fas fa-plus"></i></buttton>
                    </div>
                </div>        
            </div>
        </div>
        <div class="card-footer">
            <button class="btn btn-success" onclick="emitirFacturaSC()">Generar factura Sin Conexion</button>


        </div>
    </div>

    <div class="card">
        <dic class="card-body">
            <table class="table">
                <thead>
                    <tr>
                        <th>Producto</th>
                        <th>Cantidad</th>
                        <th>Precio</th>
                        <th>Descuento</th>
                        <th>Subtotal</th>
                        <th>&nbsp;</th>
                    </tr>
                </thead>
                <tbody id="detalles">

                </tbody>
            </table>
        </dic>
    </div>
    <?php }else{?>
        <h2>No puedes emitir facturas sin conexion sin antes registrar el evento</h2>
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <a href="<?=base_url?>Avanzado/evento_significativo" class="btn btn-primary"><i class="fas fa-exclamation"></i> Registrar Evento</a>
        </div>
    <?php }?>
        
    
</section>
<!-- Page Heading -->

<div class="modal fade" id="nuevo_cliente" tabindex="-1" role="dialog" aria-labelledby="my-modal-title" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="title">Nuevo Cliente</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form method="POST" id="frmCliente">
          <div class="form-group">
            <input type="hidden" id="id_cliente_c" name="id_cliente_c">
                        
            <label for="razon_social" class="col-form-label">Razon Social:</label>
            <input type="text" class="form-control" id="razon_social_c" name="razon_social_c" placeholder="Razon Social">
          </div>
          <div class="form-group">
          <label for="tipo_documento_c">Tipo de documento</label>
              <select name="tipo_documento_c" id="tipo_documento_c" class="form-control">
                  <option value="">Selecciona una opción</option>
                  <option value="1">Cedula de identidad</option>
                  <option value="5">NIT</option>
                  <option value="3">Pasaporte</option>
                  <option value="2">Cedula de identidad de Extranjero</option>
                  <option value="4">Otro Documento</option>
              </select>
          </div>
          <div class="form-group">
            <label for="documentoid_c" class="col-form-label">CI/NIT/PAS:</label>
            <input type="text" class="form-control" id="documentoid_c" name="documentoid_c" value="">
          </div>
          <div class="form-group">
            <label for="complementoid_c" class="col-form-label">Complemento:</label>
            <input type="text" class="form-control" id="complementoid_c" name="complementoid_c" placeholder="Complemento">
          </div>
          <div class="form-group">
            <label for="cliente_email_c" class="col-form-label">Email:</label>
            <input type="text" class="form-control" id="cliente_email_c" name="cliente_email_c" placeholder="Email">
          </div>
          <div class="form-group">
            <label for="cliente_celular_c" class="col-form-label">Celular:</label>
            <input type="text" class="form-control" id="cliente_celular_c" name="cliente_celular_c"   value="0">
          </div>
          
        </form>
      </div>
      <div class="modal-footer">
        <button type="submit" class="btn btn-primary" onclick="registrarCliente(event);" id="btnAccion">Registrar</button>
      </div>
    </div>
  </div>
</div>      
<!-- /.Modal Agragar Producto -->



<!-- /.container-fluid -->

<?php require_once "Views/templates/footer.php";?>
<script src="<?= base_url?>Assets/js/facturacion.js"></script>
<script src="<?= base_url?>Assets/js/buscador.js"></script>