<?php
class Productos extends Controller
{
    public function __construct()
    {   
        session_start();
        $this->loadModel('UnidadMedidasModel');
        $this->loadModel('ProductosServiciosModel');
        parent::__construct();
    }
    private function loadModel($model) {
        $modelPath = __DIR__ . '/../Models/' . $model . '.php';
        if (file_exists($modelPath)) {
            require_once $modelPath;
        } else {
            throw new Exception("Model file not found: " . $modelPath);
        }
    }

    public function index(){
        $categoriasModel= new ProductosServiciosModel();
        $data['categorias']=$categoriasModel->getProductosServicios();
        $umedidasModel= new UnidadMedidasModel();
        $data['medidas']=$umedidasModel->getUnidadMedidas();
        
        $this->views->getView($this,"index",$data);
    }

    public function listar(){
        $data=$this->model->getProductos();
        for($i=0;$i<count($data);$i++){
            if($data[$i]['producto_estado']==1){
                $data[$i]['producto_estado']='<span class="badge bg-success">Activo</span>';
                $data[$i]['acciones']='<div><button class="btn btn-primary" type="button" onclick="btnEditarProducto('.$data[$i]['id_producto'].')"><i class="fas fa-edit"></i></button>
            <button class="btn btn-danger" type="button" onclick="btnInactivarProducto('.$data[$i]['id_producto'].')""><i class="fas fa-trash"></i></button>
            </div>';
            }else{
                $data[$i]['producto_estado']='<span class="badge bg-danger">Inactivo</span>';
                $data[$i]['acciones']='<div><button class="btn btn-success" type="button" onclick="btnReactivarProducto('.$data[$i]['id_producto'].')""><i class="fas fa-plus-circle"></i></button>
            </div>';
            }
            

        }
        echo json_encode($data);
        die();
    }

    public function registrar(){
        $id_producto=$_POST['id_producto'];
        $codigo = $_POST['codigo'];
        $nombre_producto = $_POST['nombre_producto'];
        $precio_venta = $_POST['precio_venta'];
        $id_medida = $_POST['id_medida'];
        $id_categoria = $_POST['id_categoria'];
        

        if(empty($nombre_producto) || empty($precio_venta) ){
            $msg= "Los campos son obligatorio";
        }else{
            if($id_producto==""){
                $data=$this->model->registrarProducto($codigo,$nombre_producto,$precio_venta,$id_medida,$id_categoria);
                if($data=="ok"){
                    $msg="si";
                }else{
                    $msg="Error al registrar producto";
                }
                
            }else{
                $data=$this->model->modificarProducto($codigo,$nombre_producto,$precio_venta,$id_medida,$id_categoria,$id_producto);
                if($data=="modificado"){
                    $msg="modificado";
                }else{
                    $msg="Error al modificar producto";
                }
            }
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
        
    }
    public function editar(int $id){
        $data = $this->model->editarProducto($id);
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function inactivar(int $id){
        $data = $this->model->accion(0,$id);
        if($data==1){
            $msg="ok";
        }else{
            $msg="Error al inactivar el producto";
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    
    public function activar(int $id){
        $data = $this->model->accion(1,$id);
        if($data==1){
            $msg="ok";
        }else{
            $msg="Error al activar el producto";
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    

}
?>
