/**
 * Javascript controller for the "Actions" panel at the bottom of the page.
 *
 * @module     mod_assign/grading_actions
 * @copyright  2016 Damyon Wiese <damyon@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since      3.1
 */
define("mod_assign/grading_actions",["jquery","mod_assign/grading_events"],(function($,GradingEvents){var GradingActions=function(selector){this._regionSelector=selector,this._region=$(selector),this.registerEventListeners()};return GradingActions.prototype._regionSelector=null,GradingActions.prototype._lastUserId=0,GradingActions.prototype._region=null,GradingActions.prototype.LOWER_RESIZING_LIMIT=5,GradingActions.prototype.UPPER_RESIZING_LIMIT=95,GradingActions.prototype._showActionsForm=function(event,userid){var form=this._region.find("[data-region=grading-actions-form]");userid!=this._lastUserId&&userid>0&&(this._lastUserId=userid),userid>0?form.removeClass("hide"):form.addClass("hide")},GradingActions.prototype._trigger=function(action){$(document).trigger(action)},GradingActions.prototype.getReviewPanelElement=function(){return $('[data-region="review-panel"]')},GradingActions.prototype.hasReviewPanelElement=function(){return this.getReviewPanelElement().length>0},GradingActions.prototype.getCollapseGradePanelButton=function(){return $('[data-region="grade-actions"] .collapse-grade-panel')},GradingActions.prototype.getCollapseReviewPanelButton=function(){return $('[data-region="grade-actions"] .collapse-review-panel')},GradingActions.prototype.getExpandAllPanelsButton=function(){return $('[data-region="grade-actions"] .collapse-none')},GradingActions.prototype.getResizePanelsElement=function(){return document.querySelector('[data-region="resizer"]')},GradingActions.prototype.resetLayoutButtons=function(){this.getCollapseGradePanelButton().removeClass("active"),this.getCollapseReviewPanelButton().removeClass("active"),this.getExpandAllPanelsButton().removeClass("active")},GradingActions.prototype.collapseReviewPanel=function(){$(document).trigger(GradingEvents.COLLAPSE_REVIEW_PANEL),$(document).trigger(GradingEvents.EXPAND_GRADE_PANEL),this.resetLayoutButtons(),this.getCollapseReviewPanelButton().addClass("active"),this.setPanelSplit(0)},GradingActions.prototype.collapseGradePanel=function(){$(document).trigger(GradingEvents.COLLAPSE_GRADE_PANEL),$(document).trigger(GradingEvents.EXPAND_REVIEW_PANEL),this.resetLayoutButtons(),this.getCollapseGradePanelButton().addClass("active"),this.setPanelSplit(100)},GradingActions.prototype.expandAllPanels=function(){$(document).trigger(GradingEvents.EXPAND_GRADE_PANEL),$(document).trigger(GradingEvents.EXPAND_REVIEW_PANEL),this.resetLayoutButtons(),this.getExpandAllPanelsButton().addClass("active"),this.getResizePanelsElement().classList.remove("hide"),this.setPanelSplit(70)},GradingActions.prototype.onResizeStart=function(){this.handleMouseMove=this.onResizing.bind(this),this.handleMouseUp=this.onResizeEnd.bind(this),document.querySelectorAll("iframe").forEach((function(iframe){iframe.classList.add("disable-pointer")})),document.addEventListener("mousemove",this.handleMouseMove),document.addEventListener("mouseup",this.handleMouseUp)},GradingActions.prototype.onResizeEnd=function(){document.querySelectorAll("iframe").forEach((function(iframe){iframe.classList.remove("disable-pointer")})),document.removeEventListener("mousemove",this.handleMouseMove),document.removeEventListener("mouseup",this.handleMouseUp)},GradingActions.prototype.setPanelSplit=function(percentage){(percentage<=0||percentage>=100)&&this.getResizePanelsElement().classList.add("hide"),document.documentElement.style.setProperty("--mod-assign-panel-split",percentage+"%")},GradingActions.prototype.getPanelSplit=function(){const split=getComputedStyle(document.documentElement).getPropertyValue("--mod-assign-panel-split");return parseFloat(split)},GradingActions.prototype.onResizing=function(e){let percentage=e.clientX/document.documentElement.clientWidth*100;if("rtl"===document.documentElement.dir&&(percentage=100-percentage),percentage<this.LOWER_RESIZING_LIMIT||percentage>this.UPPER_RESIZING_LIMIT)return percentage>this.UPPER_RESIZING_LIMIT?this.collapseGradePanel():percentage<this.LOWER_RESIZING_LIMIT&&this.collapseReviewPanel(),void this.onResizeEnd();this.setPanelSplit(percentage)},GradingActions.prototype.registerEventListeners=function(){if(this.hasReviewPanelElement()){var collapseReviewPanelButton=this.getCollapseReviewPanelButton();collapseReviewPanelButton.click(function(e){this.collapseReviewPanel(),e.preventDefault()}.bind(this)),collapseReviewPanelButton.keydown(function(e){e.metaKey||e.shiftKey||e.altKey||e.ctrlKey||13!==e.keyCode&&32!==e.keyCode||(this.collapseReviewPanel(),e.preventDefault())}.bind(this));var collapseGradePanelButton=this.getCollapseGradePanelButton();collapseGradePanelButton.click(function(e){this.collapseGradePanel(),e.preventDefault()}.bind(this)),collapseGradePanelButton.keydown(function(e){e.metaKey||e.shiftKey||e.altKey||e.ctrlKey||13!==e.keyCode&&32!==e.keyCode||(this.collapseGradePanel(),e.preventDefault())}.bind(this));var expandAllPanelsButton=this.getExpandAllPanelsButton();expandAllPanelsButton.click(function(e){this.expandAllPanels(),e.preventDefault()}.bind(this)),expandAllPanelsButton.keydown(function(e){e.metaKey||e.shiftKey||e.altKey||e.ctrlKey||13!==e.keyCode&&32!==e.keyCode||(this.expandAllPanels(),e.preventDefault())}.bind(this));var resizePanelsSlider=this.getResizePanelsElement();resizePanelsSlider.addEventListener("mousedown",function(e){this.onResizeStart(),e.preventDefault()}.bind(this)),resizePanelsSlider.addEventListener("keydown",function(e){if(![37,39,38,40].includes(e.keyCode))return;const isRTL="rtl"===document.documentElement.dir,currentSplit=this.getPanelSplit();var increment=isRTL?-5:5,newValue=currentSplit;37!==e.keyCode&&40!==e.keyCode||(newValue=currentSplit-increment),39!==e.keyCode&&38!==e.keyCode||(newValue=currentSplit+increment);newValue=Math.max(newValue,this.LOWER_RESIZING_LIMIT+3),newValue=Math.min(newValue,this.UPPER_RESIZING_LIMIT-3),this.setPanelSplit(newValue)}.bind(this))}$(document).on("user-changed",this._showActionsForm.bind(this)),this._region.find('[name="savechanges"]').on("click",this._trigger.bind(this,"save-changes")),this._region.find('[name="saveandshownext"]').on("click",this._trigger.bind(this,"save-and-show-next")),this._region.find('[name="resetbutton"]').on("click",this._trigger.bind(this,"reset")),this._region.find("form").on("submit",(function(e){e.preventDefault()}))},GradingActions}));

//# sourceMappingURL=grading_actions.min.js.map